$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '.infFiltros',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar o estoque.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta do estoque.',
          position: 'left'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Botão Gravar',
          description: 'Clique aqui para zerar o estoque dos itens selecionados.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  addPesquisaAutocompleta();

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.zeraestoqueproduto == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, zeraestoqueproduto: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, zeraestoqueproduto: novasColunas }))

      $('#tabelaEstoque').DataTable().columns().visible(true);

      $('#tabelaEstoque').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      let dataSetCols = [];
      const url = '/sisplan/estoque/v1/zeraestoqueproduto?';
      const filtros = await retornaFiltros();

      const response = await requisicao('GET', url, filtros, null, 130000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        limpaDados();
        msgAlerta('Nenhum registro encontrado!');
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach(k => {
        dataSetCols.push({
          'title': k,
          'data': k
        });
      });

      jsonStr.forEach((item, i) => {
        item.SEL = `<div class="icheck-primary d-inline">
          <input type="checkbox" id="checkRegistro${i}" class="campoSelRegistro selected" checked>
          <label for="checkRegistro${i}"></label>
          </div>`
      });

      // criaDataTablePadrao('#tabelaEstoque', true, false, false, true, true, true, '400px', jsonStr, dataSetCols);
      $('#tabelaEstoque').DataTable({
        bPaginate: true,
        destroy: true,
        colReorder: true,
        autoWidth: true,
        columns: dataSetCols,
        data: jsonStr,
        columnDefs: [
          {
            targets: 0,
            // searchable: false
          },
          {
            "targets": [6,7,8,15],
            "className": 'pr-4 text-right'
          }
        ]
      });

      addClassSelected();
      let quantidade = 0;
      $('#tabelaEstoque').DataTable().rows().data().map(item => {
        quantidade += item.QUANTIDADE;
      })
      $('#txtQuantidade').val(quantidade);

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaEstoque_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaEstoque_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#tabelaEstoque th').on('click', function () {
        listaOrdenacao = adicionaOrdenacao(
          retornaDataSrcColuna($('#tabelaEstoque'), $(this)),
          listaOrdenacao
        );
      });

      $('#buttonExcel').on('click', async function () {
        const url = `/sisplan/estoque/v1/zeraestoqueproduto?`;
        const filtros = await retornaFiltros();
        await exportaCSV(url, filtros, false, null, 'Zera Estoque Produto', '#tabelaEstoque');
      })

      $('#tabelaEstoque').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.zeraestoqueproduto).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaEstoque').DataTable().columns().every(function () {
      if ($(this.header()).text() != 'SEL') {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      }
    });

    adicionaColunas(cols, colunasInvisiveis.zeraestoqueproduto ?? [])
  })

  $('#btnGravar').on('click', async function () {
    $("#btnGravar").prop('disabled', true);
    $.LoadingOverlay('show');
    try {
      const registros = $("#tabelaEstoque").DataTable().rows(".selected").data().toArray();

      const registrosSelecionados = registros.map((objeto) => {
        const { SEL, ...novoObjeto } = objeto;
        return novoObjeto;
      });

      if (validaCampos(registrosSelecionados)) {
        await buscaProximoMovimento();
        const url = '/sisplan/estoque/v1/zeraestoqueproduto?';
        const filtros = await retornaFiltros();

        const response = await requisicao('POST', url, filtros, `JSON=${JSON.stringify(registrosSelecionados)}`, 3600000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        } else {
          msgSucesso(`Processo concluído. Número movimento: ${$('#txtMovimento').val()}`);
          await sleep(3000);
          $('#btnConsultar').trigger('click');
        }
      }
    } catch (error) {
      console.log(error);
    } finally {
      $("#btnGravar").prop('disabled', false);
      $.LoadingOverlay('hide');
    }
  });

  $("#tabelaEstoque").on("click", ".campoSelRegistro", function () {
    selecionarLinha("#tabelaEstoque", this);
  });

  async function selecionarLinha(tabela, LinhaSelecionada) {
    if (!$(LinhaSelecionada).closest("tr").hasClass("selected")) {
      $(LinhaSelecionada).closest("tr").addClass("selected");
      data = $(tabela)
        .DataTable()
        .rows($(LinhaSelecionada).parents(".sorting_1"))
        .data();
    } else {
      $(LinhaSelecionada).closest("tr").removeClass("selected");
    }
  }

  $('#check_todos').on('change', function () {
    if ($(`#check_todos`).is(':checked')) {
      $(`#tabelaEstoque`).DataTable().rows().data().$(`.campoSelRegistro`).toArray().filter((campoSel) => $(campoSel).prop('checked', true))
      addClassSelected();
    } else {
      $(`#tabelaEstoque`).DataTable().rows().data().$(`.campoSelRegistro`).toArray().filter((campoSel) => $(campoSel).prop('checked', false))
      addClassSelected(false);
    }
  });

  function addClassSelected(bAdd = true) {
    const tabela = $(`#tabelaEstoque`).DataTable();
    const todasLinhas = tabela.rows().nodes();
    if (bAdd) {
      $(todasLinhas).addClass('selected');
    } else {
      $(todasLinhas).removeClass('selected');
    }
  }

  async function limpaDados(bMovimento = false, bInputs = false) {
    if (bInputs) {
      $('#txtDeposito').empty().trigger('change');
      $('#txtQualidade').empty().trigger('change');
      $('#txtProduto').empty().trigger('change');
      $('#txtColecao').empty().trigger('change');
      $('#txtLinha').empty().trigger('change');
      $('#txtMarca').empty().trigger('change');
      $('#txtCor').empty().trigger('change');
      $('#txtTamanho').empty().trigger('change');
      $('#txtTipoProduto').empty().trigger('change');
      $('#txtLote').val();
      $('#txtGrupo').empty().trigger('change');
      $('#txtEtiqueta').empty().trigger('change');
      $('#txtTipoMov').empty().trigger('change');
      $('#cbDescontarReserva').prop('checked', false);
      $('#cbDescontarExpedicao').prop('checked', false);
      $('#cbEstoqueNegativo').prop('checked', false);
    }

    if ($.fn.DataTable.isDataTable("#tabelaEstoque")) {
      $("#tabelaEstoque").DataTable().rows().remove().draw();
    }

    $('#txtQuantidade').val(0);
  }

  async function buscaProximoMovimento() {
    const movimento = await RetornaProximo('PA_MOV', 'PA_MOV', 'NUM_DOCTO', 6);
    $('#txtMovimento').val(movimento);
  }

  async function retornaFiltros() {
    const retorno =
      `DEPOSITO=${await formataListas($('#txtDeposito').val().toString())}` +
      `&QUALIDADE=${await formataListas($('#txtQualidade').val().toString())}` +
      `&PRODUTO=${await formataListas($('#txtProduto').val().toString())}` +
      `&COLECAO=${await formataListas($('#txtColecao').val().toString())}` +
      `&LINHA=${await formataListas($('#txtLinha').val().toString())}` +
      `&MARCA=${await formataListas($('#txtMarca').val().toString())}` +
      `&COR=${await formataListas($('#txtCor').val().toString())}` +
      `&TAMANHO=${await formataListas($('#txtTamanho').val().toString())}` +
      `&TIPOPRODUTO=${await formataListas($('#txtTipoProduto').val().toString())}` +
      `&LOTE=${$('#txtLote').val()}` +
      `&GRUPO=${await formataListas($('#txtGrupo').val().toString())}` +
      `&ETIQUETA=${await formataListas($('#txtEtiqueta').val().toString())}` +
      `&TIPOMOV=${pegaChave('#txtTipoMov')}` +
      `&DESCONTARESERVA=${$('#cbDescontarReserva').prop('checked') ? 'S' : 'N'}` +
      `&DESCONTAEXPEDICAO=${$('#cbDescontarExpedicao').prop('checked') ? 'S' : 'N'}` +
      `&ESTOQUENEGATIVO=${$('#cbEstoqueNegativo').prop('checked') ? 'S' : 'N'}` +
      `&DOCUMENTO=${$('#txtMovimento').val()}`
    return retorno;
  }

  function addPesquisaAutocompleta() {
    componenteFiltro('deposito', true);
    componenteFiltro('qualidade', true);
    componenteFiltro('produto', true);
    componenteFiltro('colecao', true);
    componenteFiltro('linha', true);
    componenteFiltro('marca', true);
    componenteFiltro('cor', true);
    componenteFiltro('tamanho', true, true);
    componenteFiltro('tipoProduto', true);
    componenteFiltro('grupo', true);
    componenteFiltro('etiqueta', true);
    componenteFiltro('tipoMov', false, false);
  }

  function validaCampos(registrosSelecionados) {
    if (pegaChave('#txtTipoMov') == '') {
      msgAlerta('Necessário informar o tipo de baixa.');
      return false;
    }

    if (!registrosSelecionados.length > 0) {
      msgAlerta('Nenhum registro selecionado. Impossível continuar!');
      return false;
    }
    return true;
  }
});