$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoTipo',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um tipo.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaTipo',
                popover: {
                    title: 'Tabela Tipos',
                    description: 'Aqui estão os dados dos tipos cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    componenteFiltro('tipo', false, false)

    const permissaoUsuarioLogado = await permissaoAcessos("TIPO");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });


    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    consultaTipo();

    $('#btnConsultar').on('click', async function () {
        await consultaTipo(true);
        $('#modal-filtros').modal('hide');
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtTipo').val('');
        $('#rdTodos').prop('checked', true);
    });

    async function consultaTipo(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response;
            const idTipo = pegaChave('#txtTipo') != '' ? ` AND ID = '${pegaChave('#txtTipo')}'` : '';
            const area = $('.rdfiltroArea').filter(':checked').val() != '' ? ` AND AREA = '${$('.rdfiltroArea').filter(':checked').val()}'` : '';
            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"TIPO", "camposSelect":[ "ID", "DESCRICAO", "AREA"],"where": ["1=1 ${idTipo} ${area}"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"TIPO", "camposSelect":[ "ID", "DESCRICAO", "AREA"], "where": null}', null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            if (colunasInvisiveis == null || colunasInvisiveis.acessoCadTipo == undefined) {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadTipo: ['EMPRESA'] }));
                colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            }

            $('#tabelaTipo').DataTable({
                destroy: true,
                lengthChange: true,
                paging: true,
                searching: true,
                scrollX: true,
                scrollY: '350px',
                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    data: "ID",
                    title: "Tipo"
                },
                {
                    data: "DESCRICAO",
                    title: "Descrição"
                },
                {
                    data: "AREA",
                    title: "Área"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

            $('#tabelaTipo_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaTipo_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaTipo").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Tipo', '', '', 999, false, false, dados);
            });

            $('#tabelaTipo').DataTable().columns().every(function () {
                if ((colunasInvisiveis.acessoCadTipo).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaTipo').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoCadTipo ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["ID"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadTipo: novasColunas }));

            $('#tabelaTipo').DataTable().columns().visible(true);

            $('#tabelaTipo').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#btnNovoTipo').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "tipo/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelaTipo').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaTipo').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('TIPO', data.ID);
            if (registroLiberado) {
                window.location.href = `tipo/${data.ID}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaTipo').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaTipo').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('TIPO', data.ID);
            if (registroLiberado) {
                window.location.href = `tipo/${data.ID}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaTipo').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaTipo").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/tipo?", `IDTIPO=${encodeURIComponent(valorLinha.ID)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});