$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovaRegraConsumo',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma regra.',
          position: 'right'
        }
      },
      {
        element: '#tabelaRegras',
        popover: {
          title: 'Tabela Regras',
          description: 'Aqui estão os dados das regras cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("REGRA_CORTINA");

  $('#txtRegra').autocompleta(1, `JSON={ "tabela":"REGRA_CONSUMO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null, "groupby": ["CODIGO", "DESCRICAO"]}`);
  $('#btnRegra').pesquisa('#txtRegra', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGRA_CONSUMO", "camposSelect":[ "CODIGO", "DESCRICAO"], "groupby": ["CODIGO", "DESCRICAO"]}`, 'Pesquisa Regra Consumo', 'REGRA_CONSUMO');
  $('#btnLimpaRegra').on('click', function () {
    $('#txtRegra').val('');
  });

  // $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"CLASSE_COR", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}`);
  // $('#btnGrupo').pesquisa('#txtGrupo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_COR", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Grupo', 'CLASSE_COR');
  // $('#btnLimpaGrupo').on('click', function () {
  //   $('#txtGrupo').val('');
  // });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item btn-editar" type="button" title="Editar">Editar</button>     ' +
      '    <button class="dropdown-item btn-excluir" type="button" title="Excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $('#btnLimparFiltros').on('click', async function () {
    // $('#txtGrupo').val('');
    $('#txtRegra').val('');
    // $('#selectFichaTecnica').val('');
    // $('#selectTipoRegra').val('');
  });

  function buscaParamTipoRegra() {
    const tipos = [];
    if ($('#cbCalculo').is(':checked')) {
      tipos.push("'C'");
    }
    if ($('#cbTabela').is(':checked')) {
      tipos.push("'T'");
    }
    return tipos.join(',');
  }

  function buscaParamsFichaTecnica() {
    const tipos = [];
    if ($('#cbConsumo').is(':checked')) {
      tipos.push("'C'");
    }
    if ($('#cbInformacao').is(':checked')) {
      tipos.push("'I'");
    }
    return tipos.join(',');
  }

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        // const params = `REGRA=${pegaChave('#txtRegra')}&` +
        //   `GRUPO=${pegaChave('#txtGrupo')}&` +
        //   `TIPO_REGRA=${buscaParamTipoRegra()}&` +
        //   `FICHA_TECNICA=${buscaParamsFichaTecnica()}`;
        const response = await requisicao('GET', '/sisplan/regra_cortina/v1/buscar_acesso?', `&REGRA=${pegaChave('#txtRegra')}&`);

        if (!response) return

        const jsonStr = await response.json()

        if (!jsonStr) {
          return;
        }

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        if (colunasInvisiveis == null || colunasInvisiveis.acessoRegraConsumo == undefined) {
          localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoRegraConsumo: ['EMPRESA'] }));
          colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        }

        $('#tabelaRegras').DataTable({
          filter: true,
          info: true,
          paging: true,
          searching: true,
          scrollX: true,
          scrollY: '350px',
          destroy: true,
          order: [[0, 'asc']],
          ordering: true,
          "data": jsonStr,
          "columns": [
            { data: "CODIGO", title: "Código" },
            { data: "DESCRICAO", title: "Descrição" },
            // { data: "GRUPO", title: "Grupo" },
            // { data: "DESC_GRUPO", title: "Desc. Grupo" },
            // { data: "FICHA_TECNICA", title: "Ficha Ténica" },
            // { data: "TIPO", title: "Tipo" }
          ],
          "columnDefs": [
            {
              targets: [0],
              orderable: true,
              render: function (data, type, row) {
                if (type === 'display') {
                  return retornaBotaoOpcoes(data);
                }
                return data;
              }
            }
          ]
        });

        $('#tabelaRegras_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRegras_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const dados = $("#tabelaRegras").DataTable().data().toArray();
          await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Regra Promoção', '', '', 999, false, false, dados);
        });

        $('#tabelaRegras').DataTable().columns().every(function () {
          if ((colunasInvisiveis.acessoRegraConsumo).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });

        $('#tabelaRegras tbody').on('click', '.btn-editar', async function () {
          try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
              let data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
              window.location.href = `regra_cortina/${data.CODIGO}`;
            } else {
              msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
          } catch (error) {
            console.error();
          }
        });

        $('#tabelaRegras tbody').on('dblclick', 'tr', async function () {
          try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
              let data = $('#tabelaRegras').DataTable().row($(this)).data();
              window.location.href = `regra_cortina/${data.CODIGO}`;
            } else {
              msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
          } catch (error) {
            console.error();
          }
        });

        $('#tabelaRegras tbody').on('click', '.btn-excluir', async function () {
          if (permissaoUsuarioLogado.EXCLUI == 'S') {
            let data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
            msgAlerta('Deseja realmente excluir essa regra?', deletaRegra);
          } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
          }

          async function deletaRegra() {
            try {
              $.LoadingOverlay('show');
              try {
                const params = `REGRA=${data.REGRA}&`;

                const response = await requisicao('DELETE', '/sisplan/regra_cortina/v1/regra?', params);

                if (!response) {
                  return;
                }

                if (response.status === 200) {
                  toastr.success(
                    'Regra excluída com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                      error: 'alert-error',
                      info: 'alert-info',
                      success: 'alert-success',
                      warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                      window.location.href = `${BASE_URI}/regra_cortina`;
                    }
                  }
                  ).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px"
                  });
                } else {
                  const jsonStrResp = await response.json();
                  msgErro(jsonStrResp.mensagem);
                }

              } catch (error) {
                console.error(error);
              }
            } finally {
              $.LoadingOverlay('hide');
            }
          }
        });

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRegras').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoRegraConsumo ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["REGRA"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoRegraConsumo: novasColunas }));

      $('#tabelaRegras').DataTable().columns().visible(true);

      $('#tabelaRegras').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  $('#btnNovaRegraConsumo').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "regra_cortina/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').trigger('click');

});
