$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
    });
    driver.defineSteps([]);
    //iniciar tour
    driver.start();
  });
});

$(document).ready(async function () {
  let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));

  if (colunas == null || colunas.tabelaAcessoMercadorias == undefined) {
    localStorage.setItem(
      "colunasInvisiveisRelatorios",
      JSON.stringify({ ...colunas, tabelaAcessoMercadorias: [] })
    );
    colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
  }

  $("#btnConfirmarColunas").on("click", async function () {
    try {
      $.LoadingOverlay("show");

      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem(
        "colunasInvisiveisRelatorios",
        JSON.stringify({ ...colunas, tabelaAcessoMercadorias: novasColunas })
      );

      $("#tabelaAcessoMercadorias").DataTable().columns().visible(true);

      $("#tabelaAcessoMercadorias")
        .DataTable()
        .columns()
        .every(function () {
          if (novasColunas.indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });
    } finally {
      $.LoadingOverlay("hide");
      $("#modal-ColunasVisiveis").modal("hide");
    }
  });

  $('#btnFiltros').on('click', () => {
    $('#modal-filtros').modal('show')
  })

  $('#txtEmpresaSaidaA').pesquisa_variosServerside(1, `{ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_FANTASIA" ], "where": null}`, 'EMP_ID', 'EMP_FANTASIA');
  $('#btnEmpresaSaidaA').pesquisa_serversideSel('#txtEmpresaSaidaA', `{ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_FANTASIA", "EMP_CNPJ"], "where": null}`, 'Pesquisa de Empresa de Saída');
  $('#txtMaterialA').addClass('camposFiltros');
  $('#btnLimpaEmpresaSaidaA').on('click', function () {
    $('#txtEmpresaSaidaA').empty().trigger('change')
    $('#txtEmpresaSaidaA').val('');
    $('#txtEmpresaSaidaA').attr('data-chave', '');
    $('#txtEmpresaSaidaA').attr('data-desc', '');
  })

  $('#txtEmpresaEntradaA').pesquisa_variosServerside(1, `{ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_FANTASIA" ], "where": null}`, 'EMP_ID', 'EMP_FANTASIA');
  $('#btnEmpresaEntradaA').pesquisa_serversideSel('#txtEmpresaEntradaA', `{ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_FANTASIA", "EMP_CNPJ"], "where": null}`, 'Pesquisa de Empresa de Entrada');
  $('#txtMaterialA').addClass('camposFiltros');
  $('#btnLimpaEmpresaEntradaA').on('click', function () {
    $('#txtEmpresaEntradaA').empty().trigger('change')
    $('#txtEmpresaEntradaA').val('');
    $('#txtEmpresaEntradaA').attr('data-chave', '');
    $('#txtEmpresaEntradaA').attr('data-desc', '');
  })

  $('#txtMaterialA').pesquisa_variosServerside(1, `{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'CODIGO', 'DESCRICAO');
  $('#btnMaterialA').pesquisa_serversideSel('#txtMaterialA', `{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa Material');
  $('#txtMaterialA').addClass('camposFiltros');
  $('#btnLimpaMaterialA').on('click', () => {
    $('#txtMaterialA').empty().trigger('change')
    $('#txtMaterialA').val('');
    $('#txtMaterialA').attr('data-chave', '');
    $('#txtMaterialA').attr('data-desc', '');
  })

  $('#txtCorA').pesquisa_variosServerside(1, `{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}`, 'COR', 'DESCRICAO');
  $('#btnCorA').pesquisa_serversideSel('#txtCorA', `{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}`, 'Pesquisa Cor');
  $('#txtCorA').addClass('camposFiltros');
  $('#btnLimpaCorA').on('click', () => {
    $('#txtCorA').empty().trigger('change')
    $('#txtCorA').val('');
    $('#txtCorA').attr('data-chave', '');
    $('#txtCorA').attr('data-desc', '');
  })

  $('#txtQualidadeA').pesquisa_variosServerside(1, `{ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'CODIGO', 'DESCRICAO');
  $('#btnQualidadeA').pesquisa_serversideSel('#txtQualidadeA', `{ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa Qualidade');
  $('#txtQualidadeA').addClass('camposFiltros');
  $('#btnLimpaQualidadeA').on('click', () => {
    $('#txtQualidadeA').empty().trigger('change')
    $('#txtQualidadeA').val('');
    $('#txtQualidadeA').attr('data-chave', '');
    $('#txtQualidadeA').attr('data-desc', '');
  })

  $('#txtNotaFiscalPesquisaA').pesquisa_variosServerside(1, `{ "tabela":"NF_CONF_ENTRA", "camposSelect":[ "NUMERO", "SERIE" ], "where": null, "groupBy": ["NUMERO", "SERIE"]}`, 'NUMERO', 'SERIE');
  $('#btnNotaFiscalPesquisaA').pesquisa_serversideSel('#txtNotaFiscalPesquisaA', `{ "tabela":"NF_CONF_ENTRA", "camposSelect":[ "NUMERO", "SERIE", "CONFERIDA", "IMPRESSO" ], "where": null, "groupBy": ["NUMERO", "SERIE", "CONFERIDA", "IMPRESSO"]}`, 'Pesquisa Nota');
  $('#txtNotaFiscalPesquisaA').addClass('camposFiltros');
  $('#btnLimpaNotaFiscalPesquisaA').on('click', function () {
    $('#txtNotaFiscalPesquisaA').empty().trigger('change')
    $('#txtNotaFiscalPesquisaA').val('');
    $('#txtNotaFiscalPesquisaA').attr('data-chave', '');
    $('#txtNotaFiscalPesquisaA').attr('data-desc', '');
  });

  $('#txtDepositoSaidaA').pesquisa_variosServerside(1, `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'CODIGO', 'DESCRICAO');
  $('#btnDepositoSaidaA').pesquisa_serversideSel('#txtDepositoSaidaA', `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Depósito Saída');
  $('#txtDepositoSaidaA').addClass('camposFiltros');
  $('#btnLimpaDepositoSaidaA').on('click', function () {
    $('#txtDepositoSaidaA').empty().trigger('change')
    $('#txtDepositoSaidaA').val('');
    $('#txtDepositoSaidaA').attr('data-chave', '');
    $('#txtDepositoSaidaA').attr('data-desc', '');
  });

  $('#txtDepositoEntradaA').pesquisa_variosServerside(1, `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'CODIGO', 'DESCRICAO');
  $('#btnDepositoEntradaA').pesquisa_serversideSel('#txtDepositoEntradaA', `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Depósito Entrada');
  $('#txtDepositoEntradaA').addClass('camposFiltros');
  $('#btnLimpaDepositoEntradaA').on('click', function () {
    $('#txtDepositoEntradaA').empty().trigger('change')
    $('#txtDepositoEntradaA').val('');
    $('#txtDepositoEntradaA').attr('data-chave', '');
    $('#txtDepositoEntradaA').attr('data-desc', '');
  });

  $('#txtTonalidadeA').pesquisa_variosServerside(1, `{ "tabela":"NF_CONF_ENTRA", "camposSelect":[ "TONALIDADE", "QUALIDADE" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "QUALIDADE"]}`, 'TONALIDADE', 'QUALIDADE');
  $('#btnTonalidadeA').pesquisa_serversideSel('#txtTonalidadeA', `{ "tabela":"NF_CONF_ENTRA", "camposSelect":[ "TONALIDADE", "ATIVO" ], "where": ["TONALIDADE <> '' OR TONALIDADE IS NOT NULL"], "groupBy": ["TONALIDADE", "ATIVO"]}`, 'Pesquisa de Tonalidade');
  $('#txtTonalidadeA').addClass('camposFiltros');
  $('#btnLimpaTonalidadeA').on('click', () => {
    $('#txtTonalidadeA').empty().trigger('change')
    $('#txtTonalidadeA').val('');
    $('#txtTonalidadeA').attr('data-chave', '');
    $('#txtTonalidadeA').attr('data-desc', '');
  })

  $('#txtLoteA').pesquisa_variosServerside(1, `{ "tabela":"NF_CONF_ENTRA", "camposSelect":[ "NF_CONF_ENTRA.LOTE", "NF_CONF_ENTRA.QUALIDADE"], "leftJoin": [{"tabela": "MAT_ITEN", "condicao": "NF_CONF_ENTRA.LOTE = MAT_ITEN.LOTE"}], "where": ["NF_CONF_ENTRA.LOTE <> '' OR NF_CONF_ENTRA.LOTE IS NOT NULL"], "groupBy": ["NF_CONF_ENTRA.LOTE", "MAT_ITEN.CODIGO"]}`, 'LOTE', 'CODIGO');
  $('#btnLoteA').pesquisa_serversideSel('#txtLoteA', `{ "tabela":"NF_CONF_ENTRA", "camposSelect":[ "NF_CONF_ENTRA.LOTE", "NF_CONF_ENTRA.QUALIDADE", "MAT_ITEN.COR" ], "leftJoin": [{"tabela": "MAT_ITEN", "condicao": "NF_CONF_ENTRA.LOTE = MAT_ITEN.LOTE"}],  "where": ["NF_CONF_ENTRA.LOTE <> '' OR NF_CONF_ENTRA.LOTE IS NOT NULL"], "groupBy": ["NF_CONF_ENTRA.LOTE", "NF_CONF_ENTRA.QUALIDADE", "MAT_ITEN.COR"]}`, 'Pesquisa de Lote');
  $('#txtLoteA').addClass('camposFiltros');
  $('#btnLimpaLoteA').on('click', () => {
    $('#txtLoteA').empty().trigger('change')
    $('#txtLoteA').val('');
    $('#txtLoteA').attr('data-chave', '');
    $('#txtLoteA').attr('data-desc', '');
  })

  $('#txtLoteInternoA').pesquisa_variosServerside(1, `{ "tabela":"NF_CONF_ENTRA", "camposSelect":["LOTE_INTERNO", "QUALIDADE"], "where": ["LOTE_INTERNO <> '' OR LOTE_INTERNO IS NOT NULL"], "groupBy": ["LOTE_INTERNO", "QUALIDADE"]}`, 'LOTE_INTERNO', 'QUALIDADE');
  $('#btnLoteInternoA').pesquisa_serversideSel('#txtLoteInternoA', `{ "tabela":"NF_CONF_ENTRA", "camposSelect":["LOTE_INTERNO", "QUALIDADE"], "where": ["LOTE_INTERNO <> '' OR LOTE_INTERNO IS NOT NULL"], "groupBy": ["LOTE_INTERNO", "QUALIDADE"]}`, 'Pesquisa Lote Interno');
  $('#txtLoteInternoA').addClass('camposFiltros');
  $('#btnLimpaLoteInternoA').on('click', () => {
    $('#txtLoteInternoA').empty().trigger('change')
    $('#txtLoteInternoA').val('');
    $('#txtLoteInternoA').attr('data-chave', '');
    $('#txtLoteInternoA').attr('data-desc', '');
  })

  $('#btnConsultarA').on('click', async () => {
    await buscaDados();
    // try {
    //   $.LoadingOverlay('show')
    //   const params = await retornaFiltros
    //     ()
    //   const response = await requisicao(
    //     'GET',
    //     `/sisplan/impressao/v1/relacessomercadorias?`,
    //     params
    //   );

    //   if (!response) {
    //     return;
    //   }

    //   if (response.status != 200) {
    //     const jsonStr = response.json();
    //     msgErro(jsonStr.mensagem);
    //     return;
    //   }

    // } catch (error) {
    //   console.log(erro)
    // } finally {
    //   $.LoadingOverlay('hide')
    // }
  })

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/relacessomercadorias?`;

        const params = await retornaParams()
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoMercadorias');
        let arquivo = await GeraRelatorio(`${url}${params}`, 'POST', 1000000, false, 'RelAcessoMercadorias');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaFiltros() {
    const filtros = {
      saidaDe: $('#dtSaidaDeA').val(),
      saidaAte: $('#dtSaidaAteA').val(),
      empresaSaida: await formataListas($('#txtEmpresaSaidaA').val().toString()),
      empresaEntrada: await formataListas($('#txtEmpresaEntradaA').val().toString()),
      documentoS: $('#txtDocumentoPesquisaA').val(),
      numero: await formataListas($('#txtNotaFiscalPesquisaA').val().toString()),
      conferido: $('#txtStatusConfEA').val(),
      impresso: $('#txtStatusEnvioEA').val(),
      codigo: await formataListas($('#txtMaterialA').val().toString()),
      cor: await formataListas($('#txtCorA').val().toString()),
      qualidade: await formataListas($('#txtQualidadeA').val().toString()),
      lote: await formataListas($('#txtLoteA').val().toString()),
      loteInterno: await formataListas($('#txtLoteInternoA').val().toString()),
      tonalidade: await formataListas($('#txtTonalidadeA').val().toString()),
      depositoSaida: await formataListas($('#txtDepositoSaidaA').val().toString()),
      depositoEntrada: await formataListas($('#txtDepositoEntradaA').val().toString()),
    }
    return filtros
  }

  async function retornaParams() {
    const filtros = {
      saidaDe: $('#dtSaidaDeA').val(),
      saidaAte: $('#dtSaidaAteA').val(),
      empresaSaida: await formataListas($('#txtEmpresaSaidaA').val().toString()),
      empresaEntrada: await formataListas($('#txtEmpresaEntradaA').val().toString()),
      documentoS: $('#txtDocumentoPesquisaA').val(),
      numero: await formataListas($('#txtNotaFiscalPesquisaA').val().toString()),
      conferido: $('#txtStatusConfEA').val(),
      impresso: $('#txtStatusEnvioEA').val(),
      codigo: await formataListas($('#txtMaterialA').val().toString()),
      cor: await formataListas($('#txtCorA').val().toString()),
      qualidade: await formataListas($('#txtQualidadeA').val().toString()),
      lote: await formataListas($('#txtLoteA').val().toString()),
      loteInterno: await formataListas($('#txtLoteInternoA').val().toString()),
      tonalidade: await formataListas($('#txtTonalidadeA').val().toString()),
      depositoSaida: await formataListas($('#txtDepositoSaidaA').val().toString()),
      depositoEntrada: await formataListas($('#txtDepositoEntradaA').val().toString()),
    }
    return `SAIDA_DE=${filtros.saidaDe}` +
      `&SAIDA_ATE=${filtros.saidaAte}` +
      `&EMPRESA_SAIDA=${filtros.empresaSaida}` +
      `&EMPRESA_ENTRADA=${filtros.empresaEntrada}` +
      `&DOCUMENTO_S=${filtros.documentoS}` +
      `&NUMERO=${filtros.numero}` +
      `&CONFERIDO=${filtros.conferido}` +
      `&IMPRESSO=${filtros.impresso}` +
      `&CODIGO=${filtros.codigo}` +
      `&COR=${filtros.cor}` +
      `&QUALIDADE=${filtros.qualidade}` +
      `&LOTE=${filtros.lote}` +
      `&LOTE_INTERNO=${filtros.loteInterno}` +
      `&TONALIDADE=${filtros.tonalidade}` +
      `&DEPOSITO_SAIDA=${filtros.depositoSaida}` +
      `&DEPOSITO_ENTRADA=${filtros.depositoEntrada}`;
  }

  async function montaPesquisa(colunaOrdenacao = '') {
    try {
      const tipoBanco = await retornaDatabase();
      let fSaidaDe = ''
      let fSaidaAte = ''

      const filtros = await retornaFiltros();

      if (tipoBanco == 'ORACLE') {
        fSaidaDe = filtros.saidaDe != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA >= TO_TIMESTAMP('${filtros.saidaDe} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` : '';
        fSaidaAte = filtros.saidaAte != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA <= TO_TIMESTAMP('${filtros.saidaAte} 23:59:59', 'YYYY-MM-DD HH24:MI:SS')` : '';
      } else {
        fSaidaDe = filtros.saidaDe != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA >= '${filtros.saidaDe}'` : '';
        fSaidaAte = filtros.saidaAte != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA <= '${filtros.saidaAte}'` : '';
      }

      const fEmpresaSaida = filtros.empresaSaida != '' ? ` AND EMPRESA_SAIDA.EMP_ID IN (${filtros.empresaSaida})` : '';
      const fEmpresaEntrada = filtros.empresaEntrada != '' ? ` AND EMPRESA_ENTRADA.EMP_ID IN (${filtros.empresaEntrada})` : '';
      const fDocumentoS = filtros.documentoS != '' ? ` AND NF_CONF_ENTRA.DOCTO_S = '${filtros.documentoS}'` : '';
      const fNumero = filtros.numero != '' ? ` AND NF_CONF_ENTRA.NUMERO IN (${filtros.numero})` : '';
      const fConferido = filtros.conferido != '' ? ` AND NF_CONF_ENTRA.CONFERIDA = '${filtros.conferido}'` : '';
      const fImpresso = filtros.impresso != '' ? ` AND NF_CONF_ENTRA.IMPRESSO = '${filtros.impresso}'` : '';
      const fCodigo = filtros.codigo != '' ? ` AND MATERIAL.CODIGO IN (${filtros.codigo})` : '';
      const fCor = filtros.cor != '' ? ` AND COR.COR IN (${filtros.cor})` : '';
      const fQualidade = filtros.qualidade != '' ? ` AND NF_CONF_ENTRA.QUALIDADE IN (${filtros.qualidade})` : '';
      const fLote = filtros.lote != '' ? ` AND NF_CONF_ENTRA.LOTE IN (${filtros.lote})` : '';
      const fLoteInterno = filtros.loteInterno != '' ? ` AND NF_CONF_ENTRA.LOTE_INTERNO IN (${filtros.loteInterno})` : '';
      const fTonalidade = filtros.tonalidade != '' ? ` AND NF_CONF_ENTRA.TONALIDADE IN (${filtros.tonalidade})` : '';
      const fDepositoSaida = filtros.depositoSaida != '' ? ` AND DEPOSITO_SAIDA.CODIGO IN (${filtros.depositoSaida})` : '';
      const fDepositoEntrada = filtros.depositoEntrada != '' ? ` AND DEPOSITO_ENTRADA.CODIGO IN (${filtros.depositoEntrada})` : '';

      let camposSelect = '';
      let cols = [];

      camposSelect = ["NF_CONF_ENTRA.ID", "NF_CONF_ENTRA.ORIGEM", "NF_CONF_ENTRA.USUARIO USUARIO_ENVIO", "NF_CONF_ENTRA.EMP_ID_ORIGEM", "EMPRESA_SAIDA.EMP_CNPJ EMP_CNPJ_ORIGEM",
        "EMPRESA_SAIDA.EMP_FANTASIA EMP_FANTASIA_ORIGEM", "NF_CONF_ENTRA.DT_SAIDA", "NF_CONF_ENTRA.DOCTO_S", "NF_CONF_ENTRA.NUMERO", "NF_CONF_ENTRA.SERIE", "NF_CONF_ENTRA.CONFERIDA",
        "NF_CONF_ENTRA.IMPRESSO", "NF_CONF_ENTRA.ID_DEP_S", "DEPOSITO_SAIDA.DESCRICAO DESC_DEPOSITO_SAIDA", "NF_CONF_ENTRA.ID_MATERIAL", "MATERIAL.CODIGO", "MATERIAL.CODIGO2",
        "MATERIAL.DESCRICAO DESC_MATERIAL", "NF_CONF_ENTRA.ID_COR", "COR.COR", "COR.DESCRICAO DESC_COR", "NF_CONF_ENTRA.QUALIDADE", "NF_CONF_ENTRA.TAM", "NF_CONF_ENTRA.LOTE",
        "NF_CONF_ENTRA.LOTE_INTERNO", "NF_CONF_ENTRA.TONALIDADE", "NF_CONF_ENTRA.BARRA", "NF_CONF_ENTRA.DT_FAB", "NF_CONF_ENTRA.DT_VAL", "NF_CONF_ENTRA.OBS", "NF_CONF_ENTRA.QTDE",
        "NF_CONF_ENTRA.PESO_BRUTO", "NF_CONF_ENTRA.VALOR", "NF_CONF_ENTRA.TIPO", "NF_CONF_ENTRA.EMP_ID EMPRESA_DESTINO", "EMPRESA_ENTRADA.EMP_CNPJ EMP_CNPJ_DESTINO",
        "EMPRESA_ENTRADA.EMP_FANTASIA EMP_FANTASIA_DESTINO", "NF_CONF_ENTRA.DT_ENTRADA", "NF_CONF_ENTRA.ID_ACE_USU_CONF", "USUARIO.NOME USUARIO_ENTRADA", "NF_CONF_ENTRA.DOCTO_E",
        "NF_CONF_ENTRA.ID_DEP_E", "DEPOSITO_ENTRADA.DESCRICAO DESC_DEPOSITO_ENTRADA", "NF_CONF_ENTRA.TIPO_CONF", "NF_CONF_ENTRA.QTDE_CONFERIDA",
        "NF_CONF_ENTRA.ID_ACE_USU_REJEITADA", "USUARIO.NOME USUARIO_REJEITADA", "NF_CONF_ENTRA.DT_REJEITADA", "NF_CONF_ENTRA.QTDE_REJEITADA", "NF_CONF_ENTRA.DT_CANC", "NF_CONF_ENTRA.ID_ACE_USU_CANC",
        "USUARIO.NOME USUARIO_CANC", "NF_CONF_ENTRA.DOCTO_CANC", "NF_CONF_ENTRA.QTDE_CANC", "(NF_CONF_ENTRA.QTDE-NF_CONF_ENTRA.QTDE_CONFERIDA-NF_CONF_ENTRA.QTDE_CANC-NF_CONF_ENTRA.QTDE_REJEITADA) SALDO"];

      cols = ["ID", "ORIGEM", "USUARIO_ENVIO", "EMP_ID_ORIGEM", "EMP_CNPJ_ORIGEM", "EMP_FANTASIA_ORIGEM", "DT_SAIDA", "DOCTO_S", "NUMERO", "SERIE", "CONFERIDA", "IMPRESSO", "ID_DEP_S", "DESC_DEPOSITO_SAIDA",
        "ID_MATERIAL", "CODIGO", "CODIGO2", "DESC_MATERIAL", "ID_COR", "COR", "DESC_COR", "QUALIDADE", "TAM", "LOTE", "LOTE_INTERNO", "TONALIDADE", "BARRA", "DT_FAB", "DT_VAL", "OBS", "QTDE", "PESO_BRUTO",
        "VALOR", "TIPO", "EMPRESA_DESTINO", "EMP_CNPJ_DESTINO", "EMP_FANTASIA_DESTINO", "DT_ENTRADA", "ID_ACE_USU_CONF", "USUARIO_ENTRADA", "DOCTO_E", "ID_DEP_E", "DESC_DEPOSITO_ENTRADA", "TIPO_CONF",
        "QTDE_CONFERIDA", "ID_ACE_USU_REJEITADA", "USUARIO_REJEITADA", "DT_REJEITADA", "QTDE_REJEITADA", "DT_CANC", "ID_ACE_USU_CANC", "USUARIO_CANC", "DOCTO_CANC", "QTDE_CANC", "SALDO"];

      const leftJoinEmpresaSaida = { "tabela": "EMPRESA", "alias": "EMPRESA_SAIDA", "condicao": `EMPRESA_SAIDA.EMP_ID = NF_CONF_ENTRA.EMP_ID_ORIGEM` };

      const leftJoinDeposito = { "tabela": `DEPOSITO`, "alias": "DEPOSITO_SAIDA", "condicao": `DEPOSITO_SAIDA.ID = NF_CONF_ENTRA.ID_DEP_S` };

      const leftJoinMaterial = { "tabela": "MATERIAL", "condicao": `MATERIAL.ID = NF_CONF_ENTRA.ID_MATERIAL` };

      const leftJoinCor = { "tabela": "CADCOR", "alias": "COR", "condicao": `COR.ID = NF_CONF_ENTRA.ID_COR` };

      const leftJoinEmpresaEntrada = { "tabela": "EMPRESA", "alias": "EMPRESA_ENTRADA", "condicao": `EMPRESA_ENTRADA.EMP_ID = NF_CONF_ENTRA.EMP_ID` };

      const leftJoinUsuario = { "tabela": "ACESSO_USUARIOS", "alias": "USUARIO", "condicao": `USUARIO.ID = NF_CONF_ENTRA.ID_ACE_USU_CONF` };

      const leftJoinDepositoEntrada = { "tabela": "DEPOSITO", "alias": "DEPOSITO_ENTRADA", "condicao": `DEPOSITO_ENTRADA.ID = NF_CONF_ENTRA.ID_DEP_E` };

      const pesquisa = {
        tabela: "NF_CONF_ENTRA",
        camposSelect: camposSelect,
        leftjoin: [leftJoinEmpresaSaida, leftJoinDeposito, leftJoinMaterial, leftJoinCor, leftJoinEmpresaEntrada, leftJoinUsuario, leftJoinDepositoEntrada],
        where: [`1=1 ${fEmpresaSaida} ${fEmpresaEntrada} ${fDocumentoS} ${fNumero} ${fConferido} ${fImpresso} ${fCodigo} ${fCor} ${fQualidade} ${fLote} ${fLoteInterno} ${fTonalidade} ${fDepositoSaida} ${fDepositoEntrada} ${fSaidaDe} ${fSaidaAte}`],
        orderby: ['NF_CONF_ENTRA.DOCTO_S', 'MATERIAL.CODIGO', 'COR.COR', 'NF_CONF_ENTRA.QUALIDADE', 'NF_CONF_ENTRA.LOTE']
      }

      return {
        pesquisa: pesquisa,
        colunas: cols
      }
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    }
  }

  async function buscaDados(colunaOrdenacao = '') {
    if ($.fn.DataTable.isDataTable('#tabelaAcessoMercadorias')) {
      $("#tabelaAcessoMercadorias").DataTable().destroy();
      $("#tabelaAcessoMercadorias").empty();
    }

    // ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
    // ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

    $.LoadingOverlay("show");

    try {
      try {
        // await buscaDepositos();

        const pesquisa = await montaPesquisa(colunaOrdenacao);
        let dataSetCols = [];

        for (let i = 0; i < pesquisa.colunas.length; i++) {
          dataSetCols.push({
            'title': pesquisa.colunas[i],
            'data': pesquisa.colunas[i]
          });
        }

        $('#tabelaAcessoMercadorias').DataTable({
          paging: true,
          colReorder: true,
          lengthChange: true, // habilita o select para mudar a quantidade de itens por página
          lengthMenu: [10, 25, 50, 100], // opções disponíveis no select
          pageLength: 10,
          filter: false,
          info: true,
          order: true,
          autoWidth: true,
          destroy: true,
          serverSide: true,
          processing: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
            type: "POST",
            headers: {
              'Authorization': BASIC_AUTH
            },
            data: {
              EMPRESA: getCookie('empresa'),
              JSON: JSON.stringify(pesquisa.pesquisa),
              CLIENTE: 'N',
            },
            dataSrc: function (data) {
              const cols = pesquisa.colunas;
              const array = data.data;
              return array.map(row => {
                return row.reduce((obj, value, index) => {
                  obj[cols[index]] = value;
                  return obj;
                }, {});
              });
            }
          },
          scrollX: true,
          columns: dataSetCols,
          columnDefs: [
            // {
            //   "targets": [10],
            //   "className": 'pr-4 text-right'
            // }
          ]
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaAcessoMercadorias_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaAcessoMercadorias_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/Sisplan/Funcoes/v1/pesquisa?';
          const pesquisa = await montaPesquisa();
          await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisa.pesquisa))}`, true, null, 'Relatório de Mercadorias', '#tabelaAcessoMercadorias');
        })

        $('#tabelaAcessoMercadorias').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.tabelaAcessoMercadorias).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

        $('#tabelaAcessoMercadorias th').on('click', async function () {
          const nomeColuna = $(this).html();
          const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
          const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
          await buscaDados(nomeColuna + ' ' + ordenacao);
        });

      } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados dos itens.');
      }
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }
  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaAcessoMercadorias').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.tabelaAcessoMercadorias ?? [])
  })
})
