$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar o pedido a ser liberado.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta de pedidos.',
          position: 'left'
        }
      },
      {
        element: '#btnLiberar',
        popover: {
          title: 'Botão Confirmar',
          description: 'Clique aqui para liberar/bloquear os pedidos selecionados.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  addPesquisaAutocompleta();
  await carregaValoresPadroes()
  const parametrosVenda = await BuscaParametrosVenda();
  const bPrecoCorTam = parametrosVenda[5] == "1";

  $('#btnConsultar').on('click', async () => { await buscaPedidos() });

  $('#tabelaPedido').on('click', 'tr', async function () {
    $('.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');
    await buscaItensPedido($(this).closest('tr')[0].children[1].innerHTML);
  });

  $('#btnLiberar').on('click', async function () {
    await gravaDados();
  });

  async function gravaDados() {
    let arrPedidos = [];
    const liberarBloquear = $('#radioLiberar').prop('checked') ? '1' : '0';

    $('.selecionado').closest('tr').map((index, item) => {
      arrPedidos.push({
        NUMERO: item.children[1].innerHTML,
        BLOQUEIO: liberarBloquear
      })
    });

    if (arrPedidos.length == 0) {
      msgAlerta('Nenhum pedido selecionado para liberar.');
      return;
    }

    const response = await requisicao('POST', '/sisplan/pedido/v1/liberapedido?', 'TELA=LIBERACAO_COMERCIAL_WEB', JSON.stringify({ PEDIDOS: arrPedidos }));

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay('hide');
      msgErro(jsonStr.mensagem);
      return;
    }
    criaMensagemSucesso('Liberação efetuada com sucesso.', () => { window.location.reload() })
  }

  async function buscaItensPedido(sPedido) {
    $.LoadingOverlay('show');
    try {
      const itens = await retornaItens(sPedido);
      insereItens(itens);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaPedidos() {
    $.LoadingOverlay('show');
    try {
      const sWhere = await retornaFiltro();
      const sGroupBy = retornaGroupBy();
      const dados = await retornaDados(sWhere, sGroupBy);

      if (dados && dados.length == 0) {
        msgAlerta('Nenhum dado encontrado, favor verificar os filtros.')
        return;
      }

      insereDadosTabela(dados);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function retornaDados(sWhere, sGroupBy) {
    const listaLeftJoin = [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' }, { tabela: 'PED_ITEN', condicao: 'PEDIDO.NUMERO = PED_ITEN.NUMERO' }]
    const camposSelect = ['PEDIDO.NUMERO',
      'ENTIDADE.NOME',
      'SUM(PED_ITEN.QTDE) QTDE_PEND',
      'SUM(PED_ITEN.QTDE * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_PEND',
      'SUM(PED_ITEN.QTDE_F) QTDE_FAT',
      'SUM(PED_ITEN.QTDE_F * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_FAT',
      'SUM(PED_ITEN.QTDE_CANC) QTDE_CANC',
      'SUM(PED_ITEN.QTDE_CANC * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_CANC',
      'SUM(PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) QTDE_TOT',
      'SUM((PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_TOT',];
    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect,
      leftJoin: listaLeftJoin,
      where: [`${sWhere}`],
      groupBy: [sGroupBy]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados do pedido.');
      return;
    }
    return retornoSelect;
  }

  async function retornaItens(sPedido) {
    let camposSelect = [
      'PED_ITEN.CODIGO',
      'COALESCE(PRODUTO.DESCRICAO, MATERIAL.DESCRICAO) DESCRICAO',
      'PED_ITEN.COR',
      'PED_ITEN.TAM',
      'PED_ITEN.QTDE',
      'PED_ITEN.PRECO_ORIG',
      'PED_ITEN.PRECO',
      'PED_ITEN.DESC_ITEM DESCONTO',
    ]

    let tabelasLeftJoin = [
      {
        tabela: 'PRODUTO',
        condicao: 'PRODUTO.CODIGO = PED_ITEN.CODIGO'
      },
      {
        tabela: 'MATERIAL',
        condicao: 'MATERIAL.CODIGO = PED_ITEN.CODIGO'
      }
    ]

    if (!bPrecoCorTam) {
      camposSelect = [
        ...camposSelect,
        '(((COALESCE(CAST(PED_ITEN.PRECO AS DECIMAL(18,5)),0) - COALESCE(TABPRECO.PRECO_MEDIO,0))/COALESCE(CAST(PED_ITEN.PRECO AS DECIMAL(18,5)),0))*100) MARGEM',
        'COALESCE(TABPRECO.PRECO_84,0) PRECO_G',
        'COALESCE(TABPRECO.PRECO_91,0) PRECO_D'
      ]

      tabelasLeftJoin = [
        ...tabelasLeftJoin,
        { tabela: 'TABPRECO', condicao: 'PED_ITEN.CODIGO = TABPRECO.CODIGO' }
      ]
    }

    const dadosSelect = {
      tabela: 'PED_ITEN',
      camposSelect: camposSelect,
      leftJoin: tabelasLeftJoin,
      where: [`PED_ITEN.NUMERO = '${sPedido}'`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  }

  function insereItens(sDados) {
    let dataSetCols = [];

    const keys = Object.keys(sDados[0]);

    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k],
        'title': keys[k]
      });
    };

    let colunasDecimais = [5, 6, 7]

    if (!bPrecoCorTam) {
      colunasDecimais = [
        ...colunasDecimais,
        8,
        9,
        10
      ]
    }

    criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '', sDados, dataSetCols, [], [], [], colunasDecimais, {}, 2, '', '', false, [], [4]);
    $('#tabelaItens').DataTable().columns.adjust().draw(false)
  }

  function insereDadosTabela(sDados) {
    let dataSetCols = [];

    const keys = Object.keys(sDados[0]);
    dataSetCols.push({
      'data': 'SEL',
      'title': 'SEL',
      'width': '15px'
    });

    dataSetCols[0].render = function (data, type, row, meta) {
      return `<div class="icheck-primary d-inline">
								<input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
								<label for="check_col_${meta.row}_row_${meta.col}"></label>
						  </div>`
    };

    for (var k in keys) {
      if (['QTDE_TOT', 'VALOR_TOT'].includes(keys[k])) {
        console.log(keys[k])

        dataSetCols.push({
          'data': keys[k],
          'title': `<span style="color: var(--textDesconto);">${keys[k]}</span>`
        });
      } else {
        dataSetCols.push({
          'data': keys[k],
          'title': keys[k]
        });
      }
    };

    $('#tabelaPedido').DataTable({
      bPaginate: false,
      search: false,
      destroy: true,
      colReorder: true,
      order: [],
      info: false,
      filter: false,
      scrollY: '300px',
      scrollX: true,
      autoWidth: true,
      columns: dataSetCols,
      data: sDados,
      columnDefs: [
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [3, 4, 5, 6, 7, 8, 9, 10],
        },
        {
          targets: [3, 4, 5, 6, 7, 8, 9, 10],
          className: 'pr-4 text-right'
        }
      ],
      createdRow: function (row, data, dataIndex) {
        $('td', row).eq(9).css('color', 'var(--textDesconto)');
        $('td', row).eq(10).css('color', 'var(--textDesconto)');
        $('td', row).eq(10).css('font-weight', 'bold');
        $('td', row).eq(9).css('font-weight', 'bold');
      }
    });

    $('.campoSel').on('click', function () {
      if (this.checked) {
        $(this).addClass('selecionado');
      } else {
        $(this).removeClass('selecionado');
      }
    });
  }

  async function retornaFiltro() {
    let where = ' 1 = 1 ';
    where += $('#txtDtFaturaDe').val() != '' ? ` AND PEDIDO.DT_FATURA >= '${$('#txtDtFaturaDe').val()}' ` : '';
    where += $('#txtDtFaturaAte').val() != '' ? ` AND PEDIDO.DT_FATURA <= '${$('#txtDtFaturaAte').val()}' ` : '';
    where += $('#txtDtEmissaoDe').val() != '' ? ` AND PEDIDO.DT_EMISSAO >= '${$('#txtDtEmissaoDe').val()}' ` : '';
    where += $('#txtDtEmissaoAte').val() != '' ? ` AND PEDIDO.DT_EMISSAO <= '${$('#txtDtEmissaoAte').val()}' ` : '';
    where += $('#txtDtSaidaDe').val() != '' ? ` AND PEDIDO.DT_SAIDA >= '${$('#txtDtSaidaDe').val()}' ` : '';
    where += $('#txtDtSaidaAte').val() != '' ? ` AND PEDIDO.DT_SAIDA <= '${$('#txtDtSaidaAte').val()}' ` : '';
    where += $('#txtPeriodoEntDe').val() != '' ? ` AND PEDIDO.PERIODO >= '${pegaChave('#txtPeriodoEntDe')}' ` : '';
    where += $('#txtPeriodoEntAte').val() != '' ? ` AND PEDIDO.PERIODO <= '${pegaChave('#txtPeriodoEntAte')}' ` : '';
    where += $('#txtPedido').val().length > 0 ? ` AND PEDIDO.NUMERO IN (${await formataListas($('#txtPedido').val().toString())}) ` : '';
    where += $('#txtCliente').val() != '' ? ` AND PEDIDO.CODCLI = '${pegaChave('#txtCliente')}' ` : '';
    where += $('#txtRepresentante').val() != '' ? ` AND PEDIDO.CODREP = '${pegaChave('#txtRepresentante')}' ` : '';
    where += $('#txtColecao').val() != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecao')}' ` : '';
    where += $('#radioBloqVendas').prop('checked') ? ` AND PEDIDO.BLOQUEIO = '0' ` : '';
    where += $('#radioBloqFinan').prop('checked') ? ` AND PEDIDO.FINANCEIRO = '0' ` : '';
    where += $('#radioBloqVendLibFinan').prop('checked') ? ` AND (PEDIDO.BLOQUEIO = '0' AND PEDIDO.FINANCEIRO = '1') ` : '';
    where += $('#radioBloqExp').prop('checked') ? ` AND PEDIDO.FINANCEIRO = '2' ` : '';
    where += $('#txtStatus').val() != '' ? ` AND PEDIDO.STATUS = '${pegaChave('#txtStatus')}' ` : '';
    where += $('#txtTipoVenda').val() != '' ? ` AND PEDIDO.ID_TIPO = ${pegaChave('#txtTipoVenda')}` : ''

    where += $('#rgPedidoExpPendente').prop('checked') ? `AND (SELECT SUM(COALESCE(PEDIDO3.QTDE, 0)) QTDE FROM [PEDIDO3] PEDIDO3 where PEDIDO3.NUMERO = PEDIDO.NUMERO) > 0` : '';
    where += $('#rgPedidoSemExpedicao').prop('checked') ? `AND (SELECT SUM(COALESCE(PEDIDO3.QTDE, 0)) QTDE FROM [PEDIDO3] PEDIDO3 where PEDIDO3.NUMERO = PEDIDO.NUMERO) <= 0` : '';

    where += ` AND PEDIDO.EMP_ID = '${getCookie('emp_id')}' `;
    return where;
  }

  function retornaGroupBy() {
    let groupBy = 'PEDIDO.NUMERO, ENTIDADE.NOME'

    groupBy += $('#rgPedidoPendentes').prop('checked') || $('#rgPedidoExpPendente').prop('checked') || $('#rgPedidoSemExpedicao').prop('checked') ? ` HAVING SUM(COALESCE(PED_ITEN.QTDE, 0)) > 0 ` : '';
    groupBy += $('#rgPedidoFaturados').prop('checked') ? ` HAVING SUM(COALESCE(PED_ITEN.QTDE_F, 0)) > 0 ` : '';
    groupBy += $('#rgPedidoParcFat').prop('checked') ? ` HAVING SUM(COALESCE(PED_ITEN.QTDE_F, 0)) > 0 AND SUM(COALESCE(PED_ITEN.QTDE, 0)) > 0 ` : '';

    return groupBy
  }

  async function carregaValoresPadroes() {
    try {
      const jsonStr = await buscaValoresPadroes('PEDIDO')

      jsonStr.map(async item => {
        switch (item.CAMPO) {
          case 'STATUS_LIB_COMERCIAL': {
            insereValor('#txtStatus', item.VALOR, { tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR })
            break;
          }
          default:
            break;
        }
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os valores padrões.`)
    }
  };

  function addPesquisaAutocompleta() {
    componenteFiltro('pedido', true)
    componenteFiltro('status', false)

    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
    $('#btn-Cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Cliente");
    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').val(''); });

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`,);
    $('#btn-Representante').pesquisa_array(['#txtRepresentante'], ['CODREP'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome" ], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`, "Pesquisa Represen", "represen");
    $('#btn-limpa-Representante').on('click', function () { $('#txtRepresentante').val(''); });

    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Colecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Coleção', 'colecao');
    $('#btn-limpa-Colecao').on('click', function () { $('#txtColecao').val('') });

    $('#txtPeriodoEntDe').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PeriodoEntDe').pesquisa('#txtPeriodoEntDe', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btn-limpa-PeriodoEntDe').on('click', function () {
      $('#txtPeriodoEntDe').val('');
    });

    $('#txtPeriodoEntAte').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PeriodoEntAte').pesquisa('#txtPeriodoEntAte', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btn-limpa-PeriodoEntAte').on('click', function () {
      $('#txtPeriodoEntAte').val('');
    });
    componenteFiltro('tipo', false, false, 'TipoVenda', ["AREA = 'COM'"])
  }
});