<?php include_once('../../config.php') ?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Loja</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.259.1.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.259.1.1">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="../plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.259.1.1">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="../plugins/daterangepicker/daterangepicker.css?versao=3.259.1.1">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="../dist/css/animate.min.css?versao=3.259.1.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.259.1.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.259.1.1">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.259.1.1">
  <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/highlight.js/10.7.2/styles/default.min.css?versao=3.259.1.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.259.1.1" />
  <link rel="shortcut icon" href="../favicon.ico">
  <link href="../dist/css/jquery.gridly.css" rel="stylesheet" type="text/css?versao=3.259.1.1" />
  <link href='../dist/css/bootstrap.min.css?versao=3.259.1.1'>
  <link rel="stylesheet" href="../dist/css/normalize.css?versao=3.259.1.1">
  <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.259.1.1">
  <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.259.1.1">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.259.1.1">
  <link href='../dist/css/bootstrap.min.css?versao=3.259.1.1'>
  <link rel="stylesheet" href="../dist/css/normalize.css?versao=3.259.1.1">
  <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.259.1.1">
  <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.259.1.1">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.259.1.1">
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.259.1.1">
  <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">

  <style type="text/css">
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 50%;
      float: left;
      position: relative
    }

    .select2-container--default .select2-selection--single {
      height: 38px !important;
    }

    #area-graficos {
      text-align: center;
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .gridly {
      margin-left: auto;
      margin-right: auto;
      position: relative;
      width: 960px;
      background-color: rgb(255 255 255 / 2%);
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      padding: 0 0 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px !important;
    }

    .quadrados {
      display: flex;
      align-items: center;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
      color: black;
    }

    .quadrado {
      cursor: pointer;
      margin-right: 20px;
      margin-top: 5px;
      height: 80px;
      width: 140px;
      background-color: var(--blue-color);
      color: #fff !important;
      display: flex;
      align-items: center;
      justify-content: space-around;
      position: relative;
    }

    .brick {
      display: flex;
    }

    .brick.small {
      width: 140px;
      height: 200px;
    }

    .brick.large {
      width: 300px;
      height: 200px;
    }

    .brick.extralarge {
      width: 460px;
      height: 200px;
    }

    .brick.big {
      width: 620px;
      height: 200px;
    }

    .brick.extrabig {
      width: 780px;
      height: 200px;
    }

    .brick.masterbig {
      width: 940px;
      height: 200px;
    }

    .brick p {
      text-align: center;
      vertical-align: middle;
      font-size: 25px;
      flex: 1;
      display: flex;
      align-content: space-around;
      align-items: flex-end;
      justify-content: center;
      flex-wrap: wrap;
      flex-direction: row;
    }

    .info-box-text {
      font-size: 20px;
      font-weight: bold;
    }

    .example .brick {
      opacity: 1;
      cursor: pointer;
      position: relative;
      text-align: center;
    }

    .example .brick .delete,
    .quadrado .delete {
      display: block;
      color: #FFF;
      background: rgba(255, 255, 255, 0.2);
      width: 40px;
      height: 40px;
      top: 0;
      right: 0;
      position: absolute;
      text-align: center;
      line-height: 40px;
    }

    .example .brick .edit,
    .quadrado .edit {
      display: block;
      color: #FFF;
      background: rgba(255, 255, 255, 0.2);
      width: 40px;
      height: 40px;
      top: 0;
      left: 0;
      position: absolute;
      text-align: center;
      line-height: 40px;
    }

    .example .brick.dragging {
      opacity: 0.8;
    }

    .example .brick {
      background-color: var(--blue-color);
      color: #fff !important;
    }

    .modal-body {
      max-height: calc(100vh - 210px);
      overflow-y: auto;
    }

    section {
      height: 100%;
      width: 100%;
    }

    #inputColor :focus {
      background-color: transparent !important;
      border: none !important;
    }

    /* #dashboard {} */
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">

  <div class="container-fluid">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6 flex">
            <div style="text-align:center;" class="mt-2">
              <button class="btn d-none" onclick="toggleTheme()">
                <i style="font-size: 25px" id="themeIcon" class="text-white fas"></i>
              </button>
            </div>
            <h1 class="m-0 text-dark">Dashboard:
              <span id="id-dash">1</span>
            </h1>
          </div>
          <div class="col-sm-6">
            <!-- <ol class="breadcrumb float-sm-right">
              
              <li class="breadcrumb-item"><a href="../dashboard">Dashboards</a></li>
              <li class="breadcrumb-item active">Editar Dashboard</li>
            </ol> -->
          </div>
        </div>
    </section>

    <section class="content-header">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-4">
            <label for="txtNomeDash">Nome: </label>
            <input type="text" placeholder="Nome Dash." class="input-default focus form-control" id="txtNomeDash" name="txtNomeDash">
          </div>
          <div class="col-sm-2">
            <label for="txtTempoDash">Tempo Atualização (minutos): </label>
            <input type="number" min="0" placeholder="Tempo Atualização" class="input-default focus form-control" id="txtTempoDash" name="txtTempoDash">
          </div>
          <div class="col-sm-2">
            <label for="txtOrdemDash">Ordem: </label>
            <input type="number" min="0" placeholder="Ordem" class="input-default focus form-control" id="txtOrdemDash" name="txtOrdemDash">
          </div>
          <div class="col-sm-2">
            <label for="txtGrupoDash">Grupo: </label>
            <!-- <input type="number" min="0" placeholder="Grupo" class="input-default focus form-control" id="txtGrupoDash" name="txtGrupoDash"> -->
            <select class="input-default" id="txtGrupoDash">

            </select>
          </div>
          <div class="col-sm-12 mt-2">
            <button id="btn-dataset" title="Obter Dados" type="button" class="btn btn-sisp btn-sm btn-secondary">
              <b>Obter Dados</b> <i class="fas fa-database"></i></button>
            <button id="btn-filtros" title="Filtros" type="button" class="btn btn-sisp btn-sm btn-secondary">
              <b>Filtros</b> <i class="fas fa-filter"></i></button>
            <button id="btn-novo" title="Novo Gráfico" type="button" class="btn btn-sisp btn-sm btn-primary"><b>Novo
                Gráfico</b> <i class="fas fa-chart-bar"></i></button>
            <button id="btn-salvar" title="Salvar Dash" type="button" class="btn btn-sisp btn-sm btn-danger">
              <b>Salvar</b> <i class="fas fa-save"></i></button>
            <button id="btn-testar" title="Testar Dash" type="button" class="btn btn-sisp btn-sm btn-dark">
              <b>Testar</b> <i class="fas fa-chart-line"></i></button>
          </div>
          <section id="dashboard" class="content example">
            <div class="container-fluid mt-2">
              <h1 id="dados">Dados</h1>
              <div id="panel-datasets" class="row ml-2 mr-2 mt-2 quadrados">
              </div>
            </div>
            <div class="container-fluid mt-2">
              <h1 id="graficos">Gráficos</h1>
            </div>
            <div id="area-graficos" class="container-fluid mt-2">
              <div id="panel" class="ml-2 mr-2 mt-2 gridly">
              </div>
            </div>
            <div class="modal fade" id="modal-edit" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-lg">
                <div class="modal-content modal-lg">
                  <div class="modal-header">
                    <h4 id="modal-titulo" class="modal-title">Editar Gráfico: </h4>
                    <h4 class="modal-title" id="id-grafico"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body pl-5 pr-5">
                    <div class="row">
                      <div class="col-sm-12">
                        <h2 class="fs-title">Configurações Gráfico</h2>
                      </div>
                      <div class="col-sm-12">
                        <div class="group-default">
                          <label for="txtNomeGrafico">Nome</label>
                          <div class="relative">
                            <input type="text" placeholder="Nome" class="d-none" id="txtIdGrafico" name="txtIdGrafico">
                            <input type="text" placeholder="Nome" class="d-none" id="txtProporcao" name="txtProporcao" value="1">
                            <input type="text" placeholder="Nome" class="d-none" id="txtOrdem" name="txtOrdem">
                            <input type="text" placeholder="Nome" autocomplete='off' class="input-default focus form-control" id="txtNomeGrafico" name="txtNomeGrafico">
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <label>Tipo Gráfico</label>
                        <div class="input-group">
                          <select class="form-control select2 select2-danger focus" id="select_tipo" name="select_tipo" data-trigger="change" data-html="true" data-placement="left" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            <option id="opt-card" value="0" selected="selected">Card</option>
                            <option id="opt-barras" value="1">Barras</option>
                            <option id="opt-colunas" value="2">Colunas</option>
                            <option id="opt-linha" value="3">Linha</option>
                            <option id="opt-pizza" value="4">Pizza</option>
                            <option id="opt-rosca" value="5">Rosca</option>
                            <option id="opt-grid" value="6">Grid</option>
                            <option id="opt-mapa" value="7">Mapa</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_apresentacao'>
                        <label>Apresentação de Valores</label>
                        <div class="input-group">
                          <select class="form-control select2 select2-danger focus" id="select_valores" name="select_valores" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            <option value="0" selected="selected">Inteiro</option>
                            <option value="1">Decimal (2 casas)</option>
                            <option value="2">Monetário(R$)</option>
                            <option value="3">Texto</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <label>DataSet</label>
                        <div class="input-group">
                          <select class="form-control select2 select2-danger focus" id="select_dataset" name="select_dataset" data-dropdown-css-class="select2-danger" style="width: 100%;">
                          </select>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_eixo'>
                        <div class="group-default">
                          <label for="txtEixo">Eixo</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtEixo" name="txtEixo" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_cidade' title="No select deve ter uma coluna com alias chamado CODIGO_CIDADE e esse deve ser o campo CODIGO da tabela CIDADE">
                        <div class="group-default">
                          <label for="txtCidade">Coluna Cidade</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtCidade" name="txtCidade" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_estado' title="No select deve ter uma coluna com alias chamado CODIGO_CIDADE e esse deve ser o campo CODIGO da tabela CIDADE">
                        <div class="group-default">
                          <label for="txtEstado">Coluna Estado</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtEstado" name="txtEstado" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <div class="group-default">
                          <label for="txtValor">Valor</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtValor" name="txtValor" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_tipo_valor'>
                        <div class="group-default">
                          <label for="txtTipoValor">Tipo Valor</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtTipoValor" name="txtTipoValor" data-dropdown-css-class="select2-danger" style="width: 100%;">
                              <option value="0" selected="selected">Soma</option>
                              <option value="1">Média</option>
                              <option value="2">Máximo</option>
                              <option value="3">Mínimo</option>
                              <option value="4">Contagem</option>
                              <option value="5">Contagem(distinta)</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_texto_valor'>
                        <div class="group-default">
                          <label for="editor">Texto Valor</label>
                          <div class="relative" id="editor">
                          </div>
                        </div>
                      </div>

                      <div class="col-sm-12" id='div_tipo_ordenacao'>
                        <div class="group-default">
                          <label for="txtTipoOrdenacao">Tipo Ordenação</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtTipoOrdenacao" name="txtTipoOrdenacao" data-dropdown-css-class="select2-danger" style="width: 100%;">
                              <option value="-1" selected="selected">Nenhuma</option>
                              <option value="0" selected="selected">Decrescente</option>
                              <option value="1">Crescente</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_campo_ordenacao'>
                        <div class="group-default">
                          <label for="txtCampoOrdenacao">Campo Ordenação</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtCampoOrdenacao" name="txtCampoOrdenacao" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_maximo_registros'>
                        <div class="group-default">
                          <label for="txtMaxRegistros">Máximo de Registros</label>
                          <div class="relative">
                            <input type="number" min=0 placeholder="Máximo de Registros" class="input-default focus form-control" id="txtMaxRegistros" name="txtMaxRegistros">
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_tamanho_fonte'>
                        <div class="group-default">
                          <label for="txtTamanhoFonte">Tamanho Fonte (pixel)</label>
                          <div class="relative">
                            <input type="number" min=0 placeholder="Tamanho da fonte, ex: 15" class="input-default focus form-control" id="txtTamanhoFonte" name="txtTamanhoFonte">
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_tamanho_card'>
                        <div class="group-default">
                          <label for="txtTamanhoCard">Tamanho Card (pixel)</label>
                          <div class="relative">
                            <input type="number" min=0 placeholder="Tamanho do card, ex: 200" class="input-default focus form-control" id="txtTamanhoCard" name="txtTamanhoCard">
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="row col-sm-12 mt-2 mb-2" id="CoresCards">
                      <label for="txtCorCard">Cor do Card</label>
                      <div class="btn-group align-center" style="display: flex;flex-direction: row;flex-wrap: wrap;grid-gap: 5px;">
                        <div class="rounded mr-2" style="background-color: #343a40; color:#FFF;">
                          <div class="icheck-gray" style="margin: 0 !important; padding: 5px 10px 5px 7px;">
                            <input type="radio" class="mr-2" id="cardColorCinza" name="radioColorCard" value="#343a40">
                            <label class="form-check-label" for="cardColorCinza">
                              <span class=" ">Cinza</span>
                            </label>
                          </div>
                        </div>

                        <div class="rounded mr-2" style="background-color: #007bff; color:#FFF;">
                          <div class="icheck-gray" style="margin: 0 !important; padding: 5px 10px 5px 7px;">
                            <input type="radio" class="mr-2" id="cardColorAzul" name="radioColorCard" value="#007bff">
                            <label class="form-check-label" for="cardColorAzul">
                              <span class=" ">Azul</span>
                            </label>
                          </div>
                        </div>

                        <div class="rounded mr-2" style="background-color: #ffc107; color:#343a40;">
                          <div class="icheck-gray" style="margin: 0 !important; padding: 5px 10px 5px 7px;">
                            <input type="radio" class="mr-2" id="cardColorAmarelo" name="radioColorCard" value="#ffc107">
                            <label class="form-check-label" for="cardColorAmarelo">
                              <span class=" ">Amarelo</span>
                            </label>
                          </div>
                        </div>

                        <div class="rounded mr-2" style="background-color: #28a745; color:#FFF;">
                          <div class="icheck-gray" style="margin: 0 !important; padding: 5px 10px 5px 7px;">
                            <input type="radio" class="mr-2" id="cardColorVerde" name="radioColorCard" value="#28a745">
                            <label class="form-check-label" for="cardColorVerde">
                              <span class=" ">Verde</span>
                            </label>
                          </div>
                        </div>

                        <!-- Opção cardColorCustom -->
                        <div class="bg-color-primary rounded mr-2" style="background-color: transparent; border: 1px solid; color: var(--font-color)">
                          <div class="icheck-gray" style="margin-bottom: 0 !important; padding: 0px 9px 0px 6px;">
                            <input type="radio" class="mr-2" id="cardColorCustom" name="radioColorCard" value="">
                            <label class="form-check-label d-flex " for="cardColorCustom" style="margin-top: 5px !important;">
                              <span class="text-muted">Personalizado</span>
                              <input type="color" id="inputColor" class="ml-1" style="background-color: transparent; border:none; padding-bottom: 5px">
                            </label>
                          </div>
                          <div id="hexColor"></div>
                        </div>
                        <br />

                        <!-- Opção cardColorCustom -->
                        <div class="bg-color-primary rounded mr-2" style="background-color: transparent; border: 1px solid; color: var(--font-color)">
                          <div class="icheck-gray" style="margin-bottom: 0 !important; padding: 0px 9px 0px 6px;">
                            <input type="radio" class="mr-2" id="cardColorGradient" name="cardColorGradient" value="">
                            <label class="form-check-label d-flex " for="cardColorGradient" style="margin-top: 5px !important;">
                              <span class="text-muted">Gradiente</span>
                              <input type="color" id="inputGradientIni" class="ml-1" style="background-color: transparent; border:none; padding-bottom: 5px">
                              <input type="color" id="inputGradientFim" class="ml-1" style="background-color: transparent; border:none; padding-bottom: 5px">
                            </label>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="row col-sm-12" id="divTextoCard">
                      <div class="group-default">
                        <label for="txtHintGrafico">Texto Informativo</label>
                        <div class="relative">
                          <textarea id="txtHintGrafico" class="autoExpand forumPost form-control" rows="5" placeholder="Texto Informativo"></textarea>
                        </div>
                      </div>
                    </div>

                    <div class="row mt-2" id="divIconeCard">
                      <div class="col-sm-8 group-default">
                        <label for="txtSelectIcone">Ícone</label>
                        <div class="relative">
                          <select class="form-control select2 select2-danger focus" name="txtSelectIcone" data-dropdown-css-class="select2-danger" style="width: 100%;" id="txtSelectIcone">
                          </select>
                        </div>
                      </div>
                      <div class="col-sm-4" style="display: flex;align-items: flex-end;justify-content: flex-start;">
                        <div id="selectedIcon"></div>
                      </div>
                    </div>



                  </div>
                  <div class="modal-footer">
                    <input id="btn-confirmar-edit" type="button" name="next" class="btn btn-danger btn-sisp next action-button" value="Concluir" />
                  </div>
                </div>
              </div>
            </div>
            <div class="modal fade" id="modal-dataset" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-lg">
                <div class="modal-content modal-lg">
                  <div class="modal-header">
                    <h4 id="modal-titulo" class="modal-title">Consulta de Dados: </h4>
                    <h4 class="modal-title" id="id-dataset"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                      <div class="col-sm-12">
                        <div class="row">
                          <div class="col-sm-12">
                            <div class="group-default">
                              <label for="txtNomeDataSet">Nome</label>
                              <div class="relative">
                                <input id="txtNomeDataSet" name="txtNomeDataSet" type="text" placeholder="Nome" class="input-default focus form-control">
                                <input id="txtIdDataSet" name="txtIdDataSet" type="text" placeholder="Nome" class="d-none">
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-12">
                            <div class="group-default form-group">
                              <label data-error="wrong" data-success="right">SQL</label>
                              <textarea id="txtSelect" class="autoExpand forumPost form-control" rows="10" placeholder="Monte o SQL aqui"></textarea>
                            </div>
                          </div>
                          <div class="col-sm-12">
                            Opções disponíveis para se utilizar no sql <br />
                            :EMP_PAT = Irá substituir o campo ':EMP_PAT' dentro do SQL, pelo emp_path da empresa logada. Ex: '_001' <br />
                            :EMP_ID = Irá substituir o campo ':EMP_ID' dentro do SQL, pelo emp_id da empresa logada. Ex: '1' <br />
                            :COD_USUARIO = Irá substituir o campo ':COD_USUARIO' dentro do SQL, pelo código de usuário logado. Ex: '0000' <br />
                            <div class="row">
                              <div class="col-sm-12" title="Quando usado em um gráfico do tipo barra horizontal ou vertical, é a cor da barra.">
                                <div class="bg-color-primary rounded mr-2 mt-2" style="background-color: transparent; border: 1px solid; color: var(--font-color)">
                                  <label class="form-check-label d-flex " for="inputDatasetColor" style="margin-left: 5px; margin-top: 5px !important;">
                                    <span class="text-muted">Cor Dataset</span>
                                    <input type="color" id="inputDatasetColor" class="ml-1" style="background-color: transparent; border:none; padding-bottom: 5px">
                                  </label>
                                  <div id="hexColor"></div>
                                </div>
                              </div>
                            </div>
                            <button id="btn-validar" type="button" class="btn btn-danger btn-sisp float-right mt-2">Validar</button>
                            <button id="btn-identar" type="button" class="btn btn-success btn-sisp float-right mt-2 ml-2 mr-2">Identar</button>
                          </div>

                          <div class="col-sm-12">
                            <h5>
                              Resultado SQL
                            </h5>
                          </div>
                          <div id="resultados" class="col-sm-12 table-responsive">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" id="btn-confirmar-dataset" class="btn btn-primary btn-sisp">Confirmar</button>
                  </div>
                </div>
              </div>
            </div>

            <div class="modal fade" id="modal-filtros" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-xl">
                <div class="modal-content modal-xl">
                  <div class="modal-header">
                    <h4 id="modal-titulo" class="modal-title">Filtros: </h4>
                    <h4 class="modal-title" id="id-dataset"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">
                    <div class=" container-fluid row">
                      <div class="col-sm-6">
                        <h4>Lista de filtros</h4>
                        <div class="table-responsive">
                          <table id="tabela-filtros" class="table table-sm table-hover" style="width: 100%" width="100%">
                            <thead>
                            </thead>
                            <tbody></tbody>
                          </table>
                        </div>
                      </div>
                      <div class="col-sm-6 flex flex-column p-3">
                        <h4>Cadastro</h4>
                        <div class="row mb-2" style="grid-gap: 8px" id="panelFiltrosCad">
                          <div class="col-sm-12 d-none">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtOrdemFiltro">Ordem:</label>
                            <div class="input-group">
                              <input type="number" class="input-default focus form-control" id="txtOrdemFiltro" name="txtOrdemFiltro" class="form-control" placeholder="Ordem">
                            </div>
                          </div>
                          <div class="col-sm-12">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtNomeFiltro">Nome:</label>
                            <div class="input-group">
                              <input disabled type="text" class="input-default focus form-control" title="Campo identificador para trocar no sql pelo valor informado. Ex: CODIGO" id="txtNomeFiltro" name="txtNomeFiltro" class="form-control" placeholder="Nome">
                            </div>
                          </div>
                          <div class="col-sm-12">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtLabelFiltro">Label:</label>
                            <div class="input-group">
                              <input disabled type="text" class="input-default focus form-control" title="Label do campo que irá aparecer na tela de filtros. Ex: Setor:" id="txtLabelFiltro" name="txtLabelFiltro" class="form-control" placeholder="Label">
                            </div>
                          </div>
                          <div class="col-sm-12">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtTipoFiltro">Tipo:</label>
                            <div class="input-group">
                              <select disabled style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="txtTipoFiltro" class="custom-select focus">
                                <option selected value="0">Texto</option>
                                <option value="1">Data</option>
                                <option value="2">Número</option>
                              </select>
                            </div>
                          </div>
                          <div class="col-sm-12 camposTexto">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtTabelaFiltro">Tabela:</label>
                            <div class="input-group">
                              <input disabled type="text" class="input-default focus form-control" id="txtTabelaFiltro" name="txtTabelaFiltro" class="form-control" placeholder="Tabela">
                              <div class="input-group-append">
                                <button class="btn bg-danger" id="btnTabelaFiltro" name="btnTabelaFiltro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btnLimpaTabelaFiltro" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-12 camposTexto">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtCampoFiltro">Campo:</label>
                            <div class="input-group">
                              <input disabled type="text" class="input-default focus form-control" id="txtCampoFiltro" name="txtCampoFiltro" class="form-control" placeholder="Campo">
                              <div class="input-group-append">
                                <button class="btn bg-danger" id="btnCampoFiltro" name="btnCampoFiltro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btnLimpaCampoFiltro" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-12 camposTexto">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtCampoDescFiltro">Descrição:</label>
                            <div class="input-group">
                              <input disabled type="text" class="input-default focus form-control" id="txtCampoDescFiltro" name="txtCampoDescFiltro" class="form-control" placeholder="Descrição">
                              <div class="input-group-append">
                                <button class="btn bg-danger" id="btnCampoDescFiltro" name="btnCampoDescFiltro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btnLimpaCampoDescFiltro" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-12" title="Valor Padrão que irá preenchido quando o usuário for de fato usar o dashboard">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtValorPadraoFiltro">Valor Padrão:</label>
                            <div class="input-group">
                              <input disabled type="text" class="input-default focus form-control" id="txtValorPadraoFiltro" name="txtValorPadraoFiltro" class="form-control" placeholder="Valor Padrão">
                            </div>
                          </div>
                          <div class="col-sm-12 camposData d-none">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtOpcaoData">Opção Data:</label>
                            <div class="input-group">
                              <select disabled style="width:100%;" class="form-control select2 select2-danger focus d-none" data-dropdown-css-class="select2-danger" id="txtOpcaoData" class="custom-select focus">
                                <option selected value="0">Nenhuma</option>
                                <option value="1">Data do dia</option>
                                <option value="2">Primeiro Dia do Mês</option>
                                <option value="3">Último Dia do Mês</option>
                                <option value="4">Primeiro Dia do Ano</option>
                                <option value="5">Último Dia do Ano</option>
                              </select>
                            </div>
                          </div>
                          <div class="col-sm-12 camposTexto" title="Valor fixo que será usado apenas para testar o SQL">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtValorTesteFiltro">Valor Teste:</label>
                            <div class="input-group">
                              <input disabled type="text" class="input-default focus form-control" id="txtValorTesteFiltro" name="txtValorTesteFiltro" class="form-control" placeholder="Valor Teste">
                            </div>
                          </div>
                          <div class="col-sm-6 camposTexto">
                            <div class="icheck-primary mr-3">
                              <input disabled type="checkbox" id="cbVariosFiltro" name="cbVariosFiltro"><label for="cbVariosFiltro">Buscar Vários</label>
                            </div>
                          </div>
                          <div class="col-sm-6 camposTexto">
                            <div class="icheck-primary mr-3">
                              <input disabled type="checkbox" id="cbEmpId" name="cbEmpId"><label for="cbEmpId">Filtrar por emp_id</label>
                            </div>
                          </div>
                          <div class="col-sm-12">
                            <div class="icheck-primary mr-3">
                              <input disabled type="checkbox" id="cbCampoObrigatorioFiltro" name="cbCampoObrigatorioFiltro"><label for="cbCampoObrigatorioFiltro">Obrigatório</label>
                            </div>
                          </div>


                          <div class="col-sm-12">
                            <button type="button" id="btn-incluir-filtro" class="btn btn-secondary btn-sm btn-sisp desabilitado">Incluir</button>
                            <button type="button" id="btn-alterar-filtro" class="btn btn-primary btn-sm  btn-sisp desabilitado">Alterar</button>
                            <button type="button" id="btn-excluir-filtro" class="btn btn-danger btn-sm  btn-sisp desabilitado">Excluir</button>
                            <button type="button" id="btn-confirmar-filtro" class="btn btn-primary btn-sm  btn-sisp habilitado d-none">Confirmar</button>
                            <button type="button" id="btn-desistir-filtro" class="btn btn-primary btn-sm  btn-sisp habilitado d-none">Desistir</button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <!-- <button type="button" id="btn-confirmar-dataset" class="btn btn-primary btn-sisp">Confirmar</button> -->
                  </div>
                </div>
              </div>
            </div>
          </section>
        </div>
      </div>
    </section>
    <?php
    include_once('../../modais.php');
    ?>
    <!-- jQuery -->
    <script src="../plugins/jquery/jquery.min.js?versao=3.259.1.1"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.259.1.1"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
      $.widget.bridge('uibutton', $.ui.button)
    </script>

    <!-- Bootstrap 4 -->
    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.259.1.1"></script>
    <!-- Sparkline -->
    <script src="../plugins/sparklines/sparkline.js?versao=3.259.1.1"></script>
    <script src="../dist/js/sisplan.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../utils/funcoes.js?versao=3.259.1.1"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.259.1.1"></script>
    <script src="../dist/js/jquery.dataTables.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../dist/js/loadingoverlay.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../dist/js/sum().js?versao=3.259.1.1"></script>
    <script src="../dist/js/dataTables.keyTable.js?versao=3.259.1.1"></script>
    <script src="../utils/cookies.js?versao=3.259.1.1"></script>
    <script src="../dist/js/requisicoes.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../plugins/jszip/jszip.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../plugins/pdfmake/pdfmake.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../plugins/pdfmake/vfs_fonts.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.259.1.1"></script>
    <script src="../dist/js/jquery.gridly.js?versao=3.259.1.1" type="text/javascript"></script>
    <script src="../dist/js/sql-formatter.min.js?versao=3.259.1.1"></script>
    <script src="../plugins/select2/js/select2.full.min.js?versao=3.259.1.1"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../config.js?versao=3.259.1.1"></script>
    <script src="../plugins/sparklines/sparkline.js?versao=3.259.1.1"></script>
    <script src="../dist/js/sisplan.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../utils/funcoes.js?versao=3.259.1.1"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.259.1.1"></script>
    <script src="../dist/js/jquery.dataTables.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../dist/js/loadingoverlay.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../dist/js/sum().js?versao=3.259.1.1"></script>
    <script src="../dist/js/dataTables.keyTable.js?versao=3.259.1.1"></script>
    <script src="../utils/cookies.js?versao=3.259.1.1"></script>
    <script src="../dist/js/requisicoes.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../plugins/jszip/jszip.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../plugins/pdfmake/pdfmake.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../plugins/pdfmake/vfs_fonts.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="../plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.259.1.1"></script>
    <script src="../dist/js/jquery.gridly.js?versao=3.259.1.1" type="text/javascript"></script>
    <script src="../dist/js/sql-formatter.min.js?versao=3.259.1.1"></script>
    <script src="../plugins/select2/js/select2.full.min.js?versao=3.259.1.1"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.259.1.1"></script>
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    <script>
      var quill = new Quill('#editor', {
        modules: {
          toolbar: [
            [{
              'header': [1, 2, 3, false]
            }], // Desativa as opções de cabeçalho
            ['bold', 'italic', 'underline', 'strike'], // Ativa opções de formatação básica
            [{
              'script': 'sub'
            }, {
              'script': 'super'
            }], // Ativa opções de script (subscrito e sobrescrito)
            // ['clean'] // Remove formatação
          ],
          clipboard: {
            matchVisual: false // Desativa a correspondência visual para evitar copiar estilos
          }
        },
        placeholder: '#VALOR representa o que estiver no select respectivo ao campo Valor',
        theme: 'snow'
      });
    </script>
    <script>
      $(document).ready(async function() {
        ipInterno = '<?php echo IP_INTERNO; ?>';
        ipExterno = '<?php echo IP_EXTERNO; ?>';
        basicAuth = '<?php echo BASIC_AUTH; ?>';
        $('.ql-editor').attr('title', '#VALOR representa o que estiver no select respectivo ao campo Valor');
        const temAcesso = await temAcessoTela('CADASTRO_DASHBOARD');
        if (!temAcesso.resultado) {
          toastrAcesso(temAcesso, '<?php echo BASE_URI; ?>');
          return;
        }

        const pesquisaTabela = {
          tabela: "TABELAS_SISPLAN",
          camposSelect: ["DISTINCT TABELA", "TABELA descricao"],
          where: []
        }





        const listaClassesFontAwesome = [{
            "classe": "yin-yang",
            "nome": "Yin Yang"
          },
          {
            "classe": "yen-sign",
            "nome": "Símbolo do Iene"
          },
          {
            "classe": "x-ray",
            "nome": "Raio-X"
          },
          {
            "classe": "wrench",
            "nome": "Chave inglesa"
          },
          {
            "classe": "won-sign",
            "nome": "Símbolo do Won (moeda sul-coreana)"
          },
          {
            "classe": "wine-glass-alt",
            "nome": "Taça de vinho alternativa"
          },
          {
            "classe": "wine-glass",
            "nome": "Taça de vinho"
          },
          {
            "classe": "wine-bottle",
            "nome": "Garrafa de vinho"
          },
          {
            "classe": "window-restore",
            "nome": "Restaurar janela"
          },
          {
            "classe": "window-minimize",
            "nome": "Minimizar janela"
          },
          {
            "classe": "window-maximize",
            "nome": "Maximizar janela"
          },
          {
            "classe": "window-close",
            "nome": "Fechar janela"
          },
          {
            "classe": "wind",
            "nome": "Vento"
          },
          {
            "classe": "wifi",
            "nome": "Wi-Fi"
          },
          {
            "classe": "wheelchair",
            "nome": "Cadeira de rodas"
          },
          {
            "classe": "weight-hanging",
            "nome": "Peso pendurado"
          },
          {
            "classe": "weight",
            "nome": "Peso"
          },
          {
            "classe": "wave-square",
            "nome": "Onda quadrada"
          },
          {
            "classe": "water",
            "nome": "Água"
          },
          {
            "classe": "warehouse",
            "nome": "Armazém"
          },
          {
            "classe": "wallet",
            "nome": "Carteira"
          },
          {
            "classe": "walking",
            "nome": "Caminhada"
          },
          {
            "classe": "vr-cardboard",
            "nome": "Realidade virtual - Óculos de papelão"
          },
          {
            "classe": "vote-yea",
            "nome": "Voto a favor"
          },
          {
            "classe": "volume-up",
            "nome": "Aumentar volume"
          },
          {
            "classe": "volume-off",
            "nome": "Desativar som"
          },
          {
            "classe": "volume-mute",
            "nome": "Som mudo"
          },
          {
            "classe": "volume-down",
            "nome": "Diminuir volume"
          }, {
            "classe": "volleyball-ball",
            "nome": "Bola de Vôlei"
          },
          {
            "classe": "voicemail",
            "nome": "Caixa Postal de Voz"
          },
          {
            "classe": "viruses",
            "nome": "Vírus (conjunto)"
          },
          {
            "classe": "virus-slash",
            "nome": "Vírus (cortado)"
          },
          {
            "classe": "virus",
            "nome": "Vírus"
          },
          {
            "classe": "vihara",
            "nome": "Vihara (templo budista)"
          },
          {
            "classe": "video-slash",
            "nome": "Vídeo (cortado)"
          },
          {
            "classe": "video",
            "nome": "Vídeo"
          },
          {
            "classe": "vials",
            "nome": "Recipientes de Medicamentos (conjunto)"
          },
          {
            "classe": "vial",
            "nome": "Recipiente de Medicamento"
          },
          {
            "classe": "vest-patches",
            "nome": "Colete com Patches"
          },
          {
            "classe": "vest",
            "nome": "Colete"
          },
          {
            "classe": "venus-mars",
            "nome": "Vênus e Marte"
          },
          {
            "classe": "venus-double",
            "nome": "Vênus Duplo"
          },
          {
            "classe": "venus",
            "nome": "Vênus"
          },
          {
            "classe": "vector-square",
            "nome": "Quadrado Vetorial"
          },
          {
            "classe": "utensils",
            "nome": "Utensílios (conjunto)"
          },
          {
            "classe": "utensil-spoon",
            "nome": "Colher de Utensílio"
          },
          {
            "classe": "users-slash",
            "nome": "Usuários (cortado)"
          },
          {
            "classe": "users-cog",
            "nome": "Usuários com Engrenagem"
          },
          {
            "classe": "users",
            "nome": "Usuários"
          },
          {
            "classe": "user-times",
            "nome": "Usuário (remover)"
          },
          {
            "classe": "user-tie",
            "nome": "Usuário com Gravata"
          },
          {
            "classe": "user-tag",
            "nome": "Usuário com Etiqueta"
          },
          {
            "classe": "user-slash",
            "nome": "Usuário (cortado)"
          },
          {
            "classe": "user-shield",
            "nome": "Usuário com Escudo"
          },
          {
            "classe": "user-secret",
            "nome": "Usuário Secreto"
          },
          {
            "classe": "user-plus",
            "nome": "Usuário (mais)"
          },
          {
            "classe": "user-nurse",
            "nome": "Usuário Enfermeiro"
          },
          {
            "classe": "user-ninja",
            "nome": "Usuário Ninja"
          },
          {
            "classe": "user-minus",
            "nome": "Usuário (menos)"
          },
          {
            "classe": "user-md",
            "nome": "Usuário Médico"
          },
          {
            "classe": "user-lock",
            "nome": "Usuário com Cadeado"
          },
          {
            "classe": "user-injured",
            "nome": "Usuário Ferido"
          },
          {
            "classe": "user-graduate",
            "nome": "Usuário Graduado"
          },
          {
            "classe": "user-friends",
            "nome": "Usuário com Amigos"
          },
          {
            "classe": "user-edit",
            "nome": "Usuário (editar)"
          },
          {
            "classe": "user-cog",
            "nome": "Usuário com Engrenagem"
          },
          {
            "classe": "user-clock",
            "nome": "Usuário com Relógio"
          },
          {
            "classe": "user-circle",
            "nome": "Círculo de Usuário"
          },
          {
            "classe": "user-check",
            "nome": "Usuário (verificar)"
          },
          {
            "classe": "user-astronaut",
            "nome": "Astronauta Usuário"
          },
          {
            "classe": "user-alt-slash",
            "nome": "Usuário Alternativo (cortado)"
          },
          {
            "classe": "user-alt",
            "nome": "Usuário Alternativo"
          },
          {
            "classe": "user",
            "nome": "Usuário"
          },
          {
            "classe": "upload",
            "nome": "Enviar"
          },
          {
            "classe": "unlock-alt",
            "nome": "Destravar (alternativo)"
          },
          {
            "classe": "unlock",
            "nome": "Destravar"
          },
          {
            "classe": "unlink",
            "nome": "Desvincular"
          },
          {
            "classe": "university",
            "nome": "Universidade"
          },
          {
            "classe": "universal-access",
            "nome": "Acesso Universal"
          }, {
            "classe": "undo-alt",
            "nome": "Desfazer (alternativo)"
          },
          {
            "classe": "undo",
            "nome": "Desfazer"
          },
          {
            "classe": "underline",
            "nome": "Sublinhar"
          },
          {
            "classe": "umbrella-beach",
            "nome": "Guarda-Sol de Praia"
          },
          {
            "classe": "umbrella",
            "nome": "Guarda-Chuva"
          },
          {
            "classe": "tv",
            "nome": "Televisão"
          },
          {
            "classe": "tty",
            "nome": "TTY (Dispositivo de Telecomunicação para Surdos)"
          },
          {
            "classe": "tshirt",
            "nome": "Camiseta"
          },
          {
            "classe": "truck-pickup",
            "nome": "Caminhonete"
          },
          {
            "classe": "truck-moving",
            "nome": "Caminhão em Movimento"
          },
          {
            "classe": "truck-monster",
            "nome": "Caminhão Monstro"
          },
          {
            "classe": "truck-loading",
            "nome": "Caminhão de Carga"
          },
          {
            "classe": "truck",
            "nome": "Caminhão"
          },
          {
            "classe": "trophy",
            "nome": "Troféu"
          },
          {
            "classe": "tree",
            "nome": "Árvore"
          },
          {
            "classe": "trash-restore-alt",
            "nome": "Restaurar Lixo (alternativo)"
          },
          {
            "classe": "trash-restore",
            "nome": "Restaurar Lixo"
          },
          {
            "classe": "trash-alt",
            "nome": "Lixeira (alternativa)"
          },
          {
            "classe": "trash",
            "nome": "Lixeira"
          },
          {
            "classe": "transgender-alt",
            "nome": "Transgênero (alternativo)"
          },
          {
            "classe": "transgender",
            "nome": "Transgênero"
          },
          {
            "classe": "tram",
            "nome": "Bonde"
          },
          {
            "classe": "train",
            "nome": "Trem"
          },
          {
            "classe": "trailer",
            "nome": "Reboque"
          },
          {
            "classe": "traffic-light",
            "nome": "Semáforo"
          },
          {
            "classe": "trademark",
            "nome": "Marca Registrada"
          },
          {
            "classe": "tractor",
            "nome": "Trator"
          },
          {
            "classe": "torii-gate",
            "nome": "Portão Torii"
          },
          {
            "classe": "torah",
            "nome": "Torá"
          },
          {
            "classe": "tooth",
            "nome": "Dente"
          },
          {
            "classe": "tools",
            "nome": "Ferramentas"
          },
          {
            "classe": "toolbox",
            "nome": "Caixa de Ferramentas"
          },
          {
            "classe": "toilet-paper-slash",
            "nome": "Papel Higiênico (cortado)"
          },
          {
            "classe": "toilet-paper",
            "nome": "Papel Higiênico"
          },
          {
            "classe": "toilet",
            "nome": "Vaso Sanitário"
          },
          {
            "classe": "toggle-on",
            "nome": "Alternar Ligado"
          },
          {
            "classe": "toggle-off",
            "nome": "Alternar Desligado"
          },
          {
            "classe": "tired",
            "nome": "Cansado"
          },
          {
            "classe": "tint-slash",
            "nome": "Gota de Tinta (cortada)"
          },
          {
            "classe": "tint",
            "nome": "Gota de Tinta"
          },
          {
            "classe": "times-circle",
            "nome": "Círculo de X"
          },
          {
            "classe": "times",
            "nome": "X"
          },
          {
            "classe": "ticket-alt",
            "nome": "Bilhete (alternativo)"
          },
          {
            "classe": "thumbtack",
            "nome": "Tachinha"
          },
          {
            "classe": "thumbs-up",
            "nome": "Polegar para Cima"
          },
          {
            "classe": "thumbs-down",
            "nome": "Polegar para Baixo"
          },
          {
            "classe": "thermometer-three-quarters",
            "nome": "Termômetro Três Quartos"
          },
          {
            "classe": "thermometer-quarter",
            "nome": "Termômetro Um Quarto"
          },
          {
            "classe": "thermometer-half",
            "nome": "Termômetro Meio"
          },
          {
            "classe": "thermometer-full",
            "nome": "Termômetro Completo"
          },
          {
            "classe": "thermometer-empty",
            "nome": "Termômetro Vazio"
          },
          {
            "classe": "thermometer",
            "nome": "Termômetro"
          },
          {
            "classe": "theater-masks",
            "nome": "Máscaras de Teatro"
          },
          {
            "classe": "th-list",
            "nome": "Lista TH"
          },
          {
            "classe": "th-large",
            "nome": "TH Grande"
          },
          {
            "classe": "th",
            "nome": "TH"
          },
          {
            "classe": "text-width",
            "nome": "Largura do Texto"
          },
          {
            "classe": "text-height",
            "nome": "Altura do Texto"
          },
          {
            "classe": "terminal",
            "nome": "Terminal"
          }, {
            "classe": "tenge",
            "nome": "Tenge (moeda do Cazaquistão)"
          },
          {
            "classe": "temperature-low",
            "nome": "Temperatura Baixa"
          },
          {
            "classe": "temperature-high",
            "nome": "Temperatura Alta"
          },
          {
            "classe": "teeth-open",
            "nome": "Dentes Abertos"
          },
          {
            "classe": "teeth",
            "nome": "Dentes"
          },
          {
            "classe": "taxi",
            "nome": "Táxi"
          },
          {
            "classe": "tasks",
            "nome": "Tarefas"
          },
          {
            "classe": "tape",
            "nome": "Fita Adesiva"
          },
          {
            "classe": "tags",
            "nome": "Etiquetas (conjunto)"
          },
          {
            "classe": "tag",
            "nome": "Etiqueta"
          },
          {
            "classe": "tachometer-alt",
            "nome": "Tacômetro (alternativo)"
          },
          {
            "classe": "tablets",
            "nome": "Tablets (conjunto)"
          },
          {
            "classe": "tablet-alt",
            "nome": "Tablet (alternativo)"
          },
          {
            "classe": "tablet",
            "nome": "Tablet"
          },
          {
            "classe": "table-tennis",
            "nome": "Tênis de Mesa"
          },
          {
            "classe": "table",
            "nome": "Tabela"
          },
          {
            "classe": "syringe",
            "nome": "Seringa"
          },
          {
            "classe": "sync-alt",
            "nome": "Sincronizar (alternativo)"
          },
          {
            "classe": "sync",
            "nome": "Sincronizar"
          },
          {
            "classe": "synagogue",
            "nome": "Sinagoga"
          },
          {
            "classe": "swimming-pool",
            "nome": "Piscina"
          },
          {
            "classe": "swimmer",
            "nome": "Nadador"
          },
          {
            "classe": "swatchbook",
            "nome": "Livro de Amostras"
          },
          {
            "classe": "surprise",
            "nome": "Surpresa"
          },
          {
            "classe": "superscript",
            "nome": "Sobrescrito"
          },
          {
            "classe": "sun",
            "nome": "Sol"
          },
          {
            "classe": "suitcase-rolling",
            "nome": "Mala com Rodinhas"
          },
          {
            "classe": "suitcase",
            "nome": "Mala"
          },
          {
            "classe": "subway",
            "nome": "Metropolitano"
          },
          {
            "classe": "subscript",
            "nome": "Subscrito"
          },
          {
            "classe": "stroopwafel",
            "nome": "Stroopwafel"
          },
          {
            "classe": "strikethrough",
            "nome": "Riscar"
          },
          {
            "classe": "street-view",
            "nome": "Vista da Rua"
          },
          {
            "classe": "stream",
            "nome": "Transmissão"
          },
          {
            "classe": "store-slash",
            "nome": "Loja (cortada)"
          },
          {
            "classe": "store-alt-slash",
            "nome": "Loja Alternativa (cortada)"
          },
          {
            "classe": "store-alt",
            "nome": "Loja Alternativa"
          },
          {
            "classe": "store",
            "nome": "Loja"
          },
          {
            "classe": "stopwatch-20",
            "nome": "Cronômetro 20 minutos"
          },
          {
            "classe": "stopwatch",
            "nome": "Cronômetro"
          },
          {
            "classe": "stop-circle",
            "nome": "Círculo de Parada"
          },
          {
            "classe": "stop",
            "nome": "Parar"
          },
          {
            "classe": "sticky-note",
            "nome": "Anotação Adesiva"
          },
          {
            "classe": "stethoscope",
            "nome": "Estetoscópio"
          },
          {
            "classe": "step-forward",
            "nome": "Avançar um Passo"
          },
          {
            "classe": "step-backward",
            "nome": "Retroceder um Passo"
          },
          {
            "classe": "star-of-life",
            "nome": "Estrela da Vida"
          },
          {
            "classe": "star-of-david",
            "nome": "Estrela de Davi"
          },
          {
            "classe": "star-half-alt",
            "nome": "Meia Estrela (alternativa)"
          },
          {
            "classe": "star-half",
            "nome": "Meia Estrela"
          },
          {
            "classe": "star-and-crescent",
            "nome": "Estrela e Crescente"
          },
          {
            "classe": "star",
            "nome": "Estrela"
          },
          {
            "classe": "stamp",
            "nome": "Selo"
          },
          {
            "classe": "square-root-alt",
            "nome": "Raiz Quadrada (alternativa)"
          },
          {
            "classe": "square-full",
            "nome": "Quadrado Cheio"
          },
          {
            "classe": "square",
            "nome": "Quadrado"
          },
          {
            "classe": "spray-can",
            "nome": "Lata de Spray"
          },
          {
            "classe": "splotch",
            "nome": "Mancha"
          },
          {
            "classe": "spinner",
            "nome": "Girador"
          },
          {
            "classe": "spider",
            "nome": "Aranha"
          },
          {
            "classe": "spell-check",
            "nome": "Verificação Ortográfica"
          },
          {
            "classe": "space-shuttle",
            "nome": "Ônibus Espacial"
          },
          {
            "classe": "spa",
            "nome": "Spa"
          },
          {
            "classe": "sort-up",
            "nome": "Ordenar para Cima"
          },
          {
            "classe": "sort-numeric-up-alt",
            "nome": "Ordenar Numérico para Cima (alternativo)"
          },
          {
            "classe": "sort-numeric-up",
            "nome": "Ordenar Numérico para Cima"
          },
          {
            "classe": "sort-numeric-down-alt",
            "nome": "Ordenar Numérico para Baixo (alternativo)"
          },
          {
            "classe": "sort-numeric-down",
            "nome": "Ordenar Numérico para Baixo"
          },
          {
            "classe": "sort-down",
            "nome": "Ordenar para Baixo"
          },
          {
            "classe": "sort-amount-up-alt",
            "nome": "Ordenar Quantidade para Cima (alternativo)"
          },
          {
            "classe": "sort-amount-up",
            "nome": "Ordenar Quantidade para Cima"
          },
          {
            "classe": "sort-amount-down-alt",
            "nome": "Ordenar Quantidade para Baixo (alternativo)"
          },
          {
            "classe": "sort-amount-down",
            "nome": "Ordenar Quantidade para Baixo"
          },
          {
            "classe": "sort-alpha-up-alt",
            "nome": "Ordenar Alfabético para Cima (alternativo)"
          },
          {
            "classe": "sort-alpha-up",
            "nome": "Ordenar Alfabético para Cima"
          },
          {
            "classe": "sort-alpha-down-alt",
            "nome": "Ordenar Alfabético para Baixo (alternativo)"
          },
          {
            "classe": "sort-alpha-down",
            "nome": "Ordenar Alfabético para Baixo"
          },
          {
            "classe": "sort",
            "nome": "Ordenar"
          },
          {
            "classe": "solar-panel",
            "nome": "Painel Solar"
          },
          {
            "classe": "socks",
            "nome": "Meias"
          },
          {
            "classe": "soap",
            "nome": "Sabonete"
          },
          {
            "classe": "snowplow",
            "nome": "Limpa Neve"
          },
          {
            "classe": "snowman",
            "nome": "Boneco de Neve"
          },
          {
            "classe": "snowflake",
            "nome": "Floco de Neve"
          },
          {
            "classe": "snowboarding",
            "nome": "Snowboard"
          },
          {
            "classe": "sms",
            "nome": "SMS (Mensagem de Texto)"
          },
          {
            "classe": "smoking-ban",
            "nome": "Proibido Fumar"
          },
          {
            "classe": "smoking",
            "nome": "Fumante"
          },
          {
            "classe": "smog",
            "nome": "Poluição do Ar"
          },
          {
            "classe": "smile-wink",
            "nome": "Sorriso com Olho Piscando"
          },
          {
            "classe": "smile-beam",
            "nome": "Sorriso Luminoso"
          },
          {
            "classe": "smile",
            "nome": "Sorriso"
          },
          {
            "classe": "sliders-h",
            "nome": "Controles Deslizantes Horizontais"
          },
          {
            "classe": "sleigh",
            "nome": "Trenó"
          },
          {
            "classe": "slash",
            "nome": "Barra (Diagonal)"
          },
          {
            "classe": "skull-crossbones",
            "nome": "Caveira com Ossos Cruzados"
          },
          {
            "classe": "skull",
            "nome": "Caveira"
          },
          {
            "classe": "skiing-nordic",
            "nome": "Esqui Nórdico"
          },
          {
            "classe": "skiing",
            "nome": "Esqui"
          },
          {
            "classe": "skating",
            "nome": "Patinação"
          },
          {
            "classe": "sitemap",
            "nome": "Mapa do Site"
          }, {
            "classe": "sink",
            "nome": "Pia"
          },
          {
            "classe": "sim-card",
            "nome": "Cartão SIM"
          },
          {
            "classe": "signature",
            "nome": "Assinatura"
          },
          {
            "classe": "signal",
            "nome": "Sinal"
          },
          {
            "classe": "sign-out-alt",
            "nome": "Sair (alternativo)"
          },
          {
            "classe": "sign-language",
            "nome": "Linguagem de Sinais"
          },
          {
            "classe": "sign-in-alt",
            "nome": "Entrar (alternativo)"
          },
          {
            "classe": "sign",
            "nome": "Sinal"
          },
          {
            "classe": "shuttle-van",
            "nome": "Van Shuttle"
          },
          {
            "classe": "shower",
            "nome": "Chuveiro"
          },
          {
            "classe": "shopping-cart",
            "nome": "Carrinho de Compras"
          },
          {
            "classe": "shopping-basket",
            "nome": "Cesto de Compras"
          },
          {
            "classe": "shopping-bag",
            "nome": "Sacola de Compras"
          },
          {
            "classe": "shoe-prints",
            "nome": "Pegadas de Sapato"
          },
          {
            "classe": "shipping-fast",
            "nome": "Entrega Rápida"
          },
          {
            "classe": "ship",
            "nome": "Navio"
          },
          {
            "classe": "shield-virus",
            "nome": "Escudo contra Vírus"
          },
          {
            "classe": "shield-alt",
            "nome": "Escudo Alternativo"
          },
          {
            "classe": "shekel-sign",
            "nome": "Símbolo do Shekel"
          },
          {
            "classe": "share-square",
            "nome": "Compartilhar Quadrado"
          },
          {
            "classe": "share-alt-square",
            "nome": "Compartilhar Alternativo Quadrado"
          },
          {
            "classe": "share-alt",
            "nome": "Compartilhar Alternativo"
          },
          {
            "classe": "share",
            "nome": "Compartilhar"
          },
          {
            "classe": "shapes",
            "nome": "Formas"
          },
          {
            "classe": "server",
            "nome": "Servidor"
          },
          {
            "classe": "seedling",
            "nome": "Broto"
          },
          {
            "classe": "search-plus",
            "nome": "Pesquisar Mais"
          },
          {
            "classe": "search-minus",
            "nome": "Pesquisar Menos"
          },
          {
            "classe": "search-location",
            "nome": "Pesquisar Localização"
          },
          {
            "classe": "search-dollar",
            "nome": "Pesquisar Dólar"
          },
          {
            "classe": "search",
            "nome": "Pesquisar"
          },
          {
            "classe": "sd-card",
            "nome": "Cartão SD"
          },
          {
            "classe": "scroll",
            "nome": "Pergaminho"
          },
          {
            "classe": "screwdriver",
            "nome": "Chave de Fenda"
          },
          {
            "classe": "school",
            "nome": "Escola"
          },
          {
            "classe": "save",
            "nome": "Salvar"
          },
          {
            "classe": "satellite-dish",
            "nome": "Antena Parabólica"
          },
          {
            "classe": "satellite",
            "nome": "Satélite"
          },
          {
            "classe": "sad-tear",
            "nome": "Lágrima Triste"
          },
          {
            "classe": "sad-cry",
            "nome": "Choro Triste"
          },
          {
            "classe": "rupee-sign",
            "nome": "Símbolo da Rúpia"
          },
          {
            "classe": "running",
            "nome": "Correndo"
          },
          {
            "classe": "ruler-vertical",
            "nome": "Régua Vertical"
          },
          {
            "classe": "ruler-horizontal",
            "nome": "Régua Horizontal"
          },
          {
            "classe": "ruler-combined",
            "nome": "Régua Combinada"
          },
          {
            "classe": "ruler",
            "nome": "Régua"
          },
          {
            "classe": "ruble-sign",
            "nome": "Símbolo do Rublo"
          },
          {
            "classe": "rss-square",
            "nome": "RSS Quadrado"
          },
          {
            "classe": "rss",
            "nome": "RSS"
          },
          {
            "classe": "route",
            "nome": "Rota"
          },
          {
            "classe": "rocket",
            "nome": "Foguete"
          },
          {
            "classe": "robot",
            "nome": "Robô"
          },
          {
            "classe": "road",
            "nome": "Estrada"
          },
          {
            "classe": "ring",
            "nome": "Anel"
          },
          {
            "classe": "ribbon",
            "nome": "Fita"
          },
          {
            "classe": "retweet",
            "nome": "Retweet"
          },
          {
            "classe": "restroom",
            "nome": "Banheiro"
          },
          {
            "classe": "republican",
            "nome": "Republicano"
          },
          {
            "classe": "reply-all",
            "nome": "Responder a Todos"
          },
          {
            "classe": "reply",
            "nome": "Responder"
          },
          {
            "classe": "remove-format",
            "nome": "Remover Formatação"
          },
          {
            "classe": "registered",
            "nome": "Registrado"
          },
          {
            "classe": "redo-alt",
            "nome": "Refazer (alternativo)"
          },
          {
            "classe": "redo",
            "nome": "Refazer"
          },
          {
            "classe": "recycle",
            "nome": "Reciclagem"
          },
          {
            "classe": "record-vinyl",
            "nome": "Disco de Vinil"
          },
          {
            "classe": "receipt",
            "nome": "Recibo"
          },
          {
            "classe": "random",
            "nome": "Aleatório"
          },
          {
            "classe": "rainbow",
            "nome": "Arco-Íris"
          }, {
            "classe": "radiation-alt",
            "nome": "Radiação (alternativa)"
          },
          {
            "classe": "radiation",
            "nome": "Radiação"
          },
          {
            "classe": "quran",
            "nome": "Alcorão"
          },
          {
            "classe": "quote-right",
            "nome": "Aspas à Direita"
          },
          {
            "classe": "quote-left",
            "nome": "Aspas à Esquerda"
          },
          {
            "classe": "quidditch",
            "nome": "Quadribol"
          },
          {
            "classe": "question-circle",
            "nome": "Círculo de Interrogação"
          },
          {
            "classe": "question",
            "nome": "Interrogação"
          },
          {
            "classe": "qrcode",
            "nome": "Código QR"
          },
          {
            "classe": "puzzle-piece",
            "nome": "Peça de Quebra-Cabeça"
          },
          {
            "classe": "pump-soap",
            "nome": "Bomba de Sabão"
          },
          {
            "classe": "pump-medical",
            "nome": "Bomba Médica"
          },
          {
            "classe": "project-diagram",
            "nome": "Diagrama de Projeto"
          },
          {
            "classe": "procedures",
            "nome": "Procedimentos"
          },
          {
            "classe": "print",
            "nome": "Imprimir"
          },
          {
            "classe": "prescription-bottle-alt",
            "nome": "Frasco de Prescrição (alternativo)"
          },
          {
            "classe": "prescription-bottle",
            "nome": "Frasco de Prescrição"
          },
          {
            "classe": "prescription",
            "nome": "Prescrição"
          },
          {
            "classe": "praying-hands",
            "nome": "Mãos Orando"
          },
          {
            "classe": "pray",
            "nome": "Orar"
          },
          {
            "classe": "power-off",
            "nome": "Desligar"
          },
          {
            "classe": "pound-sign",
            "nome": "Símbolo da Libra"
          },
          {
            "classe": "portrait",
            "nome": "Retrato"
          },
          {
            "classe": "poop",
            "nome": "Cocô"
          },
          {
            "classe": "poo-storm",
            "nome": "Tempestade de Cocô"
          },
          {
            "classe": "poo",
            "nome": "Cocô"
          },
          {
            "classe": "poll-h",
            "nome": "Enquete H"
          },
          {
            "classe": "poll",
            "nome": "Enquete"
          },
          {
            "classe": "podcast",
            "nome": "Podcast"
          },
          {
            "classe": "plus-square",
            "nome": "Mais Quadrado"
          },
          {
            "classe": "plus-circle",
            "nome": "Mais Círculo"
          },
          {
            "classe": "plus",
            "nome": "Mais"
          },
          {
            "classe": "plug",
            "nome": "Tomada"
          },
          {
            "classe": "play-circle",
            "nome": "Círculo de Reprodução"
          },
          {
            "classe": "play",
            "nome": "Reproduzir"
          },
          {
            "classe": "plane-slash",
            "nome": "Avião (cortado)"
          },
          {
            "classe": "plane-departure",
            "nome": "Partida de Avião"
          },
          {
            "classe": "plane-arrival",
            "nome": "Chegada de Avião"
          },
          {
            "classe": "plane",
            "nome": "Avião"
          },
          {
            "classe": "place-of-worship",
            "nome": "Local de Culto"
          },
          {
            "classe": "pizza-slice",
            "nome": "Fatia de Pizza"
          },
          {
            "classe": "pills",
            "nome": "Pílulas"
          },
          {
            "classe": "piggy-bank",
            "nome": "Cofrinho"
          },
          {
            "classe": "photo-video",
            "nome": "Foto e Vídeo"
          },
          {
            "classe": "phone-volume",
            "nome": "Volume do Telefone"
          },
          {
            "classe": "phone-square-alt",
            "nome": "Telefone Quadrado Alternativo"
          },
          {
            "classe": "phone-square",
            "nome": "Telefone Quadrado"
          },
          {
            "classe": "phone-slash",
            "nome": "Telefone (cortado)"
          },
          {
            "classe": "phone-alt",
            "nome": "Telefone Alternativo"
          },
          {
            "classe": "phone",
            "nome": "Telefone"
          },
          {
            "classe": "person-booth",
            "nome": "Cabine Pessoal"
          },
          {
            "classe": "percentage",
            "nome": "Percentual"
          },
          {
            "classe": "percent",
            "nome": "Porcentagem"
          },
          {
            "classe": "pepper-hot",
            "nome": "Pimenta Quente"
          },
          {
            "classe": "people-carry",
            "nome": "Pessoas Carregando"
          },
          {
            "classe": "people-arrows",
            "nome": "Pessoas com Setas"
          },
          {
            "classe": "pencil-ruler",
            "nome": "Lápis e Régua"
          },
          {
            "classe": "pencil-alt",
            "nome": "Lápis Alternativo"
          },
          {
            "classe": "pen-square",
            "nome": "Caneta Quadrada"
          },
          {
            "classe": "pen-nib",
            "nome": "Pena de Caneta"
          },
          {
            "classe": "pen-fancy",
            "nome": "Caneta Elegante"
          },
          {
            "classe": "pen-alt",
            "nome": "Caneta Alternativa"
          },
          {
            "classe": "pen",
            "nome": "Caneta"
          },
          {
            "classe": "peace",
            "nome": "Paz"
          },
          {
            "classe": "paw",
            "nome": "Pata"
          },
          {
            "classe": "pause-circle",
            "nome": "Círculo de Pausa"
          },
          {
            "classe": "pause",
            "nome": "Pausa"
          },
          {
            "classe": "paste",
            "nome": "Colar"
          },
          {
            "classe": "pastafarianism",
            "nome": "Pastafarianismo"
          },
          {
            "classe": "passport",
            "nome": "Passaporte"
          },
          {
            "classe": "parking",
            "nome": "Estacionamento"
          },
          {
            "classe": "paragraph",
            "nome": "Parágrafo"
          }, {
            "classe": "parachute-box",
            "nome": "Caixa de Pára-quedas"
          },
          {
            "classe": "paperclip",
            "nome": "Clips de Papel"
          },
          {
            "classe": "paper-plane",
            "nome": "Avião de Papel"
          },
          {
            "classe": "pallet",
            "nome": "Palete"
          },
          {
            "classe": "palette",
            "nome": "Paleta de Cores"
          },
          {
            "classe": "paint-roller",
            "nome": "Rolo de Pintura"
          },
          {
            "classe": "paint-brush",
            "nome": "Pincel de Pintura"
          },
          {
            "classe": "pager",
            "nome": "Pager"
          },
          {
            "classe": "outdent",
            "nome": "Reduzir Recuo"
          },
          {
            "classe": "otter",
            "nome": "Lontra"
          },
          {
            "classe": "om",
            "nome": "Om"
          },
          {
            "classe": "oil-can",
            "nome": "Lata de Óleo"
          },
          {
            "classe": "object-ungroup",
            "nome": "Desagrupar Objeto"
          },
          {
            "classe": "object-group",
            "nome": "Agrupar Objeto"
          },
          {
            "classe": "notes-medical",
            "nome": "Notas Médicas"
          },
          {
            "classe": "not-equal",
            "nome": "Diferente"
          },
          {
            "classe": "newspaper",
            "nome": "Jornal"
          },
          {
            "classe": "neuter",
            "nome": "Neutro"
          },
          {
            "classe": "network-wired",
            "nome": "Rede com Fio"
          },
          {
            "classe": "music",
            "nome": "Música"
          },
          {
            "classe": "mug-hot",
            "nome": "Caneca Quente"
          },
          {
            "classe": "mouse-pointer",
            "nome": "Ponteiro do Mouse"
          },
          {
            "classe": "mouse",
            "nome": "Mouse"
          },
          {
            "classe": "mountain",
            "nome": "Montanha"
          },
          {
            "classe": "motorcycle",
            "nome": "Motocicleta"
          },
          {
            "classe": "mosque",
            "nome": "Mesquita"
          },
          {
            "classe": "mortar-pestle",
            "nome": "Almofariz e Pilão"
          },
          {
            "classe": "moon",
            "nome": "Lua"
          },
          {
            "classe": "monument",
            "nome": "Monumento"
          },
          {
            "classe": "money-check-alt",
            "nome": "Verificação de Dinheiro Alternativa"
          },
          {
            "classe": "money-check",
            "nome": "Verificação de Dinheiro"
          },
          {
            "classe": "money-bill-wave-alt",
            "nome": "Ondas de Conta de Dinheiro Alternativa"
          },
          {
            "classe": "money-bill-wave",
            "nome": "Ondas de Conta de Dinheiro"
          },
          {
            "classe": "money-bill-alt",
            "nome": "Conta de Dinheiro Alternativa"
          },
          {
            "classe": "money-bill",
            "nome": "Conta de Dinheiro"
          },
          {
            "classe": "mobile-alt",
            "nome": "Dispositivo Móvel Alternativo"
          },
          {
            "classe": "mobile",
            "nome": "Dispositivo Móvel"
          },
          {
            "classe": "mitten",
            "nome": "Luva"
          },
          {
            "classe": "minus-square",
            "nome": "Quadrado Menos"
          },
          {
            "classe": "minus-circle",
            "nome": "Círculo Menos"
          },
          {
            "classe": "minus",
            "nome": "Menos"
          },
          {
            "classe": "microscope",
            "nome": "Microscópio"
          },
          {
            "classe": "microphone-slash",
            "nome": "Microfone Cortado"
          },
          {
            "classe": "microphone-alt-slash",
            "nome": "Microfone Alternativo Cortado"
          },
          {
            "classe": "microphone-alt",
            "nome": "Microfone Alternativo"
          },
          {
            "classe": "microphone",
            "nome": "Microfone"
          },
          {
            "classe": "microchip",
            "nome": "Microchip"
          },
          {
            "classe": "meteor",
            "nome": "Meteoro"
          },
          {
            "classe": "mercury",
            "nome": "Mercúrio"
          },
          {
            "classe": "menorah",
            "nome": "Menorá"
          },
          {
            "classe": "memory",
            "nome": "Memória"
          },
          {
            "classe": "meh-rolling-eyes",
            "nome": "Meh com Rolamento de Olhos"
          },
          {
            "classe": "meh-blank",
            "nome": "Meh em Branco"
          },
          {
            "classe": "meh",
            "nome": "Meh"
          },
          {
            "classe": "medkit",
            "nome": "Kit Médico"
          },
          {
            "classe": "medal",
            "nome": "Medalha"
          },
          {
            "classe": "mask",
            "nome": "Máscara"
          },
          {
            "classe": "mars-stroke-v",
            "nome": "Marte com Traço Vertical"
          },
          {
            "classe": "mars-stroke-h",
            "nome": "Marte com Traço Horizontal"
          },
          {
            "classe": "mars-stroke",
            "nome": "Marte com Traço"
          },
          {
            "classe": "mars-double",
            "nome": "Marte Duplo"
          },
          {
            "classe": "mars",
            "nome": "Marte"
          },
          {
            "classe": "marker",
            "nome": "Marcador"
          },
          {
            "classe": "map-signs",
            "nome": "Sinais de Mapa"
          },
          {
            "classe": "map-pin",
            "nome": "Alfinete de Mapa"
          },
          {
            "classe": "map-marker-alt",
            "nome": "Marcador de Mapa Alternativo"
          },
          {
            "classe": "map-marker",
            "nome": "Marcador de Mapa"
          },
          {
            "classe": "map-marked-alt",
            "nome": "Mapa Marcado Alternativo"
          },
          {
            "classe": "map-marked",
            "nome": "Mapa Marcado"
          },
          {
            "classe": "map",
            "nome": "Mapa"
          },
          {
            "classe": "male",
            "nome": "Masculino"
          },
          {
            "classe": "mail-bulk",
            "nome": "E-mail em Massa"
          },
          {
            "classe": "magnet",
            "nome": "Ímã"
          },
          {
            "classe": "magic",
            "nome": "Mágica"
          },
          {
            "classe": "lungs-virus",
            "nome": "Pulmões com Vírus"
          },
          {
            "classe": "lungs",
            "nome": "Pulmões"
          },
          {
            "classe": "luggage-cart",
            "nome": "Carrinho de Bagagem"
          },
          {
            "classe": "low-vision",
            "nome": "Baixa Visão"
          },
          {
            "classe": "long-arrow-alt-up",
            "nome": "Seta Longa para Cima"
          },
          {
            "classe": "long-arrow-alt-right",
            "nome": "Seta Longa para a Direita"
          },
          {
            "classe": "long-arrow-alt-left",
            "nome": "Seta Longa para a Esquerda"
          },
          {
            "classe": "long-arrow-alt-down",
            "nome": "Seta Longa para Baixo"
          },
          {
            "classe": "lock-open",
            "nome": "Cadeado Aberto"
          },
          {
            "classe": "lock",
            "nome": "Cadeado"
          },
          {
            "classe": "location-arrow",
            "nome": "Seta de Localização"
          },
          {
            "classe": "list-ul",
            "nome": "Lista Não Ordenada"
          },
          {
            "classe": "list-ol",
            "nome": "Lista Ordenada"
          },
          {
            "classe": "list-alt",
            "nome": "Lista Alternativa"
          },
          {
            "classe": "list",
            "nome": "Lista"
          },
          {
            "classe": "lira-sign",
            "nome": "Sinal de Lira"
          },
          {
            "classe": "link",
            "nome": "Link"
          },
          {
            "classe": "lightbulb",
            "nome": "Lâmpada"
          },
          {
            "classe": "life-ring",
            "nome": "Boia Salva-Vidas"
          },
          {
            "classe": "level-up-alt",
            "nome": "Nível Acima Alternativo"
          },
          {
            "classe": "level-down-alt",
            "nome": "Nível Abaixo Alternativo"
          },
          {
            "classe": "less-than-equal",
            "nome": "Menor ou Igual"
          },
          {
            "classe": "less-than",
            "nome": "Menor Que"
          },
          {
            "classe": "lemon",
            "nome": "Limão"
          },
          {
            "classe": "leaf",
            "nome": "Folha"
          },
          {
            "classe": "layer-group",
            "nome": "Grupo de Camadas"
          },
          {
            "classe": "laugh-wink",
            "nome": "Rir com Piscadela"
          },
          {
            "classe": "laugh-squint",
            "nome": "Rir com Olhos Semicerrados"
          },
          {
            "classe": "laugh-beam",
            "nome": "Rir com Brilho"
          },
          {
            "classe": "laugh",
            "nome": "Rir"
          },
          {
            "classe": "laptop-medical",
            "nome": "Laptop Médico"
          },
          {
            "classe": "laptop-house",
            "nome": "Laptop com Casa"
          },
          {
            "classe": "laptop-code",
            "nome": "Laptop com Código"
          },
          {
            "classe": "laptop",
            "nome": "Laptop"
          },
          {
            "classe": "language",
            "nome": "Idioma"
          },
          {
            "classe": "landmark",
            "nome": "Marco"
          },
          {
            "classe": "kiwi-bird",
            "nome": "Pássaro Kiwi"
          },
          {
            "classe": "kiss-wink-heart",
            "nome": "Beijo com Piscadela e Coração"
          },
          {
            "classe": "kiss-beam",
            "nome": "Beijo com Brilho"
          },
          {
            "classe": "kiss",
            "nome": "Beijo"
          },
          {
            "classe": "khanda",
            "nome": "Khanda"
          },
          {
            "classe": "keyboard",
            "nome": "Teclado"
          },
          {
            "classe": "key",
            "nome": "Chave"
          },
          {
            "classe": "kaaba",
            "nome": "Kaaba"
          },
          {
            "classe": "journal-whills",
            "nome": "Diário de Whills"
          },
          {
            "classe": "joint",
            "nome": "Baseado"
          },
          {
            "classe": "jedi",
            "nome": "Jedi"
          },
          {
            "classe": "italic",
            "nome": "Itálico"
          },
          {
            "classe": "info-circle",
            "nome": "Círculo de Informação"
          },
          {
            "classe": "info",
            "nome": "Informação"
          },
          {
            "classe": "infinity",
            "nome": "Infinito"
          },
          {
            "classe": "industry",
            "nome": "Indústria"
          },
          {
            "classe": "indent",
            "nome": "Recuar"
          },
          {
            "classe": "inbox",
            "nome": "Caixa de Entrada"
          },
          {
            "classe": "images",
            "nome": "Imagens"
          },
          {
            "classe": "image",
            "nome": "Imagem"
          },
          {
            "classe": "igloo",
            "nome": "Iglu"
          },
          {
            "classe": "id-card-alt",
            "nome": "Cartão de Identificação Alternativo"
          },
          {
            "classe": "id-card",
            "nome": "Cartão de Identificação"
          },
          {
            "classe": "id-badge",
            "nome": "Crachá de Identificação"
          },
          {
            "classe": "icons",
            "nome": "Ícones"
          },
          {
            "classe": "icicles",
            "nome": "Pingentes de Gelo"
          },
          {
            "classe": "ice-cream",
            "nome": "Sorvete"
          },
          {
            "classe": "i-cursor",
            "nome": "Cursor I"
          },
          {
            "classe": "hryvnia",
            "nome": "Hryvnia"
          },
          {
            "classe": "house-user",
            "nome": "Casa do Usuário"
          },
          {
            "classe": "house-damage",
            "nome": "Casa Danificada"
          },
          {
            "classe": "hourglass-start",
            "nome": "Ampulheta Início"
          },
          {
            "classe": "hourglass-half",
            "nome": "Ampulheta Metade"
          },
          {
            "classe": "hourglass-end",
            "nome": "Ampulheta Fim"
          },
          {
            "classe": "hourglass",
            "nome": "Ampulheta"
          },
          {
            "classe": "hotel",
            "nome": "Hotel"
          },
          {
            "classe": "hotdog",
            "nome": "Cachorro-Quente"
          },
          {
            "classe": "hot-tub",
            "nome": "Banheira de Hidromassagem"
          },
          {
            "classe": "hospital-user",
            "nome": "Hospital do Usuário"
          },
          {
            "classe": "hospital-symbol",
            "nome": "Símbolo de Hospital"
          },
          {
            "classe": "hospital-alt",
            "nome": "Hospital Alternativo"
          },
          {
            "classe": "hospital",
            "nome": "Hospital"
          },
          {
            "classe": "horse-head",
            "nome": "Cabeça de Cavalo"
          },
          {
            "classe": "horse",
            "nome": "Cavalo"
          },
          {
            "classe": "home",
            "nome": "Casa"
          },
          {
            "classe": "holly-berry",
            "nome": "Bagas de Azevinho"
          },
          {
            "classe": "hockey-puck",
            "nome": "Puck de Hóquei"
          },
          {
            "classe": "history",
            "nome": "História"
          },
          {
            "classe": "hippo",
            "nome": "Hipopótamo"
          },
          {
            "classe": "hiking",
            "nome": "Caminhada"
          },
          {
            "classe": "highlighter",
            "nome": "Marcador de Texto"
          },
          {
            "classe": "helicopter",
            "nome": "Helicóptero"
          },
          {
            "classe": "heartbeat",
            "nome": "Batimento Cardíaco"
          },
          {
            "classe": "heart-broken",
            "nome": "Coração Partido"
          },
          {
            "classe": "heart",
            "nome": "Coração"
          },
          {
            "classe": "headset",
            "nome": "Fone de Ouvido"
          },
          {
            "classe": "headphones-alt",
            "nome": "Fones de Ouvido Alternativos"
          },
          {
            "classe": "headphones",
            "nome": "Fones de Ouvido"
          },
          {
            "classe": "heading",
            "nome": "Título"
          },
          {
            "classe": "head-side-virus",
            "nome": "Cabeça com Vírus"
          },
          {
            "classe": "head-side-mask",
            "nome": "Cabeça com Máscara"
          },
          {
            "classe": "head-side-cough-slash",
            "nome": "Cabeça com Tosse Cortada"
          },
          {
            "classe": "head-side-cough",
            "nome": "Cabeça com Tosse"
          },
          {
            "classe": "hdd",
            "nome": "Disco Rígido"
          },
          {
            "classe": "hat-wizard",
            "nome": "Chapéu de Mágico"
          },
          {
            "classe": "hat-cowboy-side",
            "nome": "Chapéu de Cowboy de Lado"
          },
          {
            "classe": "hat-cowboy",
            "nome": "Chapéu de Cowboy"
          },
          {
            "classe": "hashtag",
            "nome": "Hashtag"
          },
          {
            "classe": "hard-hat",
            "nome": "Capacete de Proteção"
          },
          {
            "classe": "hanukiah",
            "nome": "Hanukiá"
          },
          {
            "classe": "handshake-slash",
            "nome": "Aperto de Mão Cortado"
          },
          {
            "classe": "handshake-alt-slash",
            "nome": "Aperto de Mão Alternativo Cortado"
          },
          {
            "classe": "handshake",
            "nome": "Aperto de Mão"
          },
          {
            "classe": "hands-wash",
            "nome": "Mãos Lavando"
          },
          {
            "classe": "hands-helping",
            "nome": "Mãos Auxiliando"
          },
          {
            "classe": "hands",
            "nome": "Mãos"
          },
          {
            "classe": "hand-spock",
            "nome": "Mão Spock"
          },
          {
            "classe": "hand-sparkles",
            "nome": "Mão com Brilho"
          },
          {
            "classe": "hand-scissors",
            "nome": "Mão com Tesoura"
          },
          {
            "classe": "hand-rock",
            "nome": "Mão com Pedra"
          },
          {
            "classe": "hand-pointer",
            "nome": "Mão com Ponteiro"
          },
          {
            "classe": "hand-point-up",
            "nome": "Mão Apontando para Cima"
          },
          {
            "classe": "hand-point-right",
            "nome": "Mão Apontando para a Direita"
          },
          {
            "classe": "hand-point-left",
            "nome": "Mão Apontando para a Esquerda"
          },
          {
            "classe": "hand-point-down",
            "nome": "Mão Apontando para Baixo"
          },
          {
            "classe": "hand-peace",
            "nome": "Mão em Sinal de Paz"
          },
          {
            "classe": "hand-paper",
            "nome": "Mão com Papel"
          },
          {
            "classe": "hand-middle-finger",
            "nome": "Mão com Dedo do Meio"
          },
          {
            "classe": "hand-lizard",
            "nome": "Mão com Lagarto"
          },
          {
            "classe": "hand-holding-water",
            "nome": "Mão Segurando Água"
          },
          {
            "classe": "hand-holding-usd",
            "nome": "Mão Segurando Dólar"
          },
          {
            "classe": "hand-holding-medical",
            "nome": "Mão Segurando Símbolo Médico"
          },
          {
            "classe": "hand-holding-heart",
            "nome": "Mão Segurando Coração"
          },
          {
            "classe": "hand-holding",
            "nome": "Mão Segurando"
          },
          {
            "classe": "hamsa",
            "nome": "Hamsá"
          },
          {
            "classe": "hammer",
            "nome": "Martelo"
          },
          {
            "classe": "hamburger",
            "nome": "Hambúrguer"
          },
          {
            "classe": "h-square",
            "nome": "H Quadrado"
          },
          {
            "classe": "guitar",
            "nome": "Guitarra"
          },
          {
            "classe": "grip-vertical",
            "nome": "Pega Vertical"
          },
          {
            "classe": "grip-lines-vertical",
            "nome": "Linhas de Pega Vertical"
          },
          {
            "classe": "grip-lines",
            "nome": "Linhas de Pega"
          },
          {
            "classe": "grip-horizontal",
            "nome": "Pega Horizontal"
          },
          {
            "classe": "grin-wink",
            "nome": "Sorriso com Piscadela"
          },
          {
            "classe": "grin-tongue-wink",
            "nome": "Sorriso com Língua e Piscadela"
          },
          {
            "classe": "grin-tongue-squint",
            "nome": "Sorriso com Língua e Olhos Semicerrados"
          },
          {
            "classe": "grin-tongue",
            "nome": "Sorriso com Língua"
          },
          {
            "classe": "grin-tears",
            "nome": "Sorriso com Lágrimas"
          },
          {
            "classe": "grin-stars",
            "nome": "Sorriso com Estrelas"
          },
          {
            "classe": "grin-squint-tears",
            "nome": "Sorriso com Olhos Semicerrados e Lágrimas"
          },
          {
            "classe": "grin-squint",
            "nome": "Sorriso com Olhos Semicerrados"
          },
          {
            "classe": "grin-hearts",
            "nome": "Sorriso com Corações"
          },
          {
            "classe": "grin-beam-sweat",
            "nome": "Sorriso com Feixes e Suor"
          },
          {
            "classe": "grin-beam",
            "nome": "Sorriso com Feixes"
          },
          {
            "classe": "grin-alt",
            "nome": "Sorriso Alternativo"
          },
          {
            "classe": "grin",
            "nome": "Sorriso"
          },
          {
            "classe": "grimace",
            "nome": "Careta"
          },
          {
            "classe": "greater-than-equal",
            "nome": "Maior ou Igual"
          },
          {
            "classe": "greater-than",
            "nome": "Maior Que"
          },
          {
            "classe": "graduation-cap",
            "nome": "Capelo de Graduação"
          },
          {
            "classe": "gopuram",
            "nome": "Gopuram"
          },
          {
            "classe": "golf-ball",
            "nome": "Bola de Gol"
          },
          {
            "classe": "globe-europe",
            "nome": "Globo com Europa"
          },
          {
            "classe": "globe-asia",
            "nome": "Globo com Ásia"
          },
          {
            "classe": "globe-americas",
            "nome": "Globo com Américas"
          },
          {
            "classe": "globe-africa",
            "nome": "Globo com África"
          },
          {
            "classe": "globe",
            "nome": "Globo"
          },
          {
            "classe": "glasses",
            "nome": "Óculos"
          },
          {
            "classe": "glass-whiskey",
            "nome": "Copo de Uísque"
          },
          {
            "classe": "glass-martini-alt",
            "nome": "Copo de Martini Alternativo"
          },
          {
            "classe": "glass-martini",
            "nome": "Copo de Martini"
          },
          {
            "classe": "glass-cheers",
            "nome": "Brinde com Copos"
          },
          {
            "classe": "gifts",
            "nome": "Presentes"
          },
          {
            "classe": "gift",
            "nome": "Presente"
          },
          {
            "classe": "ghost",
            "nome": "Fantasma"
          },
          {
            "classe": "genderless",
            "nome": "Sem Gênero"
          },
          {
            "classe": "gem",
            "nome": "Gema"
          },
          {
            "classe": "gavel",
            "nome": "Martelo de Juiz"
          },
          {
            "classe": "gas-pump",
            "nome": "Bomba de Combustível"
          },
          {
            "classe": "gamepad",
            "nome": "Controle de Videogame"
          },
          {
            "classe": "futbol",
            "nome": "Bola de Futebol"
          },
          {
            "classe": "funnel-dollar",
            "nome": "Funil com Símbolo de Dólar"
          },
          {
            "classe": "frown-open",
            "nome": "Rosto Triste Aberto"
          },
          {
            "classe": "frown",
            "nome": "Rosto Triste"
          },
          {
            "classe": "frog",
            "nome": "Sapo"
          },
          {
            "classe": "forward",
            "nome": "Avançar"
          },
          {
            "classe": "football-ball",
            "nome": "Bola de Futebol Americano"
          },
          {
            "classe": "font",
            "nome": "Fonte"
          },
          {
            "classe": "folder-plus",
            "nome": "Pasta Adicional"
          },
          {
            "classe": "folder-open",
            "nome": "Pasta Aberta"
          },
          {
            "classe": "folder-minus",
            "nome": "Pasta Menos"
          },
          {
            "classe": "folder",
            "nome": "Pasta"
          },
          {
            "classe": "flushed",
            "nome": "Rosto Envergonhado"
          },
          {
            "classe": "flask",
            "nome": "Frasco"
          },
          {
            "classe": "flag-usa",
            "nome": "Bandeira dos EUA"
          },
          {
            "classe": "flag-checkered",
            "nome": "Bandeira Quadriculada"
          },
          {
            "classe": "flag",
            "nome": "Bandeira"
          },
          {
            "classe": "fist-raised",
            "nome": "Punho Erguido"
          },
          {
            "classe": "fish",
            "nome": "Peixe"
          },
          {
            "classe": "first-aid",
            "nome": "Kit de Primeiros Socorros"
          },
          {
            "classe": "fire-extinguisher",
            "nome": "Extintor de Incêndio"
          },
          {
            "classe": "fire-alt",
            "nome": "Fogo Alternativo"
          },
          {
            "classe": "fire",
            "nome": "Fogo"
          },
          {
            "classe": "fingerprint",
            "nome": "Impressão Digital"
          },
          {
            "classe": "filter",
            "nome": "Filtro"
          },
          {
            "classe": "film",
            "nome": "Filme"
          },
          {
            "classe": "fill-drip",
            "nome": "Preencher Gotejamento"
          },
          {
            "classe": "fill",
            "nome": "Preencher"
          },
          {
            "classe": "file-word",
            "nome": "Arquivo do Word"
          },
          {
            "classe": "file-video",
            "nome": "Arquivo de Vídeo"
          },
          {
            "classe": "file-upload",
            "nome": "Upload de Arquivo"
          },
          {
            "classe": "file-signature",
            "nome": "Assinatura de Arquivo"
          },
          {
            "classe": "file-prescription",
            "nome": "Arquivo de Prescrição"
          },
          {
            "classe": "file-powerpoint",
            "nome": "Apresentação do PowerPoint"
          },
          {
            "classe": "file-pdf",
            "nome": "Arquivo PDF"
          },
          {
            "classe": "file-medical-alt",
            "nome": "Arquivo Médico Alternativo"
          },
          {
            "classe": "file-medical",
            "nome": "Arquivo Médico"
          },
          {
            "classe": "file-invoice-dollar",
            "nome": "Fatura de Arquivo com Dólar"
          },
          {
            "classe": "file-invoice",
            "nome": "Fatura de Arquivo"
          },
          {
            "classe": "file-import",
            "nome": "Importar Arquivo"
          },
          {
            "classe": "file-image",
            "nome": "Arquivo de Imagem"
          },
          {
            "classe": "file-export",
            "nome": "Exportar Arquivo"
          },
          {
            "classe": "file-excel",
            "nome": "Arquivo do Excel"
          },
          {
            "classe": "file-download",
            "nome": "Download de Arquivo"
          },
          {
            "classe": "file-csv",
            "nome": "Arquivo CSV"
          },
          {
            "classe": "file-contract",
            "nome": "Contrato de Arquivo"
          },
          {
            "classe": "file-code",
            "nome": "Código de Arquivo"
          },
          {
            "classe": "file-audio",
            "nome": "Arquivo de Áudio"
          },
          {
            "classe": "file-archive",
            "nome": "Arquivo Compactado"
          },
          {
            "classe": "file-alt",
            "nome": "Arquivo Alternativo"
          },
          {
            "classe": "file",
            "nome": "Arquivo"
          },
          {
            "classe": "fighter-jet",
            "nome": "Avião de Caça"
          },
          {
            "classe": "female",
            "nome": "Símbolo Feminino"
          },
          {
            "classe": "feather-alt",
            "nome": "Pena Alternativa"
          },
          {
            "classe": "feather",
            "nome": "Pena"
          },
          {
            "classe": "fax",
            "nome": "Fax"
          },
          {
            "classe": "faucet",
            "nome": "Torneira"
          },
          {
            "classe": "fast-forward",
            "nome": "Avanço Rápido"
          },
          {
            "classe": "fast-backward",
            "nome": "Retrocesso Rápido"
          },
          {
            "classe": "fan",
            "nome": "Ventilador"
          },
          {
            "classe": "eye-slash",
            "nome": "Olho Cortado"
          },
          {
            "classe": "eye-dropper",
            "nome": "Conta-Gotas"
          },
          {
            "classe": "eye",
            "nome": "Olho"
          },
          {
            "classe": "external-link-square-alt",
            "nome": "Link Externo Quadrado Alternativo"
          },
          {
            "classe": "external-link-alt",
            "nome": "Link Externo Alternativo"
          },
          {
            "classe": "expand-arrows-alt",
            "nome": "Expandir Setas Alternativas"
          },
          {
            "classe": "expand-alt",
            "nome": "Expandir Alternativo"
          },
          {
            "classe": "expand",
            "nome": "Expandir"
          },
          {
            "classe": "exclamation-triangle",
            "nome": "Triângulo de Aviso"
          },
          {
            "classe": "exclamation-circle",
            "nome": "Círculo de Aviso"
          },
          {
            "classe": "exclamation",
            "nome": "Aviso"
          },
          {
            "classe": "exchange-alt",
            "nome": "Troca Alternativa"
          },
          {
            "classe": "euro-sign",
            "nome": "Símbolo do Euro"
          },
          {
            "classe": "ethernet",
            "nome": "Ethernet"
          },
          {
            "classe": "eraser",
            "nome": "Borracha"
          },
          {
            "classe": "equals",
            "nome": "Igual"
          },
          {
            "classe": "envelope-square",
            "nome": "Envelope Quadrado"
          },
          {
            "classe": "envelope-open-text",
            "nome": "Envelope Aberto com Texto"
          },
          {
            "classe": "envelope-open",
            "nome": "Envelope Aberto"
          },
          {
            "classe": "envelope",
            "nome": "Envelope"
          },
          {
            "classe": "ellipsis-v",
            "nome": "Elipse Vertical"
          },
          {
            "classe": "ellipsis-h",
            "nome": "Elipse Horizontal"
          },
          {
            "classe": "eject",
            "nome": "Ejetar"
          },
          {
            "classe": "egg",
            "nome": "Ovo"
          },
          {
            "classe": "edit",
            "nome": "Editar"
          },
          {
            "classe": "dungeon",
            "nome": "Calabouço"
          },
          {
            "classe": "dumpster-fire",
            "nome": "Lixeira em Chamas"
          },
          {
            "classe": "dumpster",
            "nome": "Lixeira"
          },
          {
            "classe": "dumbbell",
            "nome": "Haltere"
          },
          {
            "classe": "drumstick-bite",
            "nome": "Perna de Frango Mordida"
          },
          {
            "classe": "drum-steelpan",
            "nome": "Tambor de Aço"
          },
          {
            "classe": "drum",
            "nome": "Tambor"
          },
          {
            "classe": "draw-polygon",
            "nome": "Desenhar Polígono"
          },
          {
            "classe": "dragon",
            "nome": "Dragão"
          },
          {
            "classe": "drafting-compass",
            "nome": "Compasso de Desenho"
          },
          {
            "classe": "download",
            "nome": "Download"
          },
          {
            "classe": "dove",
            "nome": "Pomba"
          },
          {
            "classe": "dot-circle",
            "nome": "Círculo com Ponto"
          },
          {
            "classe": "door-open",
            "nome": "Porta Aberta"
          },
          {
            "classe": "door-closed",
            "nome": "Porta Fechada"
          },
          {
            "classe": "donate",
            "nome": "Doar"
          },
          {
            "classe": "dolly-flatbed",
            "nome": "Carreta Plana"
          },
          {
            "classe": "dolly",
            "nome": "Carreta"
          },
          {
            "classe": "dollar-sign",
            "nome": "Símbolo do Dólar"
          },
          {
            "classe": "dog",
            "nome": "Cachorro"
          },
          {
            "classe": "dna",
            "nome": "DNA"
          },
          {
            "classe": "dizzy",
            "nome": "Tonto"
          },
          {
            "classe": "divide",
            "nome": "Dividir"
          },
          {
            "classe": "disease",
            "nome": "Doença"
          },
          {
            "classe": "directions",
            "nome": "Direções"
          },
          {
            "classe": "digital-tachograph",
            "nome": "Tacógrafo Digital"
          }, {
            "classe": "dice-two",
            "nome": "Dado Dois"
          },
          {
            "classe": "dice-three",
            "nome": "Dado Três"
          },
          {
            "classe": "dice-six",
            "nome": "Dado Seis"
          },
          {
            "classe": "dice-one",
            "nome": "Dado Um"
          },
          {
            "classe": "dice-four",
            "nome": "Dado Quatro"
          },
          {
            "classe": "dice-five",
            "nome": "Dado Cinco"
          },
          {
            "classe": "dice-d6",
            "nome": "Dado D6"
          },
          {
            "classe": "dice-d20",
            "nome": "Dado D20"
          },
          {
            "classe": "dice",
            "nome": "Dado"
          },
          {
            "classe": "diagnoses",
            "nome": "Diagnósticos"
          },
          {
            "classe": "dharmachakra",
            "nome": "Dharmachakra"
          },
          {
            "classe": "desktop",
            "nome": "Desktop"
          },
          {
            "classe": "democrat",
            "nome": "Democrata"
          },
          {
            "classe": "deaf",
            "nome": "Surdo"
          },
          {
            "classe": "database",
            "nome": "Banco de Dados"
          },
          {
            "classe": "cut",
            "nome": "Cortar"
          },
          {
            "classe": "cubes",
            "nome": "Cubos"
          },
          {
            "classe": "cube",
            "nome": "Cubo"
          },
          {
            "classe": "crutch",
            "nome": "Muleta"
          },
          {
            "classe": "crown",
            "nome": "Coroa"
          },
          {
            "classe": "crow",
            "nome": "Corvo"
          },
          {
            "classe": "crosshairs",
            "nome": "Mirante"
          },
          {
            "classe": "cross",
            "nome": "Cruz"
          },
          {
            "classe": "crop-alt",
            "nome": "Recortar Alternativo"
          },
          {
            "classe": "crop",
            "nome": "Recortar"
          },
          {
            "classe": "credit-card",
            "nome": "Cartão de Crédito"
          },
          {
            "classe": "couch",
            "nome": "Sofá"
          },
          {
            "classe": "copyright",
            "nome": "Direitos Autorais"
          },
          {
            "classe": "copy",
            "nome": "Copiar"
          },
          {
            "classe": "cookie-bite",
            "nome": "Mordida de Biscoito"
          },
          {
            "classe": "cookie",
            "nome": "Biscoito"
          },
          {
            "classe": "concierge-bell",
            "nome": "Sino de Porteiro"
          },
          {
            "classe": "compress-arrows-alt",
            "nome": "Comprimir Setas Alternativas"
          },
          {
            "classe": "compress-alt",
            "nome": "Comprimir Alternativo"
          },
          {
            "classe": "compress",
            "nome": "Comprimir"
          },
          {
            "classe": "compass",
            "nome": "Bússola"
          },
          {
            "classe": "compact-disc",
            "nome": "Disco Compacto"
          },
          {
            "classe": "comments-dollar",
            "nome": "Comentários com Símbolo de Dólar"
          },
          {
            "classe": "comments",
            "nome": "Comentários"
          },
          {
            "classe": "comment-slash",
            "nome": "Comentário Barrado"
          },
          {
            "classe": "comment-medical",
            "nome": "Comentário Médico"
          },
          {
            "classe": "comment-dots",
            "nome": "Pontos de Comentário"
          },
          {
            "classe": "comment-dollar",
            "nome": "Comentário com Símbolo de Dólar"
          },
          {
            "classe": "comment-alt",
            "nome": "Comentário Alternativo"
          },
          {
            "classe": "comment",
            "nome": "Comentário"
          },
          {
            "classe": "columns",
            "nome": "Colunas"
          },
          {
            "classe": "coins",
            "nome": "Moedas"
          },
          {
            "classe": "cogs",
            "nome": "Engrenagens"
          },
          {
            "classe": "cog",
            "nome": "Engrenagem"
          },
          {
            "classe": "coffee",
            "nome": "Café"
          },
          {
            "classe": "code-branch",
            "nome": "Código de Ramificação"
          },
          {
            "classe": "code",
            "nome": "Código"
          },
          {
            "classe": "cocktail",
            "nome": "Coquetel"
          },
          {
            "classe": "cloud-upload-alt",
            "nome": "Nuvem com Seta para Cima Alternativa"
          },
          {
            "classe": "cloud-sun-rain",
            "nome": "Nuvem com Sol e Chuva"
          },
          {
            "classe": "cloud-sun",
            "nome": "Nuvem com Sol"
          },
          {
            "classe": "cloud-showers-heavy",
            "nome": "Nuvem com Chuvas Intensas"
          },
          {
            "classe": "cloud-rain",
            "nome": "Nuvem com Chuva"
          },
          {
            "classe": "cloud-moon-rain",
            "nome": "Nuvem com Lua e Chuva"
          },
          {
            "classe": "cloud-moon",
            "nome": "Nuvem com Lua"
          },
          {
            "classe": "cloud-meatball",
            "nome": "Nuvem com Polpetone"
          },
          {
            "classe": "cloud-download-alt",
            "nome": "Nuvem com Seta para Baixo Alternativa"
          },
          {
            "classe": "cloud",
            "nome": "Nuvem"
          },
          {
            "classe": "closed-captioning",
            "nome": "Legendas Ocultas"
          },
          {
            "classe": "clone",
            "nome": "Clonar"
          },
          {
            "classe": "clock",
            "nome": "Relógio"
          },
          {
            "classe": "clipboard-list",
            "nome": "Prancheta com Lista"
          },
          {
            "classe": "clipboard-check",
            "nome": "Prancheta com Marca de Verificação"
          },
          {
            "classe": "clipboard",
            "nome": "Prancheta"
          },
          {
            "classe": "clinic-medical",
            "nome": "Clínica Médica"
          },
          {
            "classe": "city",
            "nome": "Cidade"
          },
          {
            "classe": "circle-notch",
            "nome": "Entalhe Circular"
          },
          {
            "classe": "circle",
            "nome": "Círculo"
          },
          {
            "classe": "church",
            "nome": "Igreja"
          },
          {
            "classe": "child",
            "nome": "Criança"
          }, {
            "classe": "chevron-up",
            "nome": "Seta para Cima"
          },
          {
            "classe": "chevron-right",
            "nome": "Seta para a Direita"
          },
          {
            "classe": "chevron-left",
            "nome": "Seta para a Esquerda"
          },
          {
            "classe": "chevron-down",
            "nome": "Seta para Baixo"
          },
          {
            "classe": "chevron-circle-up",
            "nome": "Círculo com Seta para Cima"
          },
          {
            "classe": "chevron-circle-right",
            "nome": "Círculo com Seta para a Direita"
          },
          {
            "classe": "chevron-circle-left",
            "nome": "Círculo com Seta para a Esquerda"
          },
          {
            "classe": "chevron-circle-down",
            "nome": "Círculo com Seta para Baixo"
          },
          {
            "classe": "chess-rook",
            "nome": "Torre de Xadrez"
          },
          {
            "classe": "chess-queen",
            "nome": "Rainha de Xadrez"
          },
          {
            "classe": "chess-pawn",
            "nome": "Peão de Xadrez"
          },
          {
            "classe": "chess-knight",
            "nome": "Cavalo de Xadrez"
          },
          {
            "classe": "chess-king",
            "nome": "Rei de Xadrez"
          },
          {
            "classe": "chess-board",
            "nome": "Tabuleiro de Xadrez"
          },
          {
            "classe": "chess-bishop",
            "nome": "Bispo de Xadrez"
          },
          {
            "classe": "chess",
            "nome": "Xadrez"
          },
          {
            "classe": "cheese",
            "nome": "Queijo"
          },
          {
            "classe": "check-square",
            "nome": "Quadrado de Marcação"
          },
          {
            "classe": "check-double",
            "nome": "Marcação Dupla"
          },
          {
            "classe": "check-circle",
            "nome": "Círculo de Marcação"
          },
          {
            "classe": "check",
            "nome": "Marcação"
          },
          {
            "classe": "chart-pie",
            "nome": "Gráfico de Pizza"
          },
          {
            "classe": "chart-line",
            "nome": "Gráfico de Linha"
          },
          {
            "classe": "chart-bar",
            "nome": "Gráfico de Barras"
          },
          {
            "classe": "chart-area",
            "nome": "Área do Gráfico"
          },
          {
            "classe": "charging-station",
            "nome": "Estação de Carregamento"
          },
          {
            "classe": "chalkboard-teacher",
            "nome": "Quadro-Negro do Professor"
          },
          {
            "classe": "chalkboard",
            "nome": "Quadro-Negro"
          },
          {
            "classe": "chair",
            "nome": "Cadeira"
          },
          {
            "classe": "certificate",
            "nome": "Certificado"
          },
          {
            "classe": "cat",
            "nome": "Gato"
          },
          {
            "classe": "cash-register",
            "nome": "Caixa Registradora"
          },
          {
            "classe": "cart-plus",
            "nome": "Carrinho Adicionar"
          },
          {
            "classe": "cart-arrow-down",
            "nome": "Carrinho com Seta para Baixo"
          },
          {
            "classe": "carrot",
            "nome": "Cenoura"
          },
          {
            "classe": "caret-up",
            "nome": "Seta para Cima"
          },
          {
            "classe": "caret-square-up",
            "nome": "Quadrado com Seta para Cima"
          },
          {
            "classe": "caret-square-right",
            "nome": "Quadrado com Seta para a Direita"
          },
          {
            "classe": "caret-square-left",
            "nome": "Quadrado com Seta para a Esquerda"
          },
          {
            "classe": "caret-square-down",
            "nome": "Quadrado com Seta para Baixo"
          },
          {
            "classe": "caret-right",
            "nome": "Seta para a Direita"
          },
          {
            "classe": "caret-left",
            "nome": "Seta para a Esquerda"
          },
          {
            "classe": "caret-down",
            "nome": "Seta para Baixo"
          },
          {
            "classe": "caravan",
            "nome": "Caravana"
          },
          {
            "classe": "car-side",
            "nome": "Lateral do Carro"
          },
          {
            "classe": "car-crash",
            "nome": "Acidente de Carro"
          },
          {
            "classe": "car-battery",
            "nome": "Bateria de Carro"
          },
          {
            "classe": "car-alt",
            "nome": "Carro Alternativo"
          },
          {
            "classe": "car",
            "nome": "Carro"
          },
          {
            "classe": "capsules",
            "nome": "Cápsulas"
          },
          {
            "classe": "cannabis",
            "nome": "Cannabis"
          },
          {
            "classe": "candy-cane",
            "nome": "Bengala de Natal"
          },
          {
            "classe": "campground",
            "nome": "Parque de Campismo"
          },
          {
            "classe": "camera-retro",
            "nome": "Câmera Retrô"
          },
          {
            "classe": "camera",
            "nome": "Câmera"
          },
          {
            "classe": "calendar-week",
            "nome": "Semana do Calendário"
          },
          {
            "classe": "calendar-times",
            "nome": "Calendário com X"
          },
          {
            "classe": "calendar-plus",
            "nome": "Calendário Adicionar"
          },
          {
            "classe": "calendar-minus",
            "nome": "Calendário Remover"
          },
          {
            "classe": "calendar-day",
            "nome": "Dia do Calendário"
          },
          {
            "classe": "calendar-check",
            "nome": "Calendário com Marcação"
          },
          {
            "classe": "calendar-alt",
            "nome": "Calendário Alternativo"
          },
          {
            "classe": "calendar",
            "nome": "Calendário"
          },
          {
            "classe": "calculator",
            "nome": "Calculadora"
          },
          {
            "classe": "business-time",
            "nome": "Horário Comercial"
          },
          {
            "classe": "bus-alt",
            "nome": "Ônibus Alternativo"
          },
          {
            "classe": "bus",
            "nome": "Ônibus"
          },
          {
            "classe": "burn",
            "nome": "Queimar"
          },
          {
            "classe": "bullseye",
            "nome": "Alvo"
          },
          {
            "classe": "bullhorn",
            "nome": "Megafone"
          },
          {
            "classe": "building",
            "nome": "Edifício"
          },
          {
            "classe": "bug",
            "nome": "Inseto"
          },
          {
            "classe": "brush",
            "nome": "Pincel"
          },
          {
            "classe": "broom",
            "nome": "Vassoura"
          },
          {
            "classe": "broadcast-tower",
            "nome": "Torre de Transmissão"
          },
          {
            "classe": "briefcase-medical",
            "nome": "Maleta Médica"
          },
          {
            "classe": "briefcase",
            "nome": "Maleta"
          },
          {
            "classe": "bread-slice",
            "nome": "Fatia de Pão"
          },
          {
            "classe": "brain",
            "nome": "Cérebro"
          },
          {
            "classe": "braille",
            "nome": "Braille"
          },
          {
            "classe": "boxes",
            "nome": "Caixas"
          },
          {
            "classe": "box-tissue",
            "nome": "Caixa de Lenços"
          },
          {
            "classe": "box-open",
            "nome": "Caixa Aberta"
          },
          {
            "classe": "box",
            "nome": "Caixa"
          },
          {
            "classe": "bowling-ball",
            "nome": "Bola de Boliche"
          },
          {
            "classe": "border-style",
            "nome": "Estilo de Borda"
          },
          {
            "classe": "border-none",
            "nome": "Nenhuma Borda"
          },
          {
            "classe": "border-all",
            "nome": "Borda Completa"
          },
          {
            "classe": "bookmark",
            "nome": "Marcador de Livro"
          },
          {
            "classe": "book-reader",
            "nome": "Leitor de Livros"
          },
          {
            "classe": "book-open",
            "nome": "Livro Aberto"
          },
          {
            "classe": "book-medical",
            "nome": "Livro Médico"
          },
          {
            "classe": "book-dead",
            "nome": "Livro dos Mortos"
          },
          {
            "classe": "book",
            "nome": "Livro"
          },
          {
            "classe": "bong",
            "nome": "Cachimbo de Água"
          },
          {
            "classe": "bone",
            "nome": "Osso"
          },
          {
            "classe": "bomb",
            "nome": "Bomba"
          },
          {
            "classe": "bolt",
            "nome": "Raio"
          },
          {
            "classe": "bold",
            "nome": "Negrito"
          },
          {
            "classe": "blog",
            "nome": "Blog"
          }, {
            "classe": "blind",
            "nome": "Pessoa Cega"
          },
          {
            "classe": "blender-phone",
            "nome": "Liquidificador com Telefone"
          },
          {
            "classe": "blender",
            "nome": "Liquidificador"
          },
          {
            "classe": "birthday-cake",
            "nome": "Bolo de Aniversário"
          },
          {
            "classe": "biohazard",
            "nome": "Risco Biológico"
          },
          {
            "classe": "binoculars",
            "nome": "Binóculos"
          },
          {
            "classe": "biking",
            "nome": "Ciclismo"
          },
          {
            "classe": "bicycle",
            "nome": "Bicicleta"
          },
          {
            "classe": "bible",
            "nome": "Bíblia"
          },
          {
            "classe": "bezier-curve",
            "nome": "Curva Bézier"
          },
          {
            "classe": "bell-slash",
            "nome": "Sino Cortado"
          },
          {
            "classe": "bell",
            "nome": "Sino"
          },
          {
            "classe": "beer",
            "nome": "Cerveja"
          },
          {
            "classe": "bed",
            "nome": "Cama"
          },
          {
            "classe": "battery-three-quarters",
            "nome": "Bateria Três Quartos"
          },
          {
            "classe": "battery-quarter",
            "nome": "Bateria Um Quarto"
          },
          {
            "classe": "battery-half",
            "nome": "Bateria Meia"
          },
          {
            "classe": "battery-full",
            "nome": "Bateria Cheia"
          },
          {
            "classe": "battery-empty",
            "nome": "Bateria Vazia"
          },
          {
            "classe": "bath",
            "nome": "Banho"
          },
          {
            "classe": "basketball-ball",
            "nome": "Bola de Basquete"
          },
          {
            "classe": "baseball-ball",
            "nome": "Bola de Beisebol"
          },
          {
            "classe": "bars",
            "nome": "Barras"
          },
          {
            "classe": "barcode",
            "nome": "Código de Barras"
          },
          {
            "classe": "band-aid",
            "nome": "Curativo"
          },
          {
            "classe": "ban",
            "nome": "Proibido"
          },
          {
            "classe": "balance-scale-right",
            "nome": "Balança à Direita"
          },
          {
            "classe": "balance-scale-left",
            "nome": "Balança à Esquerda"
          },
          {
            "classe": "balance-scale",
            "nome": "Balança"
          },
          {
            "classe": "bahai",
            "nome": "Símbolo Bahá'í"
          },
          {
            "classe": "bacterium",
            "nome": "Bactéria"
          },
          {
            "classe": "bacteria",
            "nome": "Bactéria"
          },
          {
            "classe": "bacon",
            "nome": "Bacon"
          },
          {
            "classe": "backward",
            "nome": "Retroceder"
          },
          {
            "classe": "backspace",
            "nome": "Tecla Apagar"
          },
          {
            "classe": "baby-carriage",
            "nome": "Carrinho de Bebê"
          },
          {
            "classe": "baby",
            "nome": "Bebê"
          },
          {
            "classe": "award",
            "nome": "Prêmio"
          },
          {
            "classe": "audio-description",
            "nome": "Descrição de Áudio"
          },
          {
            "classe": "atom",
            "nome": "Átomo"
          },
          {
            "classe": "atlas",
            "nome": "Atlas"
          },
          {
            "classe": "at",
            "nome": "Em"
          },
          {
            "classe": "asterisk",
            "nome": "Asterisco"
          },
          {
            "classe": "assistive-listening-systems",
            "nome": "Sistemas de Audição Assistida"
          },
          {
            "classe": "arrows-alt-v",
            "nome": "Setas Alternadas Verticalmente"
          },
          {
            "classe": "arrows-alt-h",
            "nome": "Setas Alternadas Horizontalmente"
          },
          {
            "classe": "arrows-alt",
            "nome": "Setas Alternadas"
          },
          {
            "classe": "arrow-up",
            "nome": "Seta para Cima"
          },
          {
            "classe": "arrow-right",
            "nome": "Seta para a Direita"
          },
          {
            "classe": "arrow-left",
            "nome": "Seta para a Esquerda"
          },
          {
            "classe": "arrow-down",
            "nome": "Seta para Baixo"
          },
          {
            "classe": "arrow-circle-up",
            "nome": "Círculo com Seta para Cima"
          },
          {
            "classe": "arrow-circle-right",
            "nome": "Círculo com Seta para a Direita"
          },
          {
            "classe": "arrow-circle-left",
            "nome": "Círculo com Seta para a Esquerda"
          },
          {
            "classe": "arrow-circle-down",
            "nome": "Círculo com Seta para Baixo"
          },
          {
            "classe": "arrow-alt-circle-up",
            "nome": "Círculo Alternativo com Seta para Cima"
          },
          {
            "classe": "arrow-alt-circle-right",
            "nome": "Círculo Alternativo com Seta para a Direita"
          },
          {
            "classe": "arrow-alt-circle-left",
            "nome": "Círculo Alternativo com Seta para a Esquerda"
          },
          {
            "classe": "arrow-alt-circle-down",
            "nome": "Círculo Alternativo com Seta para Baixo"
          },
          {
            "classe": "archway",
            "nome": "Arcada"
          },
          {
            "classe": "archive",
            "nome": "Arquivo"
          },
          {
            "classe": "apple-alt",
            "nome": "Maçã Alternativa"
          },
          {
            "classe": "ankh",
            "nome": "Ankh"
          },
          {
            "classe": "angry",
            "nome": "Zangado"
          },
          {
            "classe": "angle-up",
            "nome": "Ângulo para Cima"
          },
          {
            "classe": "angle-right",
            "nome": "Ângulo para a Direita"
          },
          {
            "classe": "angle-left",
            "nome": "Ângulo para a Esquerda"
          },
          {
            "classe": "angle-down",
            "nome": "Ângulo para Baixo"
          },
          {
            "classe": "angle-double-up",
            "nome": "Ângulo Duplo para Cima"
          },
          {
            "classe": "angle-double-right",
            "nome": "Ângulo Duplo para a Direita"
          },
          {
            "classe": "angle-double-left",
            "nome": "Ângulo Duplo para a Esquerda"
          },
          {
            "classe": "angle-double-down",
            "nome": "Ângulo Duplo para Baixo"
          },
          {
            "classe": "anchor",
            "nome": "Âncora"
          },
          {
            "classe": "american-sign-language-interpreting",
            "nome": "Interpretação de Linguagem de Sinais Americana"
          },
          {
            "classe": "ambulance",
            "nome": "Ambulância"
          },
          {
            "classe": "allergies",
            "nome": "Alergias"
          },
          {
            "classe": "align-right",
            "nome": "Alinhar à Direita"
          },
          {
            "classe": "align-left",
            "nome": "Alinhar à Esquerda"
          },
          {
            "classe": "align-justify",
            "nome": "Justificar Alinhamento"
          },
          {
            "classe": "align-center",
            "nome": "Centralizar Alinhamento"
          },
          {
            "classe": "air-freshener",
            "nome": "Odorizador de Ar"
          },
          {
            "classe": "adjust",
            "nome": "Ajustar"
          },
          {
            "classe": "address-card",
            "nome": "Cartão de Endereço"
          },
          {
            "classe": "address-book",
            "nome": "Agenda de Endereços"
          },
          {
            "classe": "ad",
            "nome": "Anúncio"
          },
          {
            "classe": "window-restore",
            "nome": "Restaurar Janela"
          },
          {
            "classe": "window-minimize",
            "nome": "Minimizar Janela"
          },
          {
            "classe": "window-maximize",
            "nome": "Maximizar Janela"
          },
          {
            "classe": "window-close",
            "nome": "Fechar Janela"
          },
          {
            "classe": "user-circle",
            "nome": "Círculo do Usuário"
          },
          {
            "classe": "user",
            "nome": "Usuário"
          },
          {
            "classe": "trash-alt",
            "nome": "Lixeira Alternativa"
          },
          {
            "classe": "tired",
            "nome": "Cansado"
          },
          {
            "classe": "times-circle",
            "nome": "Círculo de X"
          },
          {
            "classe": "thumbs-up",
            "nome": "Polegar para Cima"
          },
          {
            "classe": "thumbs-down",
            "nome": "Polegar para Baixo"
          },
          {
            "classe": "surprise",
            "nome": "Surpresa"
          },
          {
            "classe": "sun",
            "nome": "Sol"
          },
          {
            "classe": "stop-circle",
            "nome": "Círculo de Parada"
          },
          {
            "classe": "sticky-note",
            "nome": "Nota Adesiva"
          },
          {
            "classe": "star-half",
            "nome": "Estrela Meia"
          },
          {
            "classe": "star",
            "nome": "Estrela"
          },
          {
            "classe": "square",
            "nome": "Quadrado"
          },
          {
            "classe": "snowflake",
            "nome": "Floco de Neve"
          },
          {
            "classe": "smile-wink",
            "nome": "Sorriso com Olho Pisado"
          },
          {
            "classe": "smile-beam",
            "nome": "Sorriso com Feixe"
          },
          {
            "classe": "smile",
            "nome": "Sorriso"
          },
          {
            "classe": "share-square",
            "nome": "Compartilhar Quadrado"
          },
          {
            "classe": "save",
            "nome": "Salvar"
          },
          {
            "classe": "sad-tear",
            "nome": "Lágrima Triste"
          },
          {
            "classe": "sad-cry",
            "nome": "Choro Triste"
          },
          {
            "classe": "registered",
            "nome": "Registrado"
          },
          {
            "classe": "question-circle",
            "nome": "Círculo de Pergunta"
          },
          {
            "classe": "plus-square",
            "nome": "Mais Quadrado"
          },
          {
            "classe": "play-circle",
            "nome": "Círculo de Reprodução"
          },
          {
            "classe": "pause-circle",
            "nome": "Círculo de Pausa"
          },
          {
            "classe": "paper-plane",
            "nome": "Avião de Papel"
          },
          {
            "classe": "object-ungroup",
            "nome": "Desagrupar Objeto"
          },
          {
            "classe": "object-group",
            "nome": "Agrupar Objeto"
          },
          {
            "classe": "newspaper",
            "nome": "Jornal"
          },
          {
            "classe": "moon",
            "nome": "Lua"
          },
          {
            "classe": "money-bill-alt",
            "nome": "Cédula de Dinheiro Alternativa"
          },
          {
            "classe": "minus-square",
            "nome": "Menos Quadrado"
          },
          {
            "classe": "meh-rolling-eyes",
            "nome": "Meh com Olhos Rolando"
          },
          {
            "classe": "meh-blank",
            "nome": "Meh em Branco"
          },
          {
            "classe": "meh",
            "nome": "Meh"
          },
          {
            "classe": "map",
            "nome": "Mapa"
          },
          {
            "classe": "list-alt",
            "nome": "Lista Alternativa"
          },
          {
            "classe": "lightbulb",
            "nome": "Lâmpada"
          },
          {
            "classe": "life-ring",
            "nome": "Anel Salva-Vidas"
          },
          {
            "classe": "lemon",
            "nome": "Limão"
          },
          {
            "classe": "laugh-wink",
            "nome": "Risada com Olho Pisado"
          },
          {
            "classe": "laugh-squint",
            "nome": "Risada com Olhos Semicerrados"
          },
          {
            "classe": "laugh-beam",
            "nome": "Risada com Feixe"
          },
          {
            "classe": "laugh",
            "nome": "Risada"
          },
          {
            "classe": "kiss-wink-heart",
            "nome": "Beijo com Olho Pisado e Coração"
          },
          {
            "classe": "kiss-beam",
            "nome": "Beijo com Feixe"
          },
          {
            "classe": "kiss",
            "nome": "Beijo"
          },
          {
            "classe": "keyboard",
            "nome": "Teclado"
          },
          {
            "classe": "images",
            "nome": "Imagens"
          },
          {
            "classe": "image",
            "nome": "Imagem"
          },
          {
            "classe": "id-card",
            "nome": "Cartão de Identificação"
          },
          {
            "classe": "id-badge",
            "nome": "Crachá de Identificação"
          },
          {
            "classe": "hourglass",
            "nome": "Ampulheta"
          },
          {
            "classe": "hospital",
            "nome": "Hospital"
          },
          {
            "classe": "heart",
            "nome": "Coração"
          },
          {
            "classe": "hdd",
            "nome": "Disco Rígido"
          },
          {
            "classe": "handshake",
            "nome": "Aperto de Mão"
          },
          {
            "classe": "hand-spock",
            "nome": "Mão Spock"
          },
          {
            "classe": "hand-scissors",
            "nome": "Tesoura na Mão"
          },
          {
            "classe": "hand-rock",
            "nome": "Pedra na Mão"
          },
          {
            "classe": "hand-pointer",
            "nome": "Mão Apontando"
          },
          {
            "classe": "hand-point-up",
            "nome": "Mão Apontando para Cima"
          },
          {
            "classe": "hand-point-right",
            "nome": "Mão Apontando para a Direita"
          },
          {
            "classe": "hand-point-left",
            "nome": "Mão Apontando para a Esquerda"
          },
          {
            "classe": "hand-point-down",
            "nome": "Mão Apontando para Baixo"
          },
          {
            "classe": "hand-peace",
            "nome": "Mão da Paz"
          },
          {
            "classe": "hand-paper",
            "nome": "Mão com Papel"
          },
          {
            "classe": "hand-lizard",
            "nome": "Lagarto na Mão"
          },
          {
            "classe": "grin-wink",
            "nome": "Grin com Olho Pisado"
          },
          {
            "classe": "grin-tongue-wink",
            "nome": "Grin com Língua e Olho Pisado"
          },
          {
            "classe": "grin-tongue-squint",
            "nome": "Grin com Língua e Olhos Semicerrados"
          },
          {
            "classe": "grin-tongue",
            "nome": "Grin com Língua"
          },
          {
            "classe": "grin-tears",
            "nome": "Grin com Lágrimas"
          },
          {
            "classe": "grin-stars",
            "nome": "Risada com Estrelas"
          },
          {
            "classe": "grin-squint-tears",
            "nome": "Risada com Lágrimas e Olhos Semifechados"
          },
          {
            "classe": "grin-squint",
            "nome": "Risada com Olhos Semifechados"
          },
          {
            "classe": "grin-hearts",
            "nome": "Risada com Corações"
          },
          {
            "classe": "grin-beam-sweat",
            "nome": "Risada com Feixes de Suor"
          },
          {
            "classe": "grin-beam",
            "nome": "Risada com Feixes"
          },
          {
            "classe": "grin-alt",
            "nome": "Risada Alternativa"
          },
          {
            "classe": "grin",
            "nome": "Risada"
          },
          {
            "classe": "grimace",
            "nome": "Careta"
          },
          {
            "classe": "gem",
            "nome": "Gema"
          },
          {
            "classe": "futbol",
            "nome": "Futebol"
          },
          {
            "classe": "frown-open",
            "nome": "Tristeza Aberta"
          },
          {
            "classe": "frown",
            "nome": "Tristeza"
          },
          {
            "classe": "folder-open",
            "nome": "Pasta Aberta"
          },
          {
            "classe": "folder",
            "nome": "Pasta"
          },
          {
            "classe": "flushed",
            "nome": "Envergonhado"
          },
          {
            "classe": "flag",
            "nome": "Bandeira"
          },
          {
            "classe": "file-word",
            "nome": "Arquivo do Word"
          },
          {
            "classe": "file-video",
            "nome": "Arquivo de Vídeo"
          },
          {
            "classe": "file-powerpoint",
            "nome": "Arquivo do PowerPoint"
          },
          {
            "classe": "file-pdf",
            "nome": "Arquivo PDF"
          },
          {
            "classe": "file-image",
            "nome": "Arquivo de Imagem"
          },
          {
            "classe": "file-excel",
            "nome": "Arquivo do Excel"
          },
          {
            "classe": "file-code",
            "nome": "Arquivo de Código"
          },
          {
            "classe": "file-audio",
            "nome": "Arquivo de Áudio"
          },
          {
            "classe": "file-archive",
            "nome": "Arquivo Compactado"
          },
          {
            "classe": "file-alt",
            "nome": "Arquivo Alternativo"
          },
          {
            "classe": "file",
            "nome": "Arquivo"
          },
          {
            "classe": "eye-slash",
            "nome": "Olho Riscado"
          },
          {
            "classe": "eye",
            "nome": "Olho"
          },
          {
            "classe": "envelope-open",
            "nome": "Envelope Aberto"
          },
          {
            "classe": "envelope",
            "nome": "Envelope"
          },
          {
            "classe": "edit",
            "nome": "Editar"
          },
          {
            "classe": "dot-circle",
            "nome": "Círculo Preenchido"
          },
          {
            "classe": "dizzy",
            "nome": "Zonzo"
          },
          {
            "classe": "credit-card",
            "nome": "Cartão de Crédito"
          },
          {
            "classe": "copyright",
            "nome": "Direitos Autorais"
          },
          {
            "classe": "copy",
            "nome": "Copiar"
          },
          {
            "classe": "compass",
            "nome": "Bússola"
          },
          {
            "classe": "comments",
            "nome": "Comentários"
          },
          {
            "classe": "comment-dots",
            "nome": "Pontos de Comentário"
          },
          {
            "classe": "comment-alt",
            "nome": "Comentário Alternativo"
          },
          {
            "classe": "comment",
            "nome": "Comentário"
          },
          {
            "classe": "closed-captioning",
            "nome": "Legendas"
          },
          {
            "classe": "clone",
            "nome": "Clonar"
          },
          {
            "classe": "clock",
            "nome": "Relógio"
          },
          {
            "classe": "clipboard",
            "nome": "Área de Transferência"
          },
          {
            "classe": "circle",
            "nome": "Círculo"
          },
          {
            "classe": "check-square",
            "nome": "Marca Quadrada"
          },
          {
            "classe": "check-circle",
            "nome": "Marca de Verificação Circular"
          },
          {
            "classe": "chart-bar",
            "nome": "Gráfico de Barras"
          },
          {
            "classe": "caret-square-up",
            "nome": "Seta Quadrada para Cima"
          },
          {
            "classe": "caret-square-right",
            "nome": "Seta Quadrada para a Direita"
          },
          {
            "classe": "caret-square-left",
            "nome": "Seta Quadrada para a Esquerda"
          },
          {
            "classe": "caret-square-down",
            "nome": "Seta Quadrada para Baixo"
          },
          {
            "classe": "calendar-times",
            "nome": "Calendário com X"
          },
          {
            "classe": "calendar-plus",
            "nome": "Calendário com Mais"
          },
          {
            "classe": "calendar-minus",
            "nome": "Calendário com Menos"
          },
          {
            "classe": "calendar-check",
            "nome": "Calendário com Marcação"
          },
          {
            "classe": "calendar-alt",
            "nome": "Calendário Alternativo"
          },
          {
            "classe": "calendar",
            "nome": "Calendário"
          },
          {
            "classe": "building",
            "nome": "Edifício"
          },
          {
            "classe": "bookmark",
            "nome": "Marcador de Página"
          },
          {
            "classe": "bell-slash",
            "nome": "Sino Cortado"
          },
          {
            "classe": "bell",
            "nome": "Sino"
          }, {
            "classe": "arrow-alt-circle-up",
            "nome": "Seta Alternativa para Cima em Círculo"
          },
          {
            "classe": "arrow-alt-circle-right",
            "nome": "Seta Alternativa para a Direita em Círculo"
          },
          {
            "classe": "arrow-alt-circle-left",
            "nome": "Seta Alternativa para a Esquerda em Círculo"
          },
          {
            "classe": "arrow-alt-circle-down",
            "nome": "Seta Alternativa para Baixo em Círculo"
          },
          {
            "classe": "angry",
            "nome": "Zangado"
          },
          {
            "classe": "address-card",
            "nome": "Cartão de Endereço"
          },
          {
            "classe": "address-book",
            "nome": "Agenda de Endereços"
          }
        ]

        async function carregaIcones() {
          const defaultOption = new Option('Selecione um ícone', '', true, false);
          $('#txtSelectIcone').append(defaultOption);
          for (let i = 0; i < listaClassesFontAwesome.length; i++) {
            const element = listaClassesFontAwesome[i];
            const novaOpcao = new Option(element.nome, 'fas fa-' + element.classe, false, false);
            $('#txtSelectIcone').append(novaOpcao);
            $('#txtSelectIcone').trigger('change');
          }
        }
        carregaIcones();

        $('#txtSelectIcone').on('change', function(e) {
          const iconClass = $('#txtSelectIcone').val();
          $('#selectedIcon').html(`<i style="font-size: 2rem; " class="${iconClass}"></i>`);
        });


        async function carregaFiltros(id_dash) {
          const _url = `/sisplan/funcoes/v1/pesquisa?`;
          const pesquisa = {
            camposSelect: ['ID', 'NOME', 'ID_DASH', 'TIPO', 'TABELA', 'CAMPO', 'VALOR_PADRAO', 'VALOR_TESTE', 'OBRIGATORIO', 'CAMPO_DESC', 'LABEL', 'VARIOS', 'UTILIZA_EMP_ID', 'OPCAO_DATA'],
            tabela: 'DASH_FILTROS',
            orderBy: ['ID_DASH'],
            where: [`ID_DASH = ${id_dash}`]
          }

          try {
            const response = await requisicao('GET', _url, `JSON=${JSON.stringify(pesquisa)}`,
              null);
            if (!response) {
              return;
            }
            const jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem)
              return;
            }
            //aqui tem que criar os datasets no html e arrGraficos...
            for (let i = 0; i < jsonStr['RESULT'][0].length; i++) {
              const filtro = jsonStr['RESULT'][0][i];
              const objeto = {
                ORDEM: $('#tabela-filtros').DataTable().data().toArray().length,
                NOME: filtro.NOME,
                TIPO: filtro.TIPO,
                TABELA: filtro.TABELA,
                CAMPO: filtro.CAMPO,
                VALOR_PADRAO: filtro.VALOR_PADRAO,
                VALOR_TESTE: filtro.VALOR_TESTE,
                OBRIGATORIO: filtro.OBRIGATORIO,
                CAMPO_DESC: filtro.CAMPO_DESC,
                LABEL: filtro.LABEL,
                VARIOS: filtro.VARIOS,
                UTILIZA_EMP_ID: filtro.UTILIZA_EMP_ID,
                OPCAO_DATA: filtro.OPCAO_DATA
              }
              $('#tabela-filtros').DataTable().row.add(objeto).draw(false)

              addClickOrder();
            }
          } catch (error) {
            console.error(error);
            msgErro(error);
          }

        }

        function addClickOrder() {
          $('.orderUp').off('click');
          $('.orderUp').on('click', function() {
            const dados = $('#tabela-filtros').DataTable().row($(this).closest('tr')).data();
            const dadosDeCima = $('#tabela-filtros').DataTable().row(dados.ORDEM - 1).data();
            const ordemAtual = dados.ORDEM;
            const ordemDeCima = dadosDeCima.ORDEM;

            if (ordemAtual == 0) {
              msgAlerta('Primeiro registro.');
              return;
            }

            const novosDados = {
              ...dados,
              ORDEM: ordemAtual - 1
            };
            $('#tabela-filtros').DataTable().row(dadosDeCima.ORDEM).data(novosDados).draw(false);

            const novosDadosDeCima = {
              ...dadosDeCima,
              ORDEM: ordemDeCima + 1
            };
            $('#tabela-filtros').DataTable().row($(this).closest('tr')).data(novosDadosDeCima).draw(false);
            addClickOrder();
          });

          $('.orderDown').off('click');
          $('.orderDown').on('click', function() {
            const dados = $('#tabela-filtros').DataTable().row($(this).closest('tr')).data();
            const dadosDeBaixo = $('#tabela-filtros').DataTable().row(dados.ORDEM + 1).data();
            const ordemAtual = dados.ORDEM;
            const ordemDeCima = dadosDeBaixo.ORDEM;
            const totalRegistros = $('#tabela-filtros').DataTable().data().toArray().length - 1;


            if (dados.ORDEM == totalRegistros) {
              msgAlerta('Último registro.');
              return;
            }

            const novosDados = {
              ...dados,
              ORDEM: ordemAtual + 1
            };
            $('#tabela-filtros').DataTable().row(dadosDeBaixo.ORDEM).data(novosDados).draw(false);

            const novosDadosDeBaixo = {
              ...dadosDeBaixo,
              ORDEM: ordemDeCima - 1
            };
            $('#tabela-filtros').DataTable().row($(this).closest('tr')).data(novosDadosDeBaixo).draw(false);
            addClickOrder();

          });
        }

        async function callbackTabela() {
          const tabela = $('#txtTabelaFiltro').attr('data-chave');
          $('#txtCampoFiltro').unbind('autocompleta');
          $('#txtCampoFiltro').autocompleta(1, `JSON={ "tabela":"TABELAS_SISPLAN", "camposSelect":[ "CAMPO CHAVE", "CAMPO DESCRICAO"], "where": ["TABELA = '${tabela}'"]}`, [], [], []);
          $('#btnCampoFiltro').off();
          $('#btnCampoFiltro').unbind('pesquisa_array');
          $('#btnCampoFiltro').pesquisa_array(['#txtCampoFiltro'], ['CAMPO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABELAS_SISPLAN", "camposSelect":[ "CAMPO", "CAMPO descricao"], "where": ["TABELA = '${tabela}'"]}`, 'Pesquisa Campo', 'tabela');

          // desc

          $('#txtCampoDescFiltro').unbind('autocompleta');
          $('#txtCampoDescFiltro').autocompleta(1, `JSON={ "tabela":"TABELAS_SISPLAN", "camposSelect":[ "CAMPO CHAVE", "CAMPO DESCRICAO"], "where": ["TABELA = '${tabela}'"]}`, [], [], []);
          $('#btnCampoDescFiltro').off();
          $('#btnCampoDescFiltro').unbind('pesquisa_array');
          $('#btnCampoDescFiltro').pesquisa_array(['#txtCampoDescFiltro'], ['CAMPO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABELAS_SISPLAN", "camposSelect":[ "CAMPO", "CAMPO descricao"], "where": ["TABELA = '${tabela}'"]}`, 'Pesquisa Campo', 'tabela');

        }

        $('#txtTabelaFiltro').autocompleta(1, `JSON={ "tabela":"TABELAS_SISPLAN", "camposSelect":["DISTINCT TABELA CHAVE", "TABELA descricao"],"where": [], "orderBy": ["TABELA"]}`, [], [], [], callbackTabela);
        $('#btnTabelaFiltro').pesquisa_array(['#txtTabelaFiltro'], ['TABELA'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON=${JSON.stringify(pesquisaTabela)}`, 'Pesquisa de Tabelas', 'tabela', callbackTabela);


        $('#btnLimpaTabelaFiltro').on('click', function() {
          limpaValor('#txtTabelaFiltro');
          limpaValor('#txtCampoFiltro');
          limpaValor('#txtCampoDescFiltro');
        });

        $('#btnLimpaCampoDescFiltro').on('click', function() {
          limpaValor('#txtCampoDescFiltro');
        });

        $('#btnLimpaCampoFiltro').on('click', function() {
          limpaValor('#txtCampoFiltro');
        });


        $('#txtTipoFiltro').on('change', function() {
          if ($(this).val() == 0) {
            $('.camposTexto').removeClass('d-none');
          } else {
            $('.camposTexto').addClass('d-none');
            limpaValor('.camposTexto');
          }

          if ($(this).val() == 1) {
            $('.camposData').removeClass('d-none');
          } else {
            $('.camposData').addClass('d-none');
          }

        });

        $('#txtNomeFiltro').keyup(function() {
          this.value = this.value.toLocaleUpperCase();
        });

        function retornaBotaoOpcoes() {
          return (
            '<div style="text-align:center;"><button id="btn-editar-filtro" class="btn btn-secondary btn-xs btn-editar-filtro px-2"><i class="fas fa-edit mr-1"></i><span style="font-size: 14px">Editar </span></button></div>'
          );
        }

        const dataSetCols = [];

        const keys = ['ORDEM', 'NOME', 'TIPO', 'TABELA', 'CAMPO', 'VALOR_PADRAO', 'VALOR_TESTE', 'OBRIGATORIO', 'LABEL', 'CAMPO_DESC', 'VARIOS', 'UTILIZA_EMP_ID', 'ACAO'];

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        dataSetCols[12].render = function(data, type, row) {
          return `<div class="flex"> ` +
            `  <button type="button" class="orderUp btn btn-danger btn-xs mr-2"><i class="fas fa-arrow-up text-white"></i></button>` +
            `  <button type="button" class="orderDown btn btn-danger btn-xs"><i class="fas fa-arrow-down text-white"></i></button>` +
            `</div>`
        }

        $('#tabela-filtros').DataTable({
          paging: false,
          filter: false,
          info: false,
          order: false,
          destroy: true,
          autoWidth: true,
          columns: dataSetCols,
          columnDefs: [{
            targets: [5, 6, 7, 8, 9, 10, 11, 12],
            visible: false
          }],
        });

        $('#tabela-filtros').DataTable().columns.adjust().draw(false);


        async function limpaCamposFiltro() {
          $('#txtOrdemFiltro').val('');
          $('#txtNomeFiltro').val('');
          $('#txtTipoFiltro').val('0').trigger('change');
          limpaValor('#txtTabelaFiltro');
          limpaValor('#txtCampoFiltro');
          limpaValor('#txtCampoDescFiltro');
          $('#txtValorPadraoFiltro').val('');
          $('#txtOpcaoData').val('0').trigger('change');
          $('#txtValorTesteFiltro').val('');
          $('#txtLabelFiltro').val('');
          $('#cbCampoObrigatorioFiltro').prop('checked', false).trigger('change');
          $('#cbVariosFiltro').prop('checked', false).trigger('change');
          $('#cbEmpId').prop('checked', false).trigger('change');

        }


        $('#tabela-filtros tbody').on('click', 'tr', async function() {
          if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
          } else {
            $('#tabela-filtros').DataTable().$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
          }
        });

        $("#select_dataset").on("select2:select", function(evt) {
          var element = evt.params.data.element;
          var $element = $(element);

          $element.detach();
          $(this).append($element);
          $(this).trigger("change");
        });



        function habilitaPanelFiltros(bHabilita) {
          const componentesInput = $('#panelFiltrosCad input');
          for (let i = 0; i < componentesInput.length; i++) {
            const element = componentesInput[i];
            $(element).prop('disabled', !bHabilita);
          }

          const componentesSelect = $('#panelFiltrosCad select');
          for (let i = 0; i < componentesSelect.length; i++) {
            const element = componentesSelect[i];
            $(element).prop('disabled', !bHabilita);
          }

          if (bHabilita) {
            $('.habilitado').removeClass('d-none');
            $('.desabilitado').addClass('d-none');
          } else {
            $('.habilitado').addClass('d-none');
            $('.desabilitado').removeClass('d-none');
          }
        }

        function setSelect2ValuesInOrder(selector, values) {
          // Limpa a seleção atual
          $(selector).val(null).trigger("change");

          // Adiciona cada valor na ordem especificada
          values.forEach(value => {
            // Define o valor atual como selecionado
            let option = $(selector).find("option[value='" + value + "']");

            // Marca o item como selecionado e dispara o evento de seleção
            if (option.length) {
              option.prop("selected", true);
              $(selector).trigger({
                type: 'select2:select',
                params: {
                  data: {
                    element: option[0]
                  }
                }
              });
            }
          });

          // Atualiza o Select2 para refletir os valores selecionados
          $(selector).trigger("change");
        }



        $('#btn-confirmar-filtro').on('click', function() {
          const obj = {
            ORDEM: $('#txtOrdemFiltro').val() != '' ? $('#txtOrdemFiltro').val() : $('#tabela-filtros').DataTable().data().toArray().length,
            NOME: $('#txtNomeFiltro').val().toUpperCase().replaceAll(' ', '').replaceAll(':', '').trim(),
            TIPO: $('#txtTipoFiltro').val(),
            TABELA: $('#txtTipoFiltro').val() == 0 ? pegaChave('#txtTabelaFiltro') : '',
            CAMPO: $('#txtTipoFiltro').val() == 0 ? pegaChave('#txtCampoFiltro') : '',
            VALOR_PADRAO: $('#txtValorPadraoFiltro').val(),
            VALOR_TESTE: $('#txtValorTesteFiltro').val(),
            OBRIGATORIO: $('#cbCampoObrigatorioFiltro').prop('checked') ? 'S' : 'N',
            CAMPO_DESC: $('#txtTipoFiltro').val() == 0 ? pegaChave('#txtCampoDescFiltro') : '',
            LABEL: $('#txtLabelFiltro').val(),
            VARIOS: $('#cbVariosFiltro').prop('checked') ? 'S' : 'N',
            UTILIZA_EMP_ID: $('#cbEmpId').prop('checked') ? 'S' : 'N',
            OPCAO_DATA: $('#txtOpcaoData').val()
          }



          if ($('#txtNomeFiltro').val() == '') {
            msgAlerta('Nome não informado, verifique.');
            return;
          }

          if ($('#txtLabelFiltro').val() == '') {
            msgAlerta('Label não informado, verifique.');
            return;
          }

          if ($('#txtNomeFiltro').val() != '') {
            const dados = $('#tabela-filtros').DataTable().data().toArray();
            const jaExisteEsseNome = dados.filter(item => item.NOME == $('#txtNomeFiltro').val().toUpperCase().replaceAll(' ', '').replaceAll(':', '').trim()).length > 0 && $('#txtOrdemFiltro').val() == '';
            if (jaExisteEsseNome) {
              msgAlerta('Nome informado já existe na lista, verifique');
              return;
            }
          }


          if ($('#txtTipoFiltro').val() == 0) {
            if ($('#txtTabelaFiltro').val() == '') {
              msgAlerta('Tabela não informada, verifique.');
              return;
            }
            if ($('#txtCampoFiltro').val() == '') {
              msgAlerta('Campo não informado, verifique.');
              return;
            }
            if ($('#txtCampoDescFiltro').val() == '') {
              msgAlerta('Campo de Descrição não informado, verifique.');
              return;
            }
          }


          const emEdicao = $('#txtOrdemFiltro').val() != '';
          if (emEdicao) {
            $('#tabela-filtros').DataTable().row($('#txtOrdemFiltro').val()).data(obj);
          } else {
            $('#tabela-filtros').DataTable().row.add(obj).draw(false);
          }

          limpaCamposFiltro();
          // $('#txtNomeFiltro').focus();

          habilitaPanelFiltros(false);
          addClickOrder();
        });

        $('#btn-incluir-filtro').on('click', function() {
          habilitaPanelFiltros(true);
          $('.camposData').addClass('d-none');
          $('#txtNomeFiltro').focus();
        });

        $('#btn-alterar-filtro').on('click', function() {
          const dadosSelecionados = $('#tabela-filtros').DataTable().row($('tr.selected')).data();
          if (!dadosSelecionados) {
            msgAlerta('Necessário selecionar algum registro para alterar.');
            return;
          }

          habilitaPanelFiltros(true);
          $('#txtOrdemFiltro').val(dadosSelecionados.ORDEM);
          $('#txtNomeFiltro').val(dadosSelecionados.NOME);
          $('#txtLabelFiltro').val(dadosSelecionados.LABEL);
          $('#cbVariosFiltro').prop('checked', dadosSelecionados.VARIOS == 'S');
          $('#cbEmpId').prop('checked', dadosSelecionados.UTILIZA_EMP_ID == 'S');
          $('#txtTipoFiltro').val(dadosSelecionados.TIPO).trigger('change');
          insereValor('#txtTabelaFiltro', dadosSelecionados.TABELA, dadosSelecionados.TABELA);
          insereValor('#txtCampoFiltro', dadosSelecionados.CAMPO, dadosSelecionados.CAMPO);
          insereValor('#txtCampoDescFiltro', dadosSelecionados.CAMPO_DESC, dadosSelecionados.CAMPO_DESC);
          insereValor('#txtValorPadraoFiltro', dadosSelecionados.VALOR_PADRAO);
          $('#txtOpcaoData').val(dadosSelecionados.OPCAO_DATA).trigger('change');
          insereValor('#txtValorTesteFiltro', dadosSelecionados.VALOR_TESTE);
          $('#cbCampoObrigatorioFiltro').prop('checked', dadosSelecionados.OBRIGATORIO == 'S');
        });

        $('#btn-excluir-filtro').on('click', function() {
          const dadosSelecionados = $('#tabela-filtros').DataTable().row($('tr.selected')).data();
          if (!dadosSelecionados) {
            msgAlerta('Necessário selecionar algum registro para excluir.');
            return;
          }

          $('#tabela-filtros').DataTable().row($('tr.selected')).remove().draw(false);
          msgSucesso('Excluído com sucesso');

        });

        $('#btn-desistir-filtro').on('click', function() {
          habilitaPanelFiltros(false);
          limpaCamposFiltro();
        });


        $('.select2').select2({
          sorter: function(data) {
            return data; // Retorna os dados sem ordenar
          }
        });
        $("#select_dataset").select2({
          multiple: true,
          allowClear: true,
          sorter: function(data) {
            return data; // Retorna os dados sem ordenar
          }
        });
        $('.select2bs4').select2({
          theme: 'bootstrap4'
        });

        var totalGrafs = 0;
        var totalDataSets = 0;
        var arrGraficos = [];
        var arrDataSets = [];
        var formatar = window.sqlFormatter.format;

        var reordered = function($elements) {
          for (let i = 0; i < $elements.length; i++) {
            const element = $elements[i];
            const id = element.id.split('-')[1];
            const iPosicaoArray = arrGraficos.findIndex(obj => {
              return obj.id == id;
            });

            if (iPosicaoArray != -1) {
              arrGraficos[iPosicaoArray].ordem = i;
            }
          }
        };

        $('.gridly').gridly({
          base: 60, // px 
          gutter: 20, // px
          columns: 12,
          callbacks: {
            reordered: reordered
          }
        });

        $("#inputColor").on("change", function() {
          const selectedColor = $(this).val();
          $("#cardColorCustom").val(selectedColor);
        });

        $("input[name='radioColorCard']").on('change', function() {
          $("#cardColorGradient").prop('checked', false);
          $("#cardColorGradient").val('');
        });

        $("#inputGradientIni , #inputGradientFim").on("change", function() {
          const corInicial = $("#inputGradientIni").val();
          const corFinal = $("#inputGradientFim").val();
          const selectedColor = corInicial + ' ' + corFinal;
          $("#cardColorGradient").val(selectedColor).prop('checked', true);
          $("input[name='radioColorCard']").prop('checked', false);
        });

        $("#cardColorGradient").on('change', function() {
          $("input[name='radioColorCard']").prop('checked', false);
        });

        function bloqueiaEdicao() {
          $('.btn-sisp').attr('disabled', 'disabled');
          $('.btn-sisp').off();
          // $('.edit').attr('disabled', 'disabled');
          // $('.edit').off();
          // $('.delete').attr('disabled', 'disabled');
          // $('.delete').off();
        }

        $('#select_dataset').on('change', function() {
          let colunasArrayAtual = [];
          let arrayUnico = [];
          const value = $(this).val();
          if (typeof(value) === 'string') {
            const iPosicaoArray = arrDataSets.findIndex(obj => {
              return obj.id_banco == value;
            });
            // if (!arrDataSets[iPosicaoArray].dados[0]) {
            //   msgErro('Nenhum dado disponível no dataset: ' + arrDataSets[iPosicaoArray].nome + ', impossível editar');
            //   bloqueiaEdicao();
            //   throw new Error('Nenhum dado disponível no dataset: ' + arrDataSets[iPosicaoArray].nome + ', impossível editar');
            // }
            colunasArrayAtual = Object.keys(arrDataSets[iPosicaoArray].dados[0]);
            arrayUnico = unique(arrayUnico.concat(colunasArrayAtual));
          } else {
            for (const indice in value) {
              if (value[indice] === '') {
                break;
              }
              const iPosicaoArray = arrDataSets.findIndex(obj => {
                return obj.id_banco == value[indice];
              });
              // if (!arrDataSets[iPosicaoArray].dados[0]) {
              //   msgErro('Nenhum dado disponível no dataset: ' + arrDataSets[iPosicaoArray].nome + ', impossível editar');
              //   bloqueiaEdicao();
              //   throw new Error('Nenhum dado disponível no dataset: ' + arrDataSets[iPosicaoArray].nome + ', impossível editar');
              // }
              colunasArrayAtual = Object.keys(arrDataSets[iPosicaoArray].dados[0]);
              arrayUnico = unique(arrayUnico.concat(colunasArrayAtual));
            }
          }
          $('#txtEixo').html('');
          $('#txtValor').html('');
          $('#txtCampoOrdenacao').html('');
          $('#txtCidade').html('');
          $('#txtEstado').html('');
          for (const colunas of arrayUnico) {
            var optionText = colunas;
            var optionValue = colunas;
            $('#txtEixo').append(`<option value="${optionValue}">
                                                 ${optionText}
                                  </option>`);
            $('#txtValor').append(`<option value="${optionValue}">
                                                  ${optionText}
                                   </option>`);
            $('#txtCampoOrdenacao').append(`<option value="${optionValue}">
                                                  ${optionText}
                                   </option>`);
            $('#txtCidade').append(`<option value="${optionValue}">
                                                    ${optionText}
                                   </option>`);
            $('#txtEstado').append(`<option value="${optionValue}">
                                                    ${optionText}
                                   </option>`);
          }
        });

        function allowDrop(ev) {
          ev.preventDefault();
        }

        var unique = function(a) {
          return a.reduce(function(p, c) {
            if (p.indexOf(c) < 0) p.push(c);
            return p;
          }, []);
        };

        function drop(ev) {
          ev.preventDefault();
          var data = ev.dataTransfer.getData("text");
          ev.target.value = data;
        }

        var queryString = window.location.href;
        var parametros = queryString.split('/');
        var id_dashboard = parametros[parametros.length - 1];
        $('#id-dash').html(id_dashboard);


        async function RetornaGruposDash() {
          try {
            $.LoadingOverlay('show');
            const pesquisa = {
              camposSelect: ["ID", "DESCRICAO"],
              tabela: 'GRUPO_DASH_WEB',
              where: []
            }
            const _url = `/sisplan/funcoes/v1/pesquisa?`;
            const response = await requisicao('GET', _url,
              `JSON=${JSON.stringify(pesquisa)}`, null);
            if (!response) {
              return;
            }
            const jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem)
              return;
            }

            $('#txtGrupoDash').append(`<option value=""></option>`);
            for (let i = 0; i < jsonStr['RESULT'][0].length; i++) {
              const id = jsonStr['RESULT'][0][i].ID;
              const descricao = jsonStr['RESULT'][0][i].DESCRICAO;

              $('#txtGrupoDash').append(`<option value="${id}">${descricao}</option>`);
            }

          } finally {
            $.LoadingOverlay('hide');
          }
        }

        async function RetornaDadosDashboard(id) {
          const _url = `/sisplan/funcoes/v1/pesquisa?`;
          const _params = ``;

          try {
            $.LoadingOverlay('show');
            try {
              var response = await requisicao('GET', _url,
                `JSON={ "tabela":"dash_web", "camposSelect":["nome", "minutos", "ordem", "id_grupo"], "where": ["id = '${id}'"] }`, null);
              if (!response) {
                return;
              }
              var jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return;
              }
              $('#txtNomeDash').val(jsonStr['RESULT'][0][0].NOME);
              $('#txtTempoDash').val(jsonStr['RESULT'][0][0].MINUTOS);
              $('#txtOrdemDash').val(jsonStr['RESULT'][0][0].ORDEM);
              $('#txtGrupoDash').val(jsonStr['RESULT'][0][0].ID_GRUPO);
            } catch (error) {
              console.error(error);
              msgErro('Não foi possível buscar os dados do dashboard.');
            }

            //consulta datasets
            try {
              var response = await requisicao('GET', _url,
                `JSON={ "tabela":"dataset_web", "camposSelect":["id","nome","sql", "cor"], "where": ["id_dash = '${id}'"] }&REPLACE_LINE_BREAK=true`,
                null);
              if (!response) {
                return;
              }
              var jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return;
              }
              //aqui tem que criar os datasets no html e arrGraficos...
              for (let i = 0; i < jsonStr['RESULT'][0].length; i++) {
                $('#id-dataset').html('Nova');
                const dataset = jsonStr['RESULT'][0][i];
                $('#txtNomeDataSet').val(dataset.NOME);
                $('#txtSelect').val(dataset.SQL.replaceAll('&#013;', '\r\n'));
                $('#inputDatasetColor').val(dataset.COR);
                await rotinaValidarSQL(false);
                $('#txtIdDataSet').val(dataset.ID);
                await rotinaConfirmarDataSet();
              }
            } catch (error) {
              console.error(error);
              msgErro(error);
            }

            //consulta gráficos
            try {
              var response = await requisicao('GET', _url,
                `JSON={ "tabela":"grafico_web", "camposSelect":["id", "nome", "tipo", "proporcao", "tipo_apresentacao", "eixo", "valor", "tipo_valor","tipo_ordenacao", "max_registros", "icone", "campo_ordenacao", "ordem", "cor", "texto_valor", "gradiente", "hint", "cidade", "estado", "tam_fonte", "tam_card"], "where": ["id_dash = '${id}'"], "orderby": ["ordem"] }`,
                null);
              if (!response) {
                return;
              }
              var jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return;
              }
              await carregaDataSetsSelect();
              //aqui tem que criar os gráficos no html e arrGraficos...
              for (let i = 0; i < jsonStr['RESULT'][0].length; i++) {
                totalGrafs++;
                const grafico = jsonStr['RESULT'][0][i];
                var classe = 'small';
                switch (grafico.PROPORCAO) {
                  case 1:
                    classe = 'small';
                    break;
                  case 2:
                    classe = 'large';
                    break;
                  case 3:
                    classe = 'extralarge';
                    break;
                  case 4:
                    classe = 'big';
                    break;
                  case 5:
                    classe = 'extrabig';
                    break;
                  case 6:
                    classe = 'masterbig';
                    break;
                  default:
                    classe = 'small';
                    break;
                }
                $('#panel').append(`
                  <div data-placement="bottom" id="graf-${totalGrafs}" class="brick ${classe}">
                    <a title="editar" class="edit" href="#"><i class="fas fa-edit"></i></a>
                    <a title="excluir" class="delete" href="#"><i class="fas fa-trash"></i></a>
                    <p id="graf-nome-${totalGrafs}" style="color: white!important;">Gráfico ${totalGrafs}</p>
                  </div>
                `);

                $('.gridly').gridly({
                  base: 60, // px 
                  gutter: 20, // px
                  columns: 12
                });

                $('#id-grafico').html(totalGrafs);
                $('#txtNomeGrafico').val(grafico.NOME);
                quill.clipboard.dangerouslyPasteHTML(grafico.TEXTO_VALOR ?? '#VALOR');
                $('#select_tipo').val(grafico.TIPO).trigger('change');
                $('#select_valores').val(grafico.TIPO_APRESENTACAO).trigger('change');

                // $('#select_dataset').val(await retornaDataSets(id, grafico.ID)).trigger('change');
                setSelect2ValuesInOrder('#select_dataset', await retornaDataSets(id, grafico.ID));
                if (grafico.TIPO == '6') {
                  $("#txtEixo").select2({
                    multiple: true,
                    allowClear: true,
                    sorter: function(data) {
                      return data; // Retorna os dados sem ordenar
                    }
                  });
                  $('#txtEixo').val(grafico.EIXO.replaceAll(' ', '').split(',')).trigger('change');
                } else {
                  $("#txtEixo").select2({
                    multiple: false,
                    allowClear: false,
                    sorter: function(data) {
                      return data; // Retorna os dados sem ordenar
                    }
                  });
                  $('#txtEixo').val(grafico.EIXO).trigger('change');
                }
                $('#txtValor').val(grafico.VALOR).trigger('change');
                $('#txtCampoOrdenacao').val(grafico.CAMPO_ORDENACAO).trigger('change');
                $('#txtTipoOrdenacao').val(grafico.TIPO_ORDENACAO).trigger('change');
                $('#txtMaxRegistros').val(grafico.MAX_REGISTROS);
                $('#txtTamanhoFonte').val(grafico.TAM_FONTE != '' ? grafico.TAM_FONTE : '15');
                $('#txtTamanhoCard').val(grafico.TAM_CARD != '' ? grafico.TAM_CARD : '350');
                $('#txtHintGrafico').val(grafico.HINT);
                $('#txtSelectIcone').val(grafico.ICONE).trigger('change');
                $('#txtTipoValor').val(grafico.TIPO_VALOR).trigger('change');
                $('#txtIdGrafico').val(grafico.ID);
                $('#txtProporcao').val(grafico.PROPORCAO);
                $('#txtOrdem').val(grafico.ORDEM);
                $('#txtCidade').val(grafico.CIDADE).trigger('change');
                $('#txtEstado').val(grafico.ESTADO).trigger('change');
                quill.clipboard.dangerouslyPasteHTML(grafico.TEXTO_VALOR ?? '#VALOR');
                if (grafico.COR !== '') {
                  if (grafico.COR === '#343a40') {
                    $("input[name='radioColorCard']").attr('checked', false);
                    $('#cardColorCinza').attr('checked', true);
                  } else if (grafico.COR === '#007bff') {
                    $("input[name='radioColorCard']").attr('checked', false);
                    $('#cardColorAzul').attr('checked', true);
                  } else if (grafico.COR === '#ffc107') {
                    $("input[name='radioColorCard']").attr('checked', false);
                    $('#cardColorAmarelo').attr('checked', true);
                  } else if (grafico.COR === '#28a745') {
                    $("input[name='radioColorCard']").attr('checked', false);
                    $('#cardColorVerde').attr('checked', true);
                  } else if (grafico.COR !== '') {
                    $("#inputColor").val(grafico.COR);
                    $("#cardColorCustom").val(grafico.COR);
                    $("input[name='radioColorCard']").attr('checked', false);
                    $('#cardColorCustom').attr('checked', true);
                  }
                } else if (grafico.GRADIENTE != '') {
                  const colorGradientIni = grafico.GRADIENTE.split(' ')[0];
                  const colorGradientFim = grafico.GRADIENTE.split(' ')[1];

                  $("#inputGradientIni").val(colorGradientIni);
                  $("#inputGradientFim").val(colorGradientFim);
                  $("#cardColorGradient").val(grafico.GRADIENTE);
                  $('#cardColorGradient').prop('checked', true);
                  // $("input[name='radioColorGradientCard']").attr('checked', false);
                  $("input[name='radioColorCard']").prop('checked', false);
                } else {
                  $("input[name='radioColorCard']").prop('checked', false);
                  $("input[name='cardColorGradient']").prop('checked', false);
                  $('#cardColorCinza').prop('checked', true);
                }
                await rotinaConfirmarGrafico();
              }
            } catch (error) {
              console.error(error);
              msgErro(error);
            }
          } finally {
            $.LoadingOverlay('hide');
          }
        }
        await RetornaGruposDash();
        await carregaFiltros(id_dashboard);
        RetornaDadosDashboard(id_dashboard);
        //ELITON REVER
        $('#select_tipo').on('change', function() {
          const tipoSelecionado = $(this).val();
          if (tipoSelecionado == '0') {
            $('#div_eixo').addClass('d-none');
            $('#div_tipo_ordenacao').addClass('d-none');
            $('#div_texto_valor').removeClass('d-none');
            $('#div_campo_ordenacao').addClass('d-none');
            $('#div_maximo_registros').addClass('d-none');
            $('#div_tamanho_fonte').addClass('d-none');
            $('#div_tamanho_card').removeClass('d-none');
            $('#CoresCards').removeClass('d-none');
            $('#divIconeCard').removeClass('d-none');
            $('#divTextoCard').removeClass('d-none');
            $('#div_apresentacao').removeClass('d-none');
            $('#div_cidade').addClass('d-none');
            $('#div_estado').addClass('d-none');
            $("#select_dataset").select2({
              multiple: false,
              allowClear: true,
              sorter: function(data) {
                return data; // Retorna os dados sem ordenar
              }
            });

            // let selectedOrder = [];
            // aaaaa
            // $('#select_dataset').on('select2:select', function(e) {
            //   const selectedValue = e.params.data.id;

            //   // Adicione o valor na lista de ordem, se ainda não estiver lá
            //   if (!selectedOrder.includes(selectedValue)) {
            //     selectedOrder.push(selectedValue);
            //   }

            //   // Atualize o valor do select2 mantendo a ordem de `selectedOrder`
            //   $(this).val(selectedOrder).trigger('change');
            // });

            // $('#select_dataset').on('select2:unselect', function(e) {
            //   const unselectedValue = e.params.data.id;

            //   // Remova o valor da lista de ordem
            //   selectedOrder = selectedOrder.filter(value => value !== unselectedValue);

            //   // Atualize o valor do select2 mantendo a ordem de `selectedOrder`
            //   $(this).val(selectedOrder).trigger('change');
            // });


            $("#txtEixo").select2({
              multiple: false,
              allowClear: false,
              sorter: function(data) {
                return data; // Retorna os dados sem ordenar
              }
            });
          } else if (['1', '2', '3'].includes(tipoSelecionado)) {
            $('#div_eixo').removeClass('d-none');
            $('#div_tipo_ordenacao').removeClass('d-none');
            $('#div_texto_valor').addClass('d-none');
            $('#div_campo_ordenacao').removeClass('d-none');
            $('#div_maximo_registros').removeClass('d-none');
            $('#div_tamanho_fonte').addClass('d-none');
            $('#div_tamanho_card').removeClass('d-none');
            $('#CoresCards').addClass('d-none');
            $('#divIconeCard').addClass('d-none');
            $('#divTextoCard').addClass('d-none');
            $('#div_apresentacao').removeClass('d-none');
            $('#div_cidade').addClass('d-none');
            $('#div_estado').addClass('d-none');
            $("#select_dataset").select2({
              multiple: true,
              allowClear: true,
              sorter: function(data) {
                return data; // Retorna os dados sem ordenar
              }
            });
            $("#txtEixo").select2({
              multiple: false,
              allowClear: false,
              sorter: function(data) {
                return data; // Retorna os dados sem ordenar
              }
            });
          } else if (tipoSelecionado == '6') {
            $('#div_eixo').removeClass('d-none');
            $('#div_tipo_ordenacao').removeClass('d-none');
            $('#div_texto_valor').addClass('d-none');
            $('#div_campo_ordenacao').removeClass('d-none');
            $('#div_maximo_registros').removeClass('d-none');
            $('#div_tamanho_fonte').removeClass('d-none');
            $('#div_tamanho_card').removeClass('d-none');
            $('#CoresCards').addClass('d-none');
            $('#divIconeCard').addClass('d-none');
            $('#divTextoCard').addClass('d-none');
            $('#div_apresentacao').removeClass('d-none');
            $('#div_cidade').addClass('d-none');
            $('#div_estado').addClass('d-none');
            $("#select_dataset").select2({
              multiple: true,
              allowClear: true
            });
            $("#txtEixo").select2({
              multiple: true,
              allowClear: true,
              sorter: function(data) {
                return data; // Retorna os dados sem ordenar
              }
            });
          } else if (tipoSelecionado == '7') {
            // mapa
            $('#div_eixo').addClass('d-none');
            $('#div_tipo_valor').addClass('d-none');
            $('#div_texto_valor').addClass('d-none');
            $('#div_tipo_ordenacao').addClass('d-none');
            $('#div_campo_ordenacao').addClass('d-none');
            $('#div_maximo_registros').addClass('d-none');
            $('#div_tamanho_fonte').addClass('d-none');
            $('#div_tamanho_card').removeClass('d-none');
            $('#CoresCards').addClass('d-none');
            $('#divIconeCard').addClass('d-none');
            $('#divTextoCard').addClass('d-none');
            $('#div_apresentacao').addClass('d-none');
            $('#div_cidade').removeClass('d-none');
            $('#div_estado').removeClass('d-none');

          } else {
            $('#div_tamanho_fonte').addClass('d-none');
            $('#div_tamanho_card').removeClass('d-none');
            $('#div_eixo').removeClass('d-none');
            $('#div_tipo_ordenacao').removeClass('d-none');
            $('#div_texto_valor').addClass('d-none');
            $('#div_campo_ordenacao').removeClass('d-none');
            $('#div_maximo_registros').removeClass('d-none');
            $('#CoresCards').addClass('d-none');
            $('#divIconeCard').addClass('d-none');
            $('#divTextoCard').addClass('d-none');
            $('#div_apresentacao').removeClass('d-none');
            $('#div_cidade').addClass('d-none');
            $('#div_estado').addClass('d-none');
            $("#select_dataset").select2({
              multiple: true,
              allowClear: true,
              sorter: function(data) {
                return data; // Retorna os dados sem ordenar
              }
            });
            $("#txtEixo").select2({
              multiple: false,
              allowClear: false,
              sorter: function(data) {
                return data; // Retorna os dados sem ordenar
              }
            });
          }

        });

        async function retornaDataSets(id_dash, id_grafico) {
          try {
            const _url = `/sisplan/funcoes/v1/pesquisa?`;
            const _params = ``;
            var response = await requisicao('GET', _url,
              `JSON={ "tabela":"GRAFICO_DATASET", "camposSelect":["id_dataset"], "where": ["id_dash = ${id_dash} and id_grafico = ${id_grafico}"] }`,
              null);
            if (!response) {
              return;
            }
            var jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem)
              return;
            }
            //aqui tem que criar os gráficos no html e arrGraficos...
            const arrResultado = jsonStr['RESULT'][0][0]['ID_DATASET'].split(', ');
            return arrResultado;
          } catch (error) {
            console.error(error);
          }
        }

        function preencheGrafico() {
          let id_graf = $('#id-grafico').html().trim();
          const grafico = new Object();
          grafico.id = id_graf;
          grafico.id_banco = $('#txtIdGrafico').val();
          grafico.proporcao = $('#txtProporcao').val();
          grafico.ordem = $('#txtOrdem').val();
          grafico.nome = $('#txtNomeGrafico').val();
          grafico.tipo_grafico = $('#select_tipo').val();
          grafico.tipo_valores = $('#select_valores').val();
          grafico.dataset = $('#select_dataset').val();
          grafico.eixo = $('#txtEixo').val();
          grafico.valor = $('#txtValor').val();
          grafico.tipo_valor = $('#txtTipoValor').val();
          grafico.campo_ordenacao = $('#txtCampoOrdenacao').val();
          grafico.tipo_ordenacao = $('#txtTipoOrdenacao').val();
          grafico.max_registros = $('#txtMaxRegistros').val();
          grafico.tam_fonte = $('#txtTamanhoFonte').val();
          grafico.tam_card = $('#txtTamanhoCard').val();
          grafico.texto_valor = quill.root.innerHTML;
          grafico.cor = $('input[name="radioColorCard"]:checked').val() ?? '';
          grafico.gradiente = $('#cardColorGradient').val();
          grafico.hint = $('#txtHintGrafico').val();
          grafico.icone = $('#txtSelectIcone').val();
          grafico.cidade = $('#txtCidade').val();
          grafico.estado = $('#txtEstado').val();
          return grafico;
        }

        function preencheDataSet() {
          let id_dataset = -1;
          if ($('#id-dataset').html().trim() == 'Nova') {
            id_dataset = totalDataSets;
          } else {
            id_dataset = $('#id-dataset').html().trim();
          }
          const dataset = new Object();
          dataset.id = id_dataset;
          dataset.nome = $('#txtNomeDataSet').val();
          dataset.cor = $('#inputDatasetColor').val();
          dataset.sql = $('#txtSelect').val().replace(/\n/g, ' ');
          dataset.dados = $('#tabela-resultados').DataTable().data().toArray();
          dataset.id_banco = $('#txtIdDataSet').val();
          return dataset;
        }

        async function limpaGrafico() {
          $('#id-grafico').html('');
          $('#txtNomeGrafico').val('');
          quill.setText('#VALOR');
          $('#select_tipo').val(0).trigger('change');
          $('#select_valores').val(0).trigger('change');
          $('#txtEixo').val('');
          $('#txtEixo').html('');
          $('#txtValor').val('');
          $('#txtValor').html('');
          $('#txtCampoOrdenacao').val('');
          $('#txtCampoOrdenacao').html('');
          $('#txtTipoValor').val(0).trigger('change'); //padrao soma
          $('#txtTipoOrdenacao').val(-1); //padrao soma
          $('#txtMaxRegistros').val(0);
          $('#txtTamanhoFonte').val('');
          $('#txtTamanhoCard').val('');
          $('#txtHintGrafico').val('');
          $('#select_dataset').val('');
          $('#txtIdGrafico').val('');
          $('#txtProporcao').val('1');
          $('#txtOrdem').val('');
          // $('#cardColorCinza').props('checked');
        }

        async function limpaDataSet() {
          $('#id-dataset').html('');
          $('#txtNomeDataSet').val('');
          $('#inputDatasetColor').val('');
          $('#txtIdDataSet').val('');
          $('#txtSelect').val('');
          $('#resultados').html('');
        }

        async function adicionaGrafico() {
          var grafico = preencheGrafico();
          arrGraficos.push(grafico);
        }

        async function editaGrafico(iPosicaoArray) {
          var grafico = preencheGrafico();
          arrGraficos[iPosicaoArray] = grafico;
        }

        async function adicionaDataSet() {
          var dataset = preencheDataSet();
          arrDataSets.push(dataset);
        }

        async function editaDataSet(iPosicaoArray) {
          var dataset = preencheDataSet();
          arrDataSets[iPosicaoArray] = dataset;
        }

        async function carregaGrafico(iPosicaoArray) {
          $('#id-grafico').html(arrGraficos[iPosicaoArray].id);
          $('#txtIdGrafico').val(arrGraficos[iPosicaoArray].id_banco);
          $('#txtProporcao').val(arrGraficos[iPosicaoArray].proporcao);
          $('#txtOrdem').val(arrGraficos[iPosicaoArray].ordem);
          $('#txtNomeGrafico').val(arrGraficos[iPosicaoArray].nome);
          quill.clipboard.dangerouslyPasteHTML(arrGraficos[iPosicaoArray].texto_valor);


          $('#select_tipo').val(arrGraficos[iPosicaoArray].tipo_grafico).trigger('change');
          $('#select_valores').val(arrGraficos[iPosicaoArray].tipo_valores).trigger('change');
          //aqui pode ser que é mais de um dataset verificar depois Eliton \/
          // $('#select_dataset').val(arrGraficos[iPosicaoArray].dataset).trigger('change');
          if (typeof(arrGraficos[iPosicaoArray].dataset) == 'object') {
            setSelect2ValuesInOrder('#select_dataset', arrGraficos[iPosicaoArray].dataset);
          } else {
            $('#select_dataset').val(arrGraficos[iPosicaoArray].dataset).trigger('change');
          }
          $('#txtEixo').val(arrGraficos[iPosicaoArray].eixo).trigger('change');
          $('#txtValor').val(arrGraficos[iPosicaoArray].valor).trigger('change');
          $('#txtTipoValor').val(arrGraficos[iPosicaoArray].tipo_valor).trigger('change');
          $('#txtCampoOrdenacao').val(arrGraficos[iPosicaoArray].campo_ordenacao).trigger('change');
          $('#txtTipoOrdenacao').val(arrGraficos[iPosicaoArray].tipo_ordenacao).trigger('change');
          $('#txtMaxRegistros').val(arrGraficos[iPosicaoArray].max_registros);
          $('#txtTamanhoFonte').val(arrGraficos[iPosicaoArray].tam_fonte != '' ? arrGraficos[iPosicaoArray].tam_fonte : '15');
          $('#txtTamanhoCard').val(arrGraficos[iPosicaoArray].tam_card != '' ? arrGraficos[iPosicaoArray].tam_card : '350');
          $('#txtHintGrafico').val(arrGraficos[iPosicaoArray].hint);
          $('#txtSelectIcone').val(arrGraficos[iPosicaoArray].icone).trigger('change');
          $('#txtCidade').val(arrGraficos[iPosicaoArray].cidade).trigger('change');
          $('#txtEstado').val(arrGraficos[iPosicaoArray].estado).trigger('change');

          if (arrGraficos[iPosicaoArray].cor !== '') {
            if (arrGraficos[iPosicaoArray].cor === '#343a40') {
              $("input[name='radioColorCard']").prop('checked', false);
              $('#cardColorCinza').prop('checked', true);
              $("#inputColor").val('#343a40');
            } else if (arrGraficos[iPosicaoArray].cor === '#007bff') {
              $("input[name='radioColorCard']").prop('checked', false);
              $('#cardColorAzul').prop('checked', true);
              $("#inputColor").val('#343a40');
            } else if (arrGraficos[iPosicaoArray].cor === '#ffc107') {
              $("input[name='radioColorCard']").prop('checked', false);
              $('#cardColorAmarelo').prop('checked', true);
              $("#inputColor").val('#343a40');
            } else if (arrGraficos[iPosicaoArray].cor === '#28a745') {
              $("input[name='radioColorCard']").prop('checked', false);
              $('#cardColorVerde').prop('checked', true);
              $("#inputColor").val('#343a40');
            } else if (arrGraficos[iPosicaoArray].cor !== '') {
              $("#inputColor").val(arrGraficos[iPosicaoArray].cor);
              $("#cardColorCustom").val(arrGraficos[iPosicaoArray].cor);
              $("input[name='radioColorCard']").prop('checked', false);
              $('#cardColorCustom').prop('checked', true);
            }
            $("#inputGradientIni").val('#343a40');
            $("#inputGradientFim").val('#343a40');
            $("input[name='cardColorGradient']").prop('checked', false);
          } else if (arrGraficos[iPosicaoArray].gradiente != '') {
            const colorGradientIni = arrGraficos[iPosicaoArray].gradiente.split(' ')[0];
            const colorGradientFim = arrGraficos[iPosicaoArray].gradiente.split(' ')[1];

            $("#inputGradientIni").val(colorGradientIni);
            $("#inputGradientFim").val(colorGradientFim);
            $("#cardColorGradient").val(arrGraficos[iPosicaoArray].gradiente);
            $('#cardColorGradient').prop('checked', true);
            // $("input[name='radioColorGradientCard']").attr('checked', false);
            $("input[name='radioColorCard']").prop('checked', false);
          } else {
            $("input[name='radioColorCard']").prop('checked', false);
            $("input[name='cardColorGradient']").prop('checked', false);
            $('#cardColorCinza').prop('checked', true);
            $("#inputColor").val('#343a40');
            $("#inputGradientIni").val('#343a40');
            $("#inputGradientFim").val('#343a40');
          }
          $('#txtMaxRegistros').val(arrGraficos[iPosicaoArray].max_registros);
        }

        async function carregaDataSet(iPosicaoArray) {
          var dataSet = [];
          var dataSetCols = [];
          $('#id-dataset').html(arrDataSets[iPosicaoArray].id);
          $('#txtIdDataSet').val(arrDataSets[iPosicaoArray].id_banco);
          $('#txtNomeDataSet').val(arrDataSets[iPosicaoArray].nome);
          $('#inputDatasetColor').val(arrDataSets[iPosicaoArray].cor);
          $('#txtSelect').val(arrDataSets[iPosicaoArray].sql);

          // if (!$.isEmptyObject(arrDataSets[iPosicaoArray].dados)) {
          //   dataSet = arrDataSets[iPosicaoArray].dados;
          //   var keys = Object.keys(dataSet[0]);
          //   for (var k in keys) {
          //     dataSetCols.push({
          //       'title': keys[k],
          //       'data': keys[k]
          //     });
          //   }

          //   $(`#resultados`).html(`<table id="tabela-resultados" class="table table-sm table-select table-hover display"></table>`);

          //   // $(`#tabela-resultados`).DataTable({
          //   //   paging: true,
          //   //   filter: false,
          //   //   info: false,
          //   //   order: false,
          //   //   destroy: true,
          //   //   autowidth: true,
          //   //   "language": {
          //   //     "sEmptyTable": "Nenhum registro encontrado",
          //   //     "sInfo": "_TOTAL_ registros",
          //   //     "sInfoEmpty": " 0 registros",
          //   //     "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          //   //     "sInfoPostFix": "",
          //   //     "sInfoThousands": ".",
          //   //     "sLengthMenu": "_MENU_ resultados",
          //   //     "sLoadingRecords": "Carregando...",
          //   //     "sProcessing": "Processando...",
          //   //     "sZeroRecords": "Nenhum registro encontrado",
          //   //     "sSearch": "Pesquisar",
          //   //     "oPaginate": {
          //   //       "sNext": "Próximo",
          //   //       "sPrevious": "Anterior",
          //   //       "sFirst": "Primeiro",
          //   //       "sLast": "Último"
          //   //     },
          //   //     "oAria": {
          //   //       "sSortAscending": ": Ordenar colunas de forma ascendente",
          //   //       "sSortDescending": ": Ordenar colunas de forma descendente"
          //   //     }
          //   //   },
          //   //   "columns": dataSetCols,
          //   //   "data": dataSet
          //   // });

          //   // for (let i = 0; i < $(`#tabela-resultados th`).length; i++) {
          //   //   const coluna = $($(`#tabela-resultados th`)[i]);
          //   //   coluna.prop('draggable', true);
          //   //   coluna.on('dragstart', function(event) {
          //   //     event.originalEvent.dataTransfer.setData("text", event.target.innerHTML);
          //   //   });
          //   // }
          // }
        }

        $('#btn-dataset').on('click', function() {
          limpaDataSet();
          $('#id-dataset').html('Nova');
          $('#modal-dataset').modal({
            backdrop: 'static',
            keyboard: false
          });
        });

        $('#btn-filtros').on('click', function() {
          $('#modal-filtros').modal({
            backdrop: 'static',
            keyboard: false
          });
        });

        $('#btn-novo').on('click', function() {
          if ($('.quadrado').length == 0) {
            msgAlerta('Nenhum dataset disponível, impossível criar gráfico.');
            return;
          }

          if (arrDataSets.filter(dataset => dataset.id_banco === '').length != 0) {
            msgAlerta('Datasets não gravados, necessário salvar o dashboard antes de criar novos gráficos.');
            return;
          }

          totalGrafs++;
          $('#panel').append(`
            <div data-placement="bottom" id="graf-${totalGrafs}" class="brick small">
              <a title="editar" class="edit" href="#"><i class="fas fa-edit"></i></a>
              <a title="excluir" class="delete" href="#"><i class="fas fa-trash"></i></a>
              <p id="graf-nome-${totalGrafs}" style="color: white!important;">Gráfico ${totalGrafs}</p>
            </div>
          `);

          $('.gridly').gridly({
            base: 60, // px 
            gutter: 20, // px
            columns: 12
          });

          $(`#graf-${totalGrafs} a:first-child`).trigger('click');

        });

        $('#btn-testar').on('click', function() {
          parent.abrirEmNovaAbaIFrame('Teste Dashboard', `<?php echo BASE_URI; ?>/dash_teste/${id_dashboard}`);
          // window.open(`${BASE_URI}/dash_teste/${id_dashboard}`, "_blank");
        });

        $('#btn-salvar').on('click', async function() {
          try {
            try {
              $.LoadingOverlay('show');
              if (arrDataSets.length === 0) {
                msgErro('Necessário criar algum dataset de dados para salvar');
                return;
              }

              if (parseFloat($('#txtTempoDash').val()) < 0) {
                msgErro('Tempo de Atualização inválido.');
                return;
              }

              var graficos = [];
              var datasets = [];
              var dashboard = new Object();
              dashboard.id = id_dashboard;
              dashboard.nome = $('#txtNomeDash').val();
              dashboard.minutos = $('#txtTempoDash').val();
              dashboard.ordem = $('#txtOrdemDash').val();
              dashboard.id_grupo = $('#txtGrupoDash').val();

              for (let i = 0; i < arrDataSets.length; i++) {
                const datasetObj = arrDataSets[i];
                const dataset = new Object();
                dataset.id = datasetObj.id_banco;
                dataset.nome = datasetObj.nome;
                dataset.sql = datasetObj.sql;
                dataset.cor = datasetObj.cor != '#000000' ? datasetObj.cor : '';
                dataset.id_dash = id_dashboard;
                datasets.push(dataset);
              }

              for (let y = 0; y < arrGraficos.length; y++) {
                const graficoObj = arrGraficos[y];
                const grafico = new Object();
                grafico.id = graficoObj.id_banco;
                grafico.nome = graficoObj.nome;
                grafico.id_dash = id_dashboard;
                grafico.tipo = graficoObj.tipo_grafico;
                grafico.tipo_apresentacao = graficoObj.tipo_valores;
                if (graficoObj.tipo_grafico == '6') {
                  grafico.eixo_list = graficoObj.eixo;
                } else {
                  grafico.eixo = graficoObj.eixo;
                }
                grafico.valor = graficoObj.valor;
                grafico.tipo_valor = graficoObj.tipo_valor;
                grafico.ordem = graficoObj.ordem;
                grafico.proporcao = graficoObj.proporcao;
                grafico.datasets = [];
                grafico.tipo_ordenacao = graficoObj.tipo_ordenacao;
                grafico.campo_ordenacao = graficoObj.campo_ordenacao;
                grafico.max_registros = graficoObj.max_registros;
                grafico.tam_card = graficoObj.tam_card;
                grafico.tam_fonte = graficoObj.tam_fonte;
                grafico.cor = graficoObj.cor;
                grafico.texto_valor = graficoObj.texto_valor;
                grafico.gradiente = graficoObj.gradiente;
                grafico.hint = graficoObj.hint;
                grafico.icone = graficoObj.icone;
                grafico.cidade = graficoObj.cidade;
                grafico.estado = graficoObj.estado;
                graficos.push(grafico);
              }
              dashboard.graficos = graficos;
              dashboard.datasets = datasets;

              const _url = '/sisplan/dashboard/v1/dashboard?';
              var response = await requisicao('POST', _url, '', `JSON=${JSON.stringify(dashboard)}`, null);

              if (!response) {
                return;
              }

              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem);
                return;
              }

              var jsonStr = await response.json();
              const datasetsResponse = jsonStr.dataSets ?? [];
              const graficosResponse = jsonStr.graficos ?? [];

              for (let i = 0; i < datasetsResponse.length; i++) {
                const element = datasetsResponse[i];
                const iPosicaoArray = arrDataSets.findIndex(obj => {
                  return obj.nome == element.nome
                });
                arrDataSets[iPosicaoArray].id_banco = element.iD;
              }

              for (let i = 0; i < graficosResponse.length; i++) {
                const element = graficosResponse[i];
                const iPosicaoArray = arrGraficos.findIndex(obj => {
                  return obj.nome == element.nOME
                });
                arrGraficos[iPosicaoArray].id_banco = element.iD;
              }

              const arrLigacao = [];
              for (let i = 0; i < arrGraficos.length; i++) {
                const datasetArray = typeof(arrGraficos[i].dataset) === 'string' ? [arrGraficos[i].dataset] : arrGraficos[i].dataset;
                for (let z = 0; z < datasetArray.length; z++) {
                  const datasetUsado = datasetArray[z]; //posicao iniciando em 1
                  const graf = new Object();
                  graf.id_dash = id_dashboard;
                  graf.id_grafico = arrGraficos[i].id_banco;
                  graf.id_dataset = datasetUsado;

                  const iPosicaoLigacao = arrLigacao.findIndex(obj => {
                    return obj.id_dash == graf.id_dash && obj.id_grafico == graf.id_grafico
                  });
                  if (iPosicaoLigacao == -1) {
                    arrLigacao.push(graf);
                  } else {
                    arrLigacao[iPosicaoLigacao].id_dataset = arrLigacao[iPosicaoLigacao].id_dataset + ', ' +
                      graf.id_dataset;
                  }
                }
              }

              const objetoLigacao = new Object();
              objetoLigacao.graficos = arrLigacao;
              await gravaLigacaoDataSetGrafico(objetoLigacao);
              await gravaFiltrosDashboard(id_dashboard);
            } catch (error) {
              console.error(error);
              msgErro('Erro ao salvar Dashboard.');
            }
          } finally {
            $.LoadingOverlay('hide');
          }
        });

        async function gravaLigacaoDataSetGrafico(objeto) {
          try {
            const _url = '/sisplan/dashboard/v1/grafico_dataset?';
            var response = await requisicao('POST', _url, `JSON=${encodeURIComponent(JSON.stringify(objeto))}`,
              null);

            if (!response) {
              return;
            }

            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem);
              return;
            }
          } catch (error) {
            console.error(error);
          }
        }

        async function gravaFiltrosDashboard(IdDash) {
          try {
            const listaFiltros = {
              lista: $('#tabela-filtros').DataTable().data().toArray().map((filtro) => {
                return {
                  ID_DASH: IdDash,
                  NOME: filtro.NOME,
                  TIPO: filtro.TIPO,
                  TABELA: filtro.TABELA,
                  CAMPO: filtro.CAMPO,
                  VALOR_PADRAO: filtro.VALOR_PADRAO,
                  VALOR_TESTE: filtro.VALOR_TESTE,
                  OBRIGATORIO: filtro.OBRIGATORIO,
                  CAMPO_DESC: filtro.CAMPO_DESC,
                  VARIOS: filtro.VARIOS,
                  LABEL: filtro.LABEL,
                  UTILIZA_EMP_ID: filtro.UTILIZA_EMP_ID,
                  OPCAO_DATA: filtro.OPCAO_DATA
                }
              })
            }

            const _url = '/sisplan/dashboard/v1/dash_filtro_web?';
            var response = await requisicao('POST', _url, `ID_DASH=${IdDash}&JSON=${encodeURIComponent(JSON.stringify(listaFiltros))}`,
              null);

            if (!response) {
              return;
            }

            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem);
              return;
            }
          } catch (error) {
            console.error(error);
          }
        }

        async function deletaGrafico(objeto) {
          try {
            const _url = '/sisplan/dashboard/v1/grafico?';
            var response = await requisicao('DELETE', _url, `JSON=${JSON.stringify(objeto)}`,
              null);

            if (!response) {
              return false;
            }

            if (response.status != 200) {
              msgErro('Erro ao deletar grafico');
              return false;
            }
            return true;
          } catch (error) {
            console.error(error);
            return false;
          }
        }

        async function deletaDataSet(objeto) {
          try {
            const _url = '/sisplan/dashboard/v1/dataset_web?';
            var response = await requisicao('DELETE', _url, `JSON=${JSON.stringify(objeto)}`, null);

            if (!response) {
              return false;
            }

            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem);
              return false;
            }
            return true;
          } catch (error) {
            console.error(error);
            return false;
          }
        }

        async function carregaDataSetsSelect() {
          $('#select_dataset').html(``);

          for (const dataset of arrDataSets) {
            var optionText = dataset.nome;
            var optionValue = dataset.id_banco;
            $('#select_dataset').append(`<option value="${optionValue}">
                                                        ${optionText}
                                         </option>`);

          }

          // $('#select_dataset').unbind('change');

        }

        $('#btn-identar').on('click', function() {
          $(`#txtSelect`).val(window.sqlFormatter.format($(`#txtSelect`).val()));
        });


        $('#btn-validar').on('click', async function() {
          await rotinaValidarSQL();
        });


        function formataDataComPonto(dt) {
          if (dt) {
            const [ano, mes, dia] = dt.split('-');
            return `${dia}.${mes}.${ano}`;
          } 
          return '';
        }

        function retornaData(opcao) {
          const dataAtual = new Date();

          switch (String(opcao)) {
            case '': 
              return '';
              break;
            case '1':
              // Data atual
              return dataAtual.toISOString().slice(0, 10);
              break;
            case '2':
              // Primeiro dia do mês corrente
              return new Date(dataAtual.getFullYear(), dataAtual.getMonth(), 1).toISOString().slice(0, 10);
              break;
            case '3':
              // Último dia do mês corrente
              return new Date(dataAtual.getFullYear(), dataAtual.getMonth() + 1, 0).toISOString().slice(0, 10);
              break;
            case '4':
              // Primeiro dia do ano corrente
              return new Date(dataAtual.getFullYear(), 0, 1).toISOString().slice(0, 10);
              break;
            case '5':
              // Último dia do ano corrente
              return new Date(dataAtual.getFullYear(), 11, 31).toISOString().slice(0, 10);
              break;
            default: 
              return '';
              break;
          }
        }

        async function rotinaValidarSQL(bMensagem = true) {

          if ($(`#txtSelect`).val().indexOf(';') != -1) {
            msgAlerta('Não é possível rodar SQLs com ";", verifique. ');
            return;
          }

          if ($(`#txtSelect`).val() == '') {
            msgAlerta('Nenhum select informado.');
            return;
          }

          const _url = `/sisplan/funcoes/v1/EditorSQL?`;
          try {
            try {
              $.LoadingOverlay("show");

              let dataSet = [];
              let dataSetCols = [];
              const filtros = $('#tabela-filtros').DataTable().data().toArray();

              let SQL = $(`#txtSelect`).val().replaceAll(':EMP_ID', getCookie('emp_id'))
                .replaceAll(':EMP_PAT', getCookie('empresa'))
                .replaceAll(':COD_USUARIO', getCookie('cod_usuario'));

              let SQLReplaced = SQL;
              if (filtros.length > 0) {
                for (let i = 0; i < filtros.length; i++) {
                  if (filtros[i].TIPO == 1) {
                    SQLReplaced = SQLReplaced.replaceAll(`:${filtros[i].NOME}`, `${formataDataComPonto(retornaData(filtros[i].OPCAO_DATA))}`);
                  } else
                  if (filtros[i].VALOR_TESTE != '') {
                    SQLReplaced = SQLReplaced.replaceAll(`:${filtros[i].NOME}`, `${filtros[i].VALOR_TESTE}`);
                  }
                }
              }
              var response = await requisicao('POST', _url, '', `JSON=${encodeURIComponent(SQLReplaced)}`, null);


              if (!response) {
                return;
              }

              const jsonStr = await response.json();
              if (response.status === 400) {
                msgErro(jsonStr.mensagem)
                return;
              }

              if (!$.isEmptyObject(jsonStr)) {
                dataSet = jsonStr;
                const keys = Object.keys(dataSet[0]);
                for (var k in keys) {
                  dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                  });
                }

                $(`#resultados`).html(
                  `<table id="tabela-resultados" class="table table-sm table-select table-hover display"></table>`
                );

                $(`#tabela-resultados`).DataTable({
                  paging: true,
                  filter: false,
                  info: false,
                  order: false,
                  destroy: true,
                  autowidth: true,
                  "columns": dataSetCols,
                  "data": dataSet
                });

              }
              if (bMensagem) {
                msgSucesso('Consulta efetuada com sucesso.');
              }

            } catch (error) {
              console.error(error);
              msgErro('Erro ao validar sql.');
            }
          } finally {
            $.LoadingOverlay("hide");
          }
        }

        $('.brick').unbind('click');
        $('.brick').on('click', function() {
          $(this).toggle();
        });
        // Generated by CoffeeScript 2.5.1
        (function() {
          $(function() {
            var brick;
            brick = "<div class='brick small'><div class='delete'>&times;</div></div>";
            $(document).on("click touchend", ".gridly .brick", function(event) {
              var $this, size;
              let proporcao = 0;

              event.preventDefault();
              event.stopPropagation();
              $this = $(this);
              if ($this.hasClass('small')) { // HACK
                $this.toggleClass('small');
                $this.toggleClass('large');
              } else
              if ($this.hasClass('large')) { // HACK
                $this.toggleClass('large');
                $this.toggleClass('extralarge');
              } else
              if ($this.hasClass('extralarge')) { // HACK{
                $this.toggleClass('extralarge');
                $this.toggleClass('big');
              } else
              if ($this.hasClass('big')) { // HACK{
                $this.toggleClass('big');
                $this.toggleClass('extrabig');
              } else
              if ($this.hasClass('extrabig')) { // HACK{
                $this.toggleClass('extrabig');
                $this.toggleClass('masterbig');
              } else
              if ($this.hasClass('masterbig')) { // HACK{
                $this.toggleClass('masterbig');
                $this.toggleClass('small');
              }

              if ($this.hasClass('small')) {
                size = 140;
                proporcao = 1;
              } else
              if ($this.hasClass('large')) {
                size = 300;
                proporcao = 2;
              } else
              if ($this.hasClass('extralarge')) {
                size = 460;
                proporcao = 3;
              } else
              if ($this.hasClass('big')) {
                size = 620;
                proporcao = 4;
              } else
              if ($this.hasClass('extrabig')) {
                size = 780;
                proporcao = 5;
              } else
              if ($this.hasClass('masterbig')) {
                size = 940;
                proporcao = 6;
              }

              $this.data('width', size);
              $this.data('height', 200);
              const id = ($this.prop('id').split('-')[1]);
              const iPosicaoArray = arrGraficos.findIndex(obj => {
                return obj.id == id
              });
              arrGraficos[iPosicaoArray].proporcao = proporcao;
              return $('.gridly').gridly('layout');
            });


            $(document).on("click", ".gridly .delete", async function(event) {
              var r = confirm("Tem certeza que deseja excluir o gráfico?");
              if (r == true) {
                var $this;
                event.preventDefault();
                event.stopPropagation();
                $this = $(this);
                let id_graf = $this.closest('div').attr('id').split('-')[1];
                let iPosicaoArray = arrGraficos.findIndex(obj => {
                  return obj.id == id_graf
                });

                if (iPosicaoArray == -1) {
                  $this.closest('.brick').remove();
                  return $('.gridly').gridly('layout');
                }

                const grafico = {
                  id: arrGraficos[iPosicaoArray].id_banco,
                  id_dash: id_dashboard
                }
                const deletouBanco = await deletaGrafico(grafico);
                if (deletouBanco) {
                  arrGraficos.splice(iPosicaoArray, 1);
                  $this.closest('.brick').remove();
                }
                return $('.gridly').gridly('layout');
              } else {
                var $this;
                event.preventDefault();
                event.stopPropagation();
                $this = $(this);
                return $('.gridly').gridly('layout');
              }
            });

            $(document).on("click", ".quadrado .delete", async function(event) {
              var r = confirm("Tem certeza que deseja excluir o dataset?");
              if (r == true) {
                var $this;
                event.preventDefault();
                event.stopPropagation();
                $this = $(this);
                let id_dataset = $this.closest('.quadrado').attr('data-id');
                let iPosicaoArray = arrDataSets.findIndex(obj => {
                  return obj.id == id_dataset
                });
                const id_banco = String(arrDataSets[iPosicaoArray].id_banco);
                //valida se já não está sendo usado em algum gráfico...
                // var iPosicaoGraficos = arrGraficos.findIndex(obj => {
                //   return obj.dataset.indexOf(id_dataset) != -1
                // });
                listaGraficosQueUsam = arrGraficos.filter(graf => {
                  if (typeof graf.dataset == 'object') {
                    return graf.dataset.includes(id_banco)
                  } else {
                    return graf.dataset == id_banco
                  }
                });

                if (listaGraficosQueUsam.length > 0) {
                  const listaNomesGraficos = listaGraficosQueUsam.map(graf => graf.nome);
                  msgAlerta(
                    `DataSet está sendo utilizado no(s) gráfico(s): ${listaNomesGraficos.toString()}, impossível excluir.`
                  );
                  return;
                }

                const objetoDataSet = {
                  id: arrDataSets[iPosicaoArray].id_banco,
                  id_dash: id_dashboard
                }

                const deletadoBanco = await deletaDataSet(objetoDataSet);
                if (deletadoBanco) {
                  arrDataSets.splice(iPosicaoArray, 1);
                  $(`.quadrado[data-id="${id_dataset}"]`).remove();
                }
              } else {
                var $this;
                event.preventDefault();
                event.stopPropagation();
                $this = $(this);
              }
            });

            $(document).on("click", ".gridly .edit", async function(event) {
              var $this;
              event.preventDefault();
              event.stopPropagation();
              $this = $(this);
              let id_graf = $this.closest('div').attr('id').split('-')[1];
              let iPosicaoArray = arrGraficos.findIndex(obj => {
                return obj.id == id_graf
              });

              await carregaDataSetsSelect();
              if (iPosicaoArray != -1) {
                await carregaGrafico(iPosicaoArray);
              } else {
                await limpaGrafico();
              }
              $('#id-grafico').html(id_graf);
              $('#modal-edit').modal({
                backdrop: 'static',
                keyboard: false
              });
            });


            $(document).on("click", ".add", function(event) {
              event.preventDefault();
              event.stopPropagation();
              $('.gridly').append(brick);
              return $('.gridly').gridly();
            });
            return $('.gridly').gridly();
          });

        }).call(this);

        $('#btn-confirmar-edit').on('click', async function() {
          await rotinaConfirmarGrafico();
        });

        async function rotinaConfirmarGrafico() {
          if ($('#txtNomeGrafico').val() == '') {
            msgErro('Necessário informar o nome do Gráfico para continuar.');
            return;
          }

          if ($('#select_dataset').val().length == 0) {
            msgErro('Necessário informar o DataSet para continuar.');
            return;
          }

          if ($('#txtEixo').val() == '') {
            msgErro('Necessário informar o Eixo do Gráfico para continuar.');
            return;
          }

          if (($('#select_tipo').val() == '7') && ($('#txtCidade').val() != 'CODIGO_CIDADE')) {
            msgErro('Gráficos do tipo Mapa devem ter obrigatoriamente o campo de código IBGE no select (CODIGO da tabela CIDADE) com um alias chamado CODIGO_CIDADE. Verifique.');
            return;
          }

          if (($('#select_tipo').val() == '7') && ($('#txtEstado').val() != 'CODIGO_ESTADO')) {
            msgErro('Gráficos do tipo Mapa devem ter obrigatoriamente o campo de ESTADO no select (COD_UF da tabela CIDADE) com um alias chamado CODIGO_ESTADO. Verifique.');
            return;
          }

          if ($('#txtValor').val() == '') {
            msgErro('Necessário informar o Valor do Gráfico para continuar.');
            return;
          }

          if ($('#txtCampoOrdenacao').val() == '') {
            msgErro('Necessário informar o campo de Ordenacao do Gráfico para continuar.');
            return;
          }

          //validar se os campos do eixo e valor existem em cada dataset do array...
          const datasetValor = typeof($('#select_dataset').val()) === 'string' ? [$('#select_dataset').val()] : $('#select_dataset').val();
          let bErro = false;
          for (let i = 0; i < datasetValor.length; i++) {
            const id_dataset = datasetValor[i];
            const iPosicaoArrayDataSet = arrDataSets.findIndex(obj => {
              return obj.id_banco == id_dataset;
            });
            // if (!arrDataSets[iPosicaoArrayDataSet].dados[0]) {
            //   msgErro('Nenhum dado disponível no dataset: ' + arrDataSets[iPosicaoArrayDataSet].nome + ', impossível editar');
            //   bErro = true;
            //   break;
            // }
            const arrayColunas = Object.keys(arrDataSets[iPosicaoArrayDataSet].dados[0]);
            const iPosicaoArrayEixo = arrayColunas.findIndex(obj => {
              return obj == $('#txtEixo').val();
            });

            if ((iPosicaoArrayEixo == -1) && ($('#select_tipo').val() != '6')) {
              msgErro('Coluna informada no campo Eixo inválida, verifique.');
              bErro = true;
              return;
            }

            const iPosicaoArrayValor = arrayColunas.findIndex(obj => {
              return obj == $('#txtValor').val();
            });

            if (iPosicaoArrayValor == -1) {
              msgErro('Coluna informada no campo Valor inválida, verifique.');
              bErro = true;
              return;
            }
          }

          if (bErro) {
            return;
          }

          let id_graf = $('#id-grafico').html().trim();
          const nomeJaUtilizado = arrGraficos.filter(graf => graf.nome == $('#txtNomeGrafico').val() && graf.id != id_graf).length > 0

          if (nomeJaUtilizado) {
            msgErro('Nome do gráfico já utilizado, verifique.');
            return;
          }

          let iPosicaoArray = arrGraficos.findIndex(obj => {
            return obj.id == id_graf
          });
          let grafico = preencheGrafico();
          if (iPosicaoArray != -1) {
            await editaGrafico(iPosicaoArray);
          } else {
            await adicionaGrafico();
          }

          iPosicaoArray = arrGraficos.findIndex(obj => {
            return obj.id == id_graf
          });

          // $(`#graf-${id_graf}`).tooltip('hide')
          //   .attr('data-original-title', `Nome: ${arrGraficos[iPosicaoArray].nome}`)
          //   .tooltip('show');
          $(`#graf-nome-${id_graf}`).html(arrGraficos[iPosicaoArray].nome);

          await limpaGrafico();
          await $('#modal-edit').modal('hide');
        }

        $('#btn-confirmar-dataset').on('click', async function() {
          if ($(`#txtSelect`).val().indexOf(';') != -1) {
            msgAlerta('Não é possível rodar SQLs com ";", verifique. ');
            return;
          }
          await rotinaConfirmarDataSet();
        });

        async function rotinaConfirmarDataSet() {
          if ($('#txtNomeDataSet').val() == '') {
            msgErro('Necessário informar o nome do DataSet para continuar.');
            return;
          }

          if ($('#txtSelect').val() == '') {
            msgErro('Necessário informar um select para continuar.');
            return;
          }

          await rotinaValidarSQL(false);


          // if ($('#tabela-resultados th').length == 0) {
          //   msgErro('Necessário executar o SQL através do botão Validar para continuar.');
          //   return;
          // }
          var id_dataset = -1;
          if ($('#id-dataset').html().trim() == 'Nova') {
            totalDataSets++;
            id_dataset = totalDataSets;
          } else {
            id_dataset = $('#id-dataset').html().trim();
          }
          let iPosicaoArray = arrDataSets.findIndex(obj => {
            return obj.id == id_dataset
          });
          let dataset = preencheDataSet();
          if (iPosicaoArray != -1) {
            await editaDataSet(iPosicaoArray);
          } else {
            await adicionaDataSet();
          }

          iPosicaoArray = arrDataSets.findIndex(obj => {
            return obj.id == id_dataset
          });



          function isNotEmpty(obj, prop) {
            return obj.hasOwnProperty(prop) && obj[prop] !== null && obj[prop] !== undefined && obj[prop] !== '';
          }


          if (iPosicaoArray != -1) {
            // encontrou o dataset na lista.
            const colunasSQL = Object.keys($('#tabela-resultados').DataTable().data()[0]);
            const listaGraficosQueUsamODatasetAtual = arrGraficos.filter(graf => {
              if (typeof graf.dataset == 'object') {
                return graf.dataset.includes(arrDataSets[iPosicaoArray].id_banco)
              } else {
                return graf.dataset == arrDataSets[iPosicaoArray].id_banco
              }
            });
            const colunasParaIncluir = ['valor', 'eixo', 'campo_ordenacao', 'estado', 'cidade'];
            const listaColunasUsadasEmGraficos = [];

            listaGraficosQueUsamODatasetAtual.forEach(obj => {
              colunasParaIncluir.forEach(coluna => {
                const valor = obj[coluna];
                if (!listaColunasUsadasEmGraficos.includes(valor) && isNotEmpty(obj, coluna)) {
                  listaColunasUsadasEmGraficos.push(valor);
                }
              });
            });
            const colunasNaoEncontradas = listaColunasUsadasEmGraficos.filter(item => !colunasSQL.includes(item));
            if (colunasNaoEncontradas.length > 0) {
              msgAlerta('A(s) coluna(s) ' + colunasNaoEncontradas.toString() + ' existem em gráficos ligados a esse Dataset e não foram mais encontradas no SQL atual, verifique.');
              return;
            }
          }

          if ($('#id-dataset').html().trim() == 'Nova') {
            $('.quadrados').append(
              `<div data-id="${id_dataset}" class="quadrado">${arrDataSets[iPosicaoArray].nome} <a title="editar" class="edit" href="#"><i class="fas fa-edit"></i></a><div class='delete'>&times;</div></div>`
            );
          } else {
            $(`div[data-id="${id_dataset}"]`).html(
              `${arrDataSets[iPosicaoArray].nome} <a title="editar" class="edit" href="#"><i class="fas fa-edit"></i></a><div class='delete'>&times;</div></div>`
            );
          }

          $('.quadrado .edit').unbind('click');
          $('.quadrado .edit').on('click', async function() {
            $.LoadingOverlay("show");
            try {
              const id_dataset = $(this).closest('.quadrado').attr('data-id');
              event.preventDefault();
              event.stopPropagation();
              let iPosicaoArray = arrDataSets.findIndex(obj => {
                return obj.id == id_dataset
              });
              if (iPosicaoArray != -1) {
                await carregaDataSet(iPosicaoArray);
              } else {
                await limpaDataSet();
              }
              await $('#id-dataset').html(id_dataset);
              await $('#modal-dataset').modal({
                backdrop: 'static',
                keyboard: false
              });
            } finally {
              await $.LoadingOverlay("hide");
            }
          });

          await limpaDataSet();
          await $('#modal-dataset').modal('hide');
        };

      });
    </script>
</body>

</html>