$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    })
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova cotação.",
          position: "right",
        },
      },
      {
        element: "#tabelaItens",
        popover: {
          title: "Tabela de Cotações",
          description: "Aqui está a lista de cotações cadastradas.",
          position: "top",
        },
      },
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  componenteFiltro('fornecedor', true, true)
  componenteFiltro('material', true, true)
  componenteFiltro('produto', true, true)
  componenteFiltro('servico', true, true)
  componenteFiltro('funcionario', true, true, 'Comprador')
  preencherFiltrosSalvos()

  const permissaoUsuarioLogado = await permissaoAcessos('COTACAO');

  $('#btnFiltros').on('click', function () {
    $('#modalFiltros').modal('show')
  })

  $('#btnConsultar').on('click', () => {
    consultar()
    $('#modalFiltros').modal('hide')
  })

  async function retornarFiltros() {
    const cotacaoDe = $('#txtCotacaoDe').val()
    const cotacaoAte = $('#txtCotacaoAte').val()
    const periodoDe = $('#txtPeriodoDe').val() || '1200-01-01'
    const periodoAte = $('#txtPeriodoAte').val() || '2500-12-31'
    const situacao = $('#selectSituacao').val()
    const fornecedor = await formataListas($('#txtFornecedor').val().toString())
    const material = await formataListas($('#txtMaterial').val().toString())
    const produto = await formataListas($('#txtProduto').val().toString())
    const servico = await formataListas($('#txtServico').val().toString())
    const comprador = await formataListas($('#txtComprador').val().toString())
    const usuario = $('#txtUsuario').val()

    return {
      cotacaoDe,
      cotacaoAte,
      periodoDe,
      periodoAte,
      situacao,
      fornecedor,
      material,
      produto,
      servico,
      comprador,
      usuario,
    }
  }

  function retornarBotaoOpcoes(data) {
    const retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Email" id="btnEmail">E-mail</button>  ' +
      '</div>'
    return retorno
  }

  async function consultar() {
    const filtros = await retornarFiltros()
    atualizarFiltrosAbasAcessoSessionStorage('cotacao', filtros)
    retornarDados({ filtros })
  }

  async function retornarDados({ filtros }) {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy()
      $('#tabelaItens').empty()
    }

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    if (colunasInvisiveis == null || colunasInvisiveis.acessoCotacao == undefined) {
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCotacao: ['EMPRESA'] }));
      colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    const columns = [
      {
        data: 'numero',
        title: 'Número',
        render: function (data) {
          return retornarBotaoOpcoes(data)
        },
      },
      {
        data: 'codigo',
        title: 'Código',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'fornecedor',
        title: 'Fornecedor',
      },
      {
        data: 'nome',
        title: 'Nome',
      },
      {
        data: 'cnpj',
        title: 'CNPJ',
      },
      {
        data: 'inscricao',
        title: 'Inscrição',
      },
      {
        data: 'bairro',
        title: 'Bairro',
      },
      {
        data: 'endereco',
        title: 'Endereço',
      },
      {
        data: 'numeroEndereco',
        title: 'Nº',
      },
      {
        data: 'complemento',
        title: 'Complemento',
      },
      {
        data: 'email',
        title: 'E-mail',
      },
      {
        data: 'dddFax',
        title: 'DDD Fax',
      },
      {
        data: 'fax',
        title: 'Fax',
      },
      {
        data: 'faxComplementar',
        title: 'Fax Complementar',
      },
      {
        data: 'ddd',
        title: 'DDD',
      },
      {
        data: 'telefone',
        title: 'Telefone',
      },
      {
        data: 'telefoneComplementar',
        title: 'Telefone Complementar',
      },
      {
        data: 'data',
        title: 'Data',
        render(data) {
          return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
        },
      },
      {
        data: 'cor',
        title: 'Cor',
      },
      {
        data: 'descricaoCor',
        title: 'Descricao Cor',
      },
      {
        data: 'usuario',
        title: 'Usuário',
      },
      {
        data: 'comprador',
        title: 'Comprador',
      },
      {
        data: 'nomeComprador',
        title: 'Nome Comprador',
      },
    ]

    $('#tabelaItens').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: true,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      pageLength: 15,
      serverSide: true,
      scrollY: '350px',
      ajax: {
        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/cotacao/v1/retornardadosacesso`,
        type: "POST",
        headers: {
          'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
        },
        data: function (data) {
          const { start, length, draw } = data;
          return JSON.stringify({
            filtros,
            paginacao: {
              quantidadeMaximaRegistros: length,
              quantidadeRegistrosPular: start,
              contadorRequisicoes: draw,
            },
            empresa: getCookie('empresa')
          })
        },
        cache: true,
        beforeSend: function () {
          $.LoadingOverlay('show')
        },
        complete: function () {
          $.LoadingOverlay('hide')
        },
        dataSrc: function (json) {
          if (!json || !json.data) {
            return []
          }
          return json.data
        }
      },
      autoWidth: true,
      columns,
      scrollX: true,
    })

    $('#tabelaItens_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
    $('#tabelaItens_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
    $('#buttonExcel').prop('title', 'Exportar');

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcel').on('click', async function () {
      const dados = $("#tabelaItens").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório da aba acesso de cotação', '', '', 999, false, false, dados);
    });

    $('#tabelaItens').DataTable().columns().every(function () {
      if ((colunasInvisiveis.acessoCotacao).indexOf(this.dataSrc()) != -1) {
        this.visible(false);
      }
    });
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaItens').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCotacao ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["CODIGO"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCotacao: novasColunas }));

      $('#tabelaItens').DataTable().columns().visible(true);

      $('#tabelaItens').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });


  function preencherFiltrosSalvos() {
    const filtrosSessionStorage = sessionStorage.getItem('filtrosConsultasAbasAcesso')
    if (!filtrosSessionStorage) {
      consultar()
      return
    }
    if (filtrosSessionStorage) {
      const { cotacao: filtros } = JSON.parse(filtrosSessionStorage)
      if (!filtros) {
        consultar()
        return
      }
      const { cotacaoDe, cotacaoAte, periodoDe, periodoAte, situacao, usuario, ...filtrosRetornarDescricoes } = filtros
      carregarFiltrosSalvos(filtrosRetornarDescricoes).then(({ fornecedores, materiais, produtos, servicos, compradores, }) => {
        setTimeout(() => {
          if (filtros.cotacaoDe) insereValor('#txtCotacaoDe', filtros.cotacaoDe)
          if (filtros.cotacaoAte) insereValor('#txtCotacaoAte', filtros.cotacaoAte)
          if (filtros.periodoDe) insereValor('#txtPeriodoDe', filtros.periodoDe)
          if (filtros.periodoAte) insereValor('#txtPeriodoAte', filtros.periodoAte)
          if (filtros.situacao) insereValor('#selectSituacao', filtros.situacao)
          if (fornecedores) fornecedores.forEach((item) => adicionaValorPadraoVarios('fornecedor', item?.codigo, item?.descricao))
          if (materiais) materiais.forEach((item) => adicionaValorPadraoVarios('material', item?.codigo, item?.descricao))
          if (produtos) produtos.forEach((item) => adicionaValorPadraoVarios('produto', item?.codigo, item?.descricao))
          if (servicos) servicos.forEach((item) => adicionaValorPadraoVarios('servico', item?.codigo, item?.descricao))
          if (compradores) compradores.forEach((item) => adicionaValorPadraoVarios('comprador', item?.codigo, item?.descricao))
          if (filtros.usuario) insereValor('#txtUsuario', filtros.usuario)
        }, 150)
        retornarDados({ filtros })
      }).catch(
        () => msgErro('Ocorreu um erro ao preencher os filtros salvos.')
      ).finally(() => { })
    }
  }

  async function carregarFiltrosSalvos(filtros) {
    const response = await requisicao("POST", `/sisplan/cotacao/v1/retornardadosinputsfiltrosacesso?`, '', JSON.stringify(filtros), 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  $('#btnLimparFiltros').on('click', function () {
    $('#txtCotacaoDe').val('')
    $('#txtCotacaoAte').val('')
    $('#txtPeriodoDe').val('1200-01-01')
    $('#txtPeriodoAte').val('2500-12-31')
    $('#selectSituacao').val('')
    $('#txtFornecedor').empty().trigger('change')
    $('#txtMaterial').empty().trigger('change')
    $('#txtProduto').empty().trigger('change')
    $('#txtServico').empty().trigger('change')
    $('#txtComprador').empty().trigger('change')
    $('#txtUsuario').val('')
  })

  $('#btnIncluir').on('click', function () {
    window.location.href = `cotacao/${btoa('create')}`
  })

  $('#tabelaItens').on('click', '#btnEditar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      if (data && data?.numero) {
        const registroLiberado = await verificarRegistro('COTACAO', data?.numero)
        if (registroLiberado) {
          window.location.href = `cotacao/${btoa(data?.numero?.substring(0, 6))}`
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!")
    }
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaItens').DataTable().row($(this)).data()
      if (data && data?.numero) {
        const registroLiberado = await verificarRegistro('COTACAO', data?.numero)
        if (registroLiberado) {
          window.location.href = `cotacao/${btoa(data?.numero?.substring(0, 6))}`
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!")
    }
  })

  $('#tabelaItens').on('click', '#btnExcluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const row = $('#tabelaItens').DataTable().row($(this).parents('tr'))
      const data = row.data()
      if (data && data?.numero) {
        const numero = data?.numero.split('/')?.[0]
        if (!numero) return
        const registroLiberado = await verificarRegistro('COTACAO', data?.numero)
        if (registroLiberado) {
          msgAlerta(
            'Deseja excluir a cotação selecionada?\nA cotação será excluída para todos os fornecedores.',
            () => { },
            () => { },
            () => excluir(numero),
          )
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!")
    }
  })

  async function excluir(numero) {
    if (!numero) return
    $.LoadingOverlay('show')
    requisicao('DELETE', `/sisplan/cotacao/v1/excluir?`, `&NUMERO=${encodeURIComponent(numero)}`, '', 3600000)
      .then(async (response) => {
        if (response.status !== 204) {
          const json = await response.json()
          throw json?.mensagem?.mensagem
        }

        toastr.success("Cotação excluída com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            consultar()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }).catch((error) => {
        console.error(error)
        msgErro(error || 'Ocorreu um erro ao realizar a exclusão.')
      }
      ).finally(() => $.LoadingOverlay('hide'))
  }

  $('#btnSolicitacao').on('click', function () {
    $('#modalSolicitacao').modal('show')
  })

  $('#modalSolicitacao').on('hide.bs.modal', function () {
    limparModalSolicitacao()
  })

  $('#txtNumeroConsultaSolicitacao').autocompleta(
    1,
    `JSON={ "tabela":"SOL_COMPRA", "camposSelect":["NUMERO CHAVE", "SOLICITANTE DESCRICAO"], "where": ["EXISTS (SELECT SOL_ITEN.NUMERO FROM [SOL_ITEN] SOL_ITEN WHERE SOL_COMPRA.NUMERO = SOL_ITEN.NUMERO AND STATUS = 'L')"] }`,
    undefined,
    undefined,
    undefined,
    () => setTimeout(
      () => retornarDadosSolicitacao({
        numero: pegaChave('#txtNumeroConsultaSolicitacao'),
      }),
      150
    ),
  )
  $('#btnNumeroConsultaSolicitacao').pesquisa_serverside(
    ['#txtNumeroConsultaSolicitacao'],
    ['NUMERO'],
    ['SOLICITANTE'],
    `{ "tabela":"SOL_COMPRA", "camposSelect":["NUMERO", "SOLICITANTE"], "where": ["EXISTS (SELECT SOL_ITEN.NUMERO FROM [SOL_ITEN] SOL_ITEN WHERE SOL_COMPRA.NUMERO = SOL_ITEN.NUMERO AND STATUS = 'L')"] }`,
    'Pesquisa Solicitação',
    () => setTimeout(
      () => retornarDadosSolicitacao({
        numero: pegaChave('#txtNumeroConsultaSolicitacao'),
      }),
      150
    ),
  )
  $('#btnLimpaNumeroConsultaSolicitacao').on('click', function () {
    $('#txtNumeroConsultaSolicitacao').val('')
  })

  const retornarDadosSolicitacao = ({ numero }) => {
    $.LoadingOverlay('show')
    requisicao(
      'GET',
      `/sisplan/cotacao/v1/retornardadossolicitacaocotar?`,
      `NUMERO=${encodeURIComponent(numero)}`,
      '',
      3600000
    ).then(async (response) => {
      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        const { capa, itens } = resultado

        preencherDadosCapaSolicitacao(capa)
        criarTabelaItensSolicitacao(itens ?? [])
      }
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  const preencherDadosCapaSolicitacao = (capa) => {
    if (!capa) return
    capa.numero ? insereValor('#txtNumeroSolicitacao', capa.numero) : $('#txtNumeroSolicitacao').val('')
    capa.usuario ? insereValor('#txtUsuarioSolicitacao', capa.usuario) : $('#txtUsuarioSolicitacao').val('')
    capa.cadastro ? insereValor('#txtCadastroSolicitacao', capa.cadastro?.split('T')?.[0]) : $('#txtCadastroSolicitacao').val('')
    capa.emissao ? insereValor('#txtEmissaoSolicitacao', capa.emissao?.split('T')?.[0]) : $('#txtEmissaoSolicitacao').val('')
    capa.entrega ? insereValor('#txtEntregaSolicitacao', capa.entrega?.split('T')?.[0]) : $('#txtEntregaSolicitacao').val('')
    capa.baixa ? insereValor('#txtBaixaSolicitacao', capa.baixa?.split('T')?.[0]) : $('#txtBaixaSolicitacao').val('')
    capa.solicitante ? insereValor('#txtSolicitanteSolicitacao', capa.solicitante, capa.nomeSolicitante) : $('#txtSolicitanteSolicitacao').val('')
    capa.prazo ? insereValor('#txtPrazoSolicitacao', capa.prazo, capa.descricaoPrazo) : $('#txtPrazoSolicitacao').val('')
    capa.motivo ? insereValor('#txtMotivoSolicitacao', capa.motivo, capa.descricaoMotivo) : $('#txtMotivoSolicitacao').val('')
    capa.tipo && capa.tipo !== '0' ? insereValor('#txtTipoSolicitacao', capa.tipo, capa.descricaoTipo) : $('#txtTipoSolicitacao').val('')
    capa.observacao ? insereValor('#txtObservacaoSolicitacao', capa.observacao) : $('#txtObservacaoSolicitacao').val('')
  }

  const criarTabelaItensSolicitacao = (data) => {
    if ($.fn.DataTable.isDataTable('#tabelaItensSolicitacao')) {
      $('#tabelaItensSolicitacao').DataTable().destroy()
      $('#tabelaItensSolicitacao').empty()
    }

    const columns = [
      {
        data: 'codigo',
        title: 'Código',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'unidade',
        title: 'Unidade',
      },
      {
        data: 'unidadeCompra',
        title: 'Unidade Compra',
      },
      {
        data: 'cor',
        title: 'Cor',
      },
      {
        data: 'descricaoCor',
        title: 'Descrição Cor',
      },
      {
        data: 'tamanho',
        title: 'Tamanho',
      },
      {
        data: 'tipo',
        title: 'Tipo',
      },
      {
        data: 'quantidade',
        title: 'Quantidade',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return '0.00000'
          }
          return parseFloat(data).toFixed(5)
        }
      },
      {
        data: 'preco',
        title: 'Preço',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return '0.00000'
          }
          return parseFloat(data).toFixed(5)
        }
      },
      {
        data: 'valor',
        title: 'Valor',
        className: 'text-right',
        render: function (data) {
          if (!data) {
            return '0.00000'
          }
          return parseFloat(data).toFixed(5)
        }
      },
      {
        data: 'especificacao',
        title: 'Especificação',
      },
    ]

    $('#tabelaItensSolicitacao').DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '300px',
    })
  }

  $('#btnConfirmarSolicitacao').on('click', function () {
    gravarCotacaoSolicitacao()
  })

  const gravarCotacaoSolicitacao = async () => {
    const dados = retornarDadosGravarCotacaoSolicitacao()
    if (!validarDadosGravarCotacaoSolicitacao({ dados })) return
    $.LoadingOverlay('show')
    requisicao(
      'PUT',
      `/sisplan/cotacao/v1/gravarcotacaosolicitacao?`,
      '',
      JSON.stringify(dados),
      3600000
    ).then(async (response) => {
      const json = await response.json()

      if (json) {
        const { mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onShown() {
            consultar()
          },
          onHidden() {
            $('#modalSolicitacao').modal('hide')
            limparModalSolicitacao()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao gravar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  const validarDadosGravarCotacaoSolicitacao = ({ dados }) => {
    if (dados.fornecedores.length === 0) {
      msgErro('Nenhum fornecedor informado, impossível continuar.')
      return false
    }

    if (!dados.validade) {
      msgErro('Data de validade vazia, impossível continuar.')
      return false
    }

    if (dados.itens.length === 0) {
      msgErro('Nenhum item consultado, impossível continuar.')
      return false
    }

    return true
  }

  const limparModalSolicitacao = () => {
    $('.campoModalSolicitacao').val('')
    if ($.fn.DataTable.isDataTable('#tabelaItensSolicitacao')) {
      $('#tabelaItensSolicitacao').DataTable().destroy()
      $('#tabelaItensSolicitacao').empty()
    }
    $('#txtFornecedorSolicitacao').empty().trigger('change')
  }

  const retornarDadosGravarCotacaoSolicitacao = () => {
    const numero = $('#txtNumeroSolicitacao').val()
    const dataEntrega = $('#txtEntregaSolicitacao').val()
    const validade = $('#txtValidadeSolicitacao').val()
    const observacao = ''
    const itens = retornarItensGravarCotacaoSolicitacao({ numero, dataEntrega })
    const fornecedores = retornarFornecedoresGravarCotacaoSolicitacao()
    return {
      numero,
      validade,
      observacao,
      itens,
      fornecedores,
    }
  }

  const retornarFornecedoresGravarCotacaoSolicitacao = () => {
    const data = $('#txtFornecedorSolicitacao')?.children()?.toArray()?.map(item => {
      const html = $(item).html()
      return {
        codigo: pegaChave(html),
        nome: pegaDescricao(html),
        emailEnviado: '',
        numero: '',
      }
    })

    return data ?? []
  }

  const retornarItensGravarCotacaoSolicitacao = ({ numero, dataEntrega }) => {
    if (!$.fn.DataTable.isDataTable('#tabelaItensSolicitacao')) {
      return []
    }
    const data = $('#tabelaItensSolicitacao')?.DataTable()?.data()?.toArray()?.map((item) => {
      return {
        codigo: item.codigo,
        descricao: item.descricao,
        unidade: item.unidade,
        unidadeCompra: item.unidadeCompra,
        cor: item.cor,
        descricaoCor: item.descricaoCor,
        tamanho: item.tamanho,
        tipo: item.tipo,
        quantidade: item.quantidade,
        preco: item.preco,
        valor: item.valor,
        especificacao: item.especificacao,
        numero,
        dataEntregaPrevista: dataEntrega,
      }
    })

    return data ?? []
  }

  componenteFiltro('entidade', true, true, 'FornecedorSolicitacao')



  $('#tabelaItens').on('click', '#btnEmail', async function () {
    const data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
    if (data && data.numero) {
      msgAlerta(
        'Deseja enviar e-mail para todos os fornecedores dessa cotação?',
        () => null,
        () => null,
        async () => enviarCotacaoPorEmail({ numero: data.numero.substring(0, 6) })

      )
    }
  })

  const enviarCotacaoPorEmail = ({ numero }) => {
    if (!numero) return
    $.LoadingOverlay('show')
    const body = {
      numero,
      idUsuario: getCookie('id_usuario'),
    }
    requisicao('POST', `/sisplan/cotacao/v1/enviarporemail?`, ``, JSON.stringify(body), 3600000)
      .then(async (response) => {
        if (response.status !== 200) {
          const json = await response.json()
          throw json?.mensagem?.mensagem
        }

        toastr.success("E-mail(s) enviado(s) com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            consultar()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }).catch((error) => {
        console.error(error)
        msgErro(error || 'Ocorreu um erro ao realizar o envio.')
      }
      ).finally(() => $.LoadingOverlay('hide'))
  }
})