$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoVeiculo',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um veículo.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaVeiculos',
                popover: {
                    title: 'Tabela Veículos',
                    description: 'Aqui estão os dados da consulta.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {

    const permissaoUsuarioLogado = await permissaoAcessos("CADVEICULO");

    $('#txtProprietario').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
    $('#btnProprietario').pesquisa('#txtProprietario', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Proprietário', 'ENITDADE');
    $('#txtPlaca').autocompleta(1, `JSON={ "tabela":"VEICULO", "camposSelect":[ "PLACA CHAVE", "MODELO DESCRICAO"], "where": null}`);
    $('#btnPlaca').pesquisa('#txtPlaca', 'PLACA', 'MODELO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VEICULO", "camposSelect":[ "PLACA", "MODELO"]}`, 'Pesquisa Placa', 'VEICULO');
    $('#txtModelo').autocompleta(1, `JSON={ "tabela":"VEICULO", "camposSelect":[ "MODELO CHAVE", "MARCA DESCRICAO"], "where": null}`);
    $('#btnModelo').pesquisa('#txtModelo', 'MODELO', 'MARCA', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VEICULO", "camposSelect":[ "MODELO", "MARCA"]}`, 'Pesquisa Modelo', 'VEICULO');
    $('#txtCidade').autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnCidade').pesquisa('#txtCidade', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Cidade', 'TABUF');
    $('#txtSeguradora').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
    $('#btnSeguradora').pesquisa('#txtSeguradora', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Seguradora', 'ENTIDADE');

    $('#btnLimpaProprietario').on('click', function () {
        $('#txtProprietario').val('');
    });

    $('#btnLimpaPlaca').on('click', function () {
        $('#txtPlaca').val('');
    });

    $('#btnLimpaModelo').on('click', function () {
        $('#txtModelo').val('');
    });

    $('#btnLimpaCidade').on('click', function () {
        $('#txtCidade').val('');
    });

    $('#btnLimpaSeguradora').on('click', function () {
        $('#txtSeguradora').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovoVeiculo').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "cadveiculo/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>      ' +
            '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    }

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    consultaConta();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaConta();
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#dtVencimentoDe').val('1200-01-01');
        $('#dtVencimentoAte').val('2500-12-31');
        $('#dtVencimentoIPVADe').val('1200-01-01');
        $('#dtVencimentoIPVAAte').val('2500-12-31');
        $('#txtProprietario').val('');
        $('#txtPlaca').val('');
        $('#txtModelo').val('');
        $('#txtCidade').val('');
        $('#txtSeguradora').val('');
    });

    async function consultaConta() {
        try {
            $.LoadingOverlay("show");
            let where = ''
            where += $('#dtVencimentoDe').val() != '' ? ` AND VENC_LICENCIAMENTO >= '${$('#dtVencimentoDe').val()}'` : '';
            where += $('#dtVencimentoAte').val() != '' ? ` AND VENC_LICENCIAMENTO <= '${$('#dtVencimentoAte').val()}'` : '';
            where += $('#dtVencimentoIPVADe').val() != '' ? ` AND VENC_IPVA >= '${$('#dtVencimentoIPVADe').val()}'` : '';
            where += $('#dtVencimentoIPVAAte').val() != '' ? ` AND VENC_IPVA <= '${$('#dtVencimentoIPVAAte').val()}'` : '';
            where += pegaChave('#txtProprietario') != '' ? ` AND MOTORISTA = '${pegaChave('#txtProprietario')}'` : '';
            where += pegaChave('#txtPlaca') != '' ? ` AND PLACA = '${pegaChave('#txtPlaca')}'` : '';
            where += pegaChave('#txtModelo') != '' ? ` AND MODELO = '${pegaChave('#txtModeloo')}'` : '';
            where += pegaChave('#txtCidade') != '' ? ` AND COD_MUN = '${pegaChave('#txtCidade')}'` : '';
            where += pegaChave('#txtSeguradora') != '' ? ` AND SEGURADORA = '${pegaChave('#txtSeguradora')}'` : '';
            response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"VEICULO", "camposSelect":[ "PLACA", "MARCA"], "where": ["1=1 ${where}"]}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr.RESULT[0].mensagem);
                return;
            }

            let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            if (colunasInvisiveis == null || colunasInvisiveis.acessoCadVeiculo == undefined) {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadVeiculo: ['EMPRESA'] }));
                colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            }

            $('#tabelaVeiculos').DataTable({
                destroy: true,
                lengthChange: true,
                searching: true,
                paging: true,
                scrollX: true,
                scrollY: '350px',
                serverside: true,
                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    data: "PLACA",
                    title: "Placa"
                },
                {
                    data: "MARCA",
                    title: "Marca"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

            $('#tabelaVeiculos_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaVeiculos_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaVeiculos").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso de cadastro de veículo', '', '', 999, false, false, dados);
            });

            $('#tabelaVeiculos').DataTable().columns().every(function () {
                if ((colunasInvisiveis.acessoCadVeiculo).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaVeiculos').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoCadVeiculo ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["PLACA"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadVeiculo: novasColunas }));

            $('#tabelaVeiculos').DataTable().columns().visible(true);

            $('#tabelaVeiculos').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#tabelaVeiculos').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaVeiculos').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('CADVEICULO', data.PLACA);
            if (registroLiberado) {
                window.location.href = `cadveiculo/${data.PLACA}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaVeiculos').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaVeiculos').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('CADVEICULO', data.PLACA);
            if (registroLiberado) {
                window.location.href = `cadveiculo/${data.PLACA}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaVeiculos').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaVeiculos").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/sisplan/cadastros/v1/veiculo?", `PLACA=${(valorLinha.PLACA)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});