/**
 *  Copyright 2017 Amardeep Rai
 *  
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  
 *      http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const csso = require('gulp-csso');
const del = require('del');
const gulp = require('gulp');
// const htmlmin = require('gulp-htmlmin');
const javascriptObfuscator = require('gulp-javascript-obfuscator');
const uglify = require('gulp-uglify');


// Gulp task to minify CSS files
gulp.task('dist_css', function () {
  return gulp.src(['./dist/**/*.css'])
    // Minify the file
    .pipe(csso())
    // Output
    .pipe(gulp.dest('../sisplan_web_prod/dist/'));
});

gulp.task('dist_map', function () {
  return gulp.src(['./dist/**/*.map', './dist/**/*.gif', './dist/**/*.json', './dist/**/*.jpg', './dist/**/*.png', './dist/**/*.jpeg', './dist/**/*.mp3'])
    // Output
    .pipe(gulp.dest('../sisplan_web_prod/dist/'));
});

gulp.task('dist_js', function () {
  return gulp.src(['./dist/**/*.js'])
    .pipe(javascriptObfuscator({
      compact: true
    }))
    .pipe(gulp.dest('../sisplan_web_prod/dist/'));
});

gulp.task('plugins_css', function () {
  return gulp.src(['./plugins/**/*.css'])
    // Minify the file
    .pipe(csso())
    // Output
    .pipe(gulp.dest('../sisplan_web_prod/plugins/'));
});

gulp.task('plugins_map', function () {
  return gulp.src(['./plugins/**/*.map', './plugins/**/*.svg', './plugins/**/*.eot', './plugins/**/*.woff', './plugins/**/*.woff2', './plugins/**/*.ttf'])
    // Output
    .pipe(gulp.dest('../sisplan_web_prod/plugins/'));
});

gulp.task('plugins_js', function () {
  return gulp.src(['./plugins/**/**/*.js'])
    .pipe(uglify())
    // Output
    .pipe(gulp.dest('../sisplan_web_prod/plugins/'));
});

gulp.task('fr3', function () {
  return gulp.src(['./**/*.fr3', './**/*.FR3'])
    .pipe(gulp.dest('../sisplan_web_prod'));
});

gulp.task('utils', function () {
  return gulp.src(['./utils/**/**/*.js'])
    .pipe(javascriptObfuscator({
      compact: true
    }))
    .pipe(gulp.dest('../sisplan_web_prod/utils/'));
});

gulp.task('modals', function () {
  return gulp.src(['./modals/**/**/*.js'])
    .pipe(javascriptObfuscator({
      compact: true
    }))
    .pipe(gulp.dest('../sisplan_web_prod/modals/'));
});


gulp.task('modals2', function () {
  return gulp.src(['./modals/**/**/*.html'])
    // Output
    .pipe(gulp.dest('../sisplan_web_prod/modals/'));
});

gulp.task('pages', function () {
  return gulp.src(['./pages/**/**/*.js'])
    .pipe(javascriptObfuscator({
      compact: true
    }))
    .pipe(uglify())
    // Output
    .pipe(gulp.dest('../sisplan_web_prod/pages/'));
});


gulp.task('pages2', function () {
  return gulp.src(['./pages/**/**/*.html', './pages/**/**/*.php', './pages/**/**/*.css'])
    // Output
    .pipe(gulp.dest('../sisplan_web_prod/pages/'));
});

gulp.task('others', function () {
  return gulp.src(['./*.php',
    './*.md',
    './*.json',
    './*.html',
    './*.ico',
    './*.bat',
    './*.js',
    './.htaccess'])
    // Output
    .pipe(gulp.dest('../sisplan_web_prod/'));
});


// Clean output directory
gulp.task('clean', () => del(['../sisplan_web_prod'], { force: true }));

// Gulp task to minify all files
gulp.task('default', gulp.series('clean', 'dist_css', 'dist_map', 'dist_js', 'plugins_css', 'plugins_js', 'plugins_map', 'fr3', 'modals', 'modals2', 'utils', 'pages', 'pages2', 'others'));