$(document).ready(async function () {

  // GRAFICO
  let options = {
    series: [{
      name: "Quantidade",
      data: [{}]
    }],
    chart: {
      type: 'line',
      height: 300,
      zoom: {
        enabled: false
      }
    },
    dataLabels: {
      enabled: false
    },
    stroke: {
      curve: 'straight'
    },
    title: {
      text: 'Product Trends by Month',
      align: 'left'
    },
    title: {
      text: 'Vendas do item selecionado',
    },
    fill: {
      colors: ['#75BE25']
    }
  };

  let optionsProducao = {
    series: [{
      name: "Quantidade",
      data: [{}]
    }],
    chart: {
      type: 'bar',
      height: 300
    },
    tooltip: {
      x: {
        formatter: function (val) {
          return val;
        }
      }
    },
    xaxis: {
      type: 'category',
      labels: {
        formatter: function (val) {
          return val.split(' - ')[0];
        }
      }
    },
    title: {
      text: 'Quantidade produzida do item ',
    },
    fill: {
      colors: ['#75BE25']
    }
  };
  // FIM GRAFICO

  let listaOrdenacao = [];
  let grid;

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.curvaProduto == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, curvaProduto: ['EMPRESA'] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.curvaProdutoProducao == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, curvaProdutoProducao: ['EMPRESA'] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  setarDataAtual('txtDataVendasAte');

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      if (grid == 1) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, curvaProduto: novasColunas }))

        $('#tabelaRelCurvaProduto').DataTable().columns().visible(true);

        $('#tabelaRelCurvaProduto').DataTable().columns().every(function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })
      } else {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, curvaProdutoProducao: novasColunas }))

        $('#tabelaOrdemProducao').DataTable().columns().visible(true);

        $('#tabelaOrdemProducao').DataTable().columns().every(function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  adicionarConteudoModal(
    'Curva Produto', [
    {
      tipo: 'paragrafo',
      valor: 'Este relatório apresenta a curva de vendas do Produto com base na coleção informada (que é obrigatória para consulta), com possibilidade de realizar ' +
        'filtros por referência, grupo, etiqueta, entre outros campos, filtrando também um período de vendas.'
    },
    {
      tipo: 'paragrafo',
      valor: 'O gráfico representa a linha/curva em quantidades de vendas.',
    },
    {
      tipo: 'paragrafo',
      valor: 'Com base na quantidade produzida, possibilita também visualizar as variantes das ordens de produção, efetuando o calculo de média das cores.'
    },
    {
      tipo: 'paragrafo',
      valor: 'O total de vendas dividido pelo total produzido resulta no desempenho que determinada referência teve dentro do período de vendas e da coleção informada.'
    },
    {
      tipo: 'paragrafo',
      valor: 'São consideradas no resultado somente vendas fechadas.'
    }
  ]
  );

  const filtroDeposito = await buscaDepositoEmpresaUsuario();

  componenteFiltro('produto', true);
  componenteFiltro('modelo', true);
  componenteFiltro('grupoPA', true);
  componenteFiltro('etiqueta', true);
  componenteFiltro('linha', true);
  componenteFiltro('marca', true);
  componenteFiltro('depositoUsuario', true);
  componenteFiltro('tipoVenda', true);
  componenteFiltro('colecao', true);

  preencheOrdenacaoTela('CurvaProduto');

  limparFiltros(true);

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/relcurvaproduto?`;
        let params = await retornaFiltros();

        params += `&ORDERBY=${listaOrdenacao}`;

        let arquivo = await GeraRelatorio(`${url + params}&`, 'POST', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaFiltros(codigo) {
    let dep = await formataListas($('#txtDepositoUsuario').val().toString());
    let variante = 'VARIANTES=N';

    if (dep == '') {
      dep = filtroDeposito;
    }

    const filtros = {
      venda_de: $('#txtDataVendasDe').val(),
      venda_ate: $('#txtDataVendasAte').val(),
      // producao_de: $('#txtDataProducaoDe').val(),
      // producao_ate: $('#txtDataProducaoAte').val(),
      colecao: await formataListas($('#txtColecao').val().toString()),
      etiqueta: await formataListas($('#txtEtiqueta').val().toString()),
      produto: codigo != undefined ? codigo : await formataListas($('#txtProduto').val().toString()),
      grupo: await formataListas($('#txtGrupoPA').val().toString()),
      linha: await formataListas($('#txtLinha').val().toString()),
      marca: await formataListas($('#txtMarca').val().toString()),
      empresas: $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
        : [getCookie('emp_id')],
      modelo: await formataListas($('#txtModelo').val().toString()),
      deposito: dep,
      emitido: $('#cbEmitido').prop('checked'),
      pendente: $('#cbPendente').prop('checked'),
      agrupado: $('#cbAgrupado').prop('checked'),
      devolvido: $('#cbDevolvido').prop('checked'),
      cancelado: $('#cbCancelado').prop('checked'),
      tipovenda: await formataListas($('#txtTipoVenda').val().toString())
    }

    if (codigo != undefined) {
      variante = 'VARIANTES=S'
    }
    const params = `VENDA_DE=${filtros.venda_de}&` +
      `VENDA_ATE=${filtros.venda_ate}&` +
      `PRODUTO=${filtros.produto}&` +
      `GRUPO=${filtros.grupo}&` +
      `ETIQUETA=${filtros.etiqueta}&` +
      `LINHA=${filtros.linha}&` +
      `COLECAO=${filtros.colecao}&` +
      `EMPRESAS_FILTRO=${filtros.empresas}&` +
      `MODELO=${filtros.modelo}&` +
      `DEPOSITO=${filtros.deposito}&` +
      `MARCA=${filtros.marca}&` +
      `EMITIDO=${filtros.emitido}&` +
      `PENDENTE=${filtros.pendente}&` +
      `AGRUPADO=${filtros.agrupado}&` +
      `DEVOLVIDO=${filtros.devolvido}&` +
      `CANCELADO=${filtros.cancelado}&` +
      `TIPO_VENDA=${filtros.tipovenda}&` +
      variante;
    // `VENDA_DE=${filtros.venda_de}&` +
    // `VENDA_ATE=${filtros.venda_ate}&` +        

    return params;
  };

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($('#txtDataVendasDe').val() == '') {
          msgAlerta('Data não informada ou inválida')
          return;
        } else if ($('#txtColecao').val() == '') {
          msgAlerta('Coleção não informada, necessário selecionar uma coleção!', undefined, undefined, () => { $('#modal-filtros').modal('show') });
          return;
        }

        let dataSetCols = [];
        listaOrdenacao = [];
        const url = '/sisplan/impressao/v1/relcurvaproduto?';
        const params = await retornaFiltros();

        const response = await requisicao('GET', url, params, null, 150000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          // $('#tabelaRelDesempenhoProduto').DataTable().rows().remove().draw(false);
          msgAlerta('Nenhum registro encontrado!');
          return;
        }

        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        }

        const keys = jsonStr.map((key) => {

          let mediaDesempenhoProduto = key.DESEMPENHO;

          if ((mediaDesempenhoProduto == Infinity) || (isNaN(mediaDesempenhoProduto))) {
            mediaDesempenhoProduto = 0
          };

          return {
            ...key, DESEMPENHO: String(TruncaDecimaisNova(2, mediaDesempenhoProduto)) + '%'
          }
        });

        Object.keys(jsonStr[0]).forEach(k => {
          k = { data: k, title: k }

          switch (k.data) {
            case 'QUANTIDADE_VENDIDA':
              k.title = 'VENDAS'
              break;
            default:
              break;
          }

          if (!['COR', 'DESC_COR'].includes(k.data)) {
            dataSetCols.push({
              'title': k.title,
              'data': k.data
            });
          }
        });

        let colunas = Object.keys(jsonStr[0]);
        const campos = ['QTDE_PROD', 'VARIANTES', 'MEDIA_COR', 'TOTAL', 'DESEMPENHO'];
        let indiceMedia;
        let indiceTotal;
        const indiceDireita = [];

        for (let i = 0; i < colunas.length; i++) {
          if (campos.includes(colunas[i])) {
            if ((colunas[i] == 'TOTAL') || (colunas[i] == 'DESEMPENHO')) {
              indiceDireita.push(i-2);
            } else {
              indiceDireita.push(i);
            }
          }

          if (colunas[i] == 'MEDIA_COR') {
            indiceMedia = i;
          }

          if (colunas[i] == 'TOTAL') {
            indiceTotal = i-2;
          }          
        }

        for (let i = indiceMedia+1; i < indiceTotal; i++) {
          indiceDireita.push(i);          
        }

        if ($.fn.DataTable.isDataTable('#tabelaRelCurvaProduto')) {
          $('#tabelaRelCurvaProduto').DataTable().destroy();
          $('#tabelaRelCurvaProduto').empty();
        }

        if ($.fn.DataTable.isDataTable('#tabelaOrdemProducao')) {
          $('#tabelaOrdemProducao').DataTable().destroy();
          $('#tabelaOrdemProducao').empty();
        }

        $('#tabelaRelCurvaProduto').DataTable({
          // autoWidth: true,
          // bPaginate: true,
          // destroy: true,
          // search: false,
          // filter: false,
          // scrollX: true,
          // serverside: false,
          // order: false,
          // "scrollCollapse": true,
          search: false,
          filter: false,
          order: [],
          sort: true,
          destroy: true,
          "data": keys,
          "columns": dataSetCols,
          autoWidth: true,
          "colReorder": true,
          columnDefs: [
            {
              "targets": indiceDireita,
              "className": 'pr-4 text-right'
            }
          ]
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $($('#tabelaRelCurvaProduto').find('th')[2]).prop('title', 'Quantidade Produção');
        $($('#tabelaRelCurvaProduto').find('th')[3]).prop('title', 'Quantidade de Cores Vendidas');
        $($('#tabelaRelCurvaProduto').find('th')[4]).prop('title', 'Quantidade Produção dividido Variantes');
        const tabela = $('#tabelaRelCurvaProduto').DataTable();
        const numeroDeColunas = tabela.columns().count();
        $($('#tabelaRelCurvaProduto').find('th')[numeroDeColunas - 2]).prop('title', 'Total de Vendas do Período Selecionado');
        $($('#tabelaRelCurvaProduto').find('th')[numeroDeColunas - 1]).prop('title', 'Total de Vendas dividido pela Quantidade de Produção');

        // adiciona o botão na tabela e adiciona a função de abrir o modal
        $('#tabelaRelCurvaProduto_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelCurvaProduto_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          grid = 1;
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/relcurvaproduto?';
          const params = await retornaFiltros();

          await exportaCSV(url, params, false, null, 'Relatório de Curva de Produto', '#tabelaRelCurvaProduto');
        })

        $('#tabelaRelCurvaProduto').DataTable().columns().every(function () {
          if ((colunasInvisiveis.curvaProduto).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });

        $('#tabelaRelCurvaProduto th').on('click', function () {
          listaOrdenacao = adicionaOrdenacao(
            retornaDataSrcColuna($('#tabelaRelCurvaProduto'), $(this)),
            listaOrdenacao
          );
        });

        criaGrafico($('#tabelaRelCurvaProduto').DataTable().data());
        await selecionaRegistroTabela();
        if ($('#tabelaRelCurvaProduto').DataTable().rows().count() > 0) {
          $($('#tabelaRelCurvaProduto tbody tr')[0]).trigger('click');
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  async function selecionaRegistroTabela() {
    $('#tabelaRelCurvaProduto tbody').unbind('click');
    $('#tabelaRelCurvaProduto tbody').on('click', 'tr', async function () {
      if ($(this).hasClass('selected')) {
        $(this).removeClass('selected');
        criaGrafico($('#tabelaRelCurvaProduto').DataTable().data());
        await buscaOrdemProducao();
      } else {
        $('#tabelaRelCurvaProduto').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        criaGrafico($('#tabelaRelCurvaProduto').DataTable().row($(this)).data());
        await buscaOrdemProducao($('#tabelaRelCurvaProduto').DataTable().row($(this)).data().CODIGO, `${$('#tabelaRelCurvaProduto').DataTable().row($(this)).data().CODIGO} - ${$('#tabelaRelCurvaProduto').DataTable().row($(this)).data().DESCRICAO}`);
      }
    });
  }

  function criaGrafico(tabela) {
    const item = !tabela[0] ? tabela : tabela[0];
    const propriedadesIgnoradas = ["CODIGO", "DESCRICAO", "DESEMPENHO", "TOTAL", "VARIANTES", "QTDE_PROD", "MEDIA_COR", "COR", "DESC_COR"];
    const novoObjeto = {};

    if (tabela[0]) {
      for (const propriedade in item) {
        if (!propriedadesIgnoradas.includes(propriedade)) {
          novoObjeto[propriedade] = 0;
        }
      }

      for (let i = 0; i < tabela.length; i++) {
        const objeto = tabela[i];
        for (const propriedade in objeto) {
          if (!propriedadesIgnoradas.includes(propriedade)) {
            novoObjeto[propriedade] += !objeto[propriedade] ? 0 : objeto[propriedade];
          }
        }
      }
      options.title.text = `Quantidade de vendas de todos os itens`;
    } else {
      for (const propriedade in item) {
        if (!propriedadesIgnoradas.includes(propriedade)) {
          novoObjeto[propriedade] = item[propriedade];
        }
      }
      options.title.text = `Quantidade de vendas do item ${item.CODIGO} - ${item.DESCRICAO}`;
    }


    let arrDadosGrafico = [];
    for (const itens in novoObjeto) {
      arrDadosGrafico.push({
        x: itens,
        y: !novoObjeto[itens] ? 0 : novoObjeto[itens]
      });
    }

    $('#chart').empty();

    options.series[0].data = arrDadosGrafico;
    const chart = new ApexCharts(document.querySelector("#chart"), options);
    chart.render();
    // FIM GRAFICO        
  }

  function criaGraficoProducao(keys, item) {
    keys.sort(function (a, b) {
      if (parseFloat(a.QTDE_PROD) < parseFloat(b.QTDE_PROD)) {
        return 1;
      } else if (parseFloat(a.QTDE_PROD) > parseFloat(b.QTDE_PROD)) {
        return -1;
      } else {
        return 0;
      }
    });

    let arrDadosGrafico = [];
    keys.map((item, index) => {
      if (index < 25) {
        arrDadosGrafico.push({
          x: `${item.COR} - ${item.DESC_COR}`,
          y: parseFloat(item.QTDE_PROD)
        });
      }
    });

    $('#chartProducao').empty();

    optionsProducao.series[0].data = arrDadosGrafico;
    optionsProducao.title.text = `Quantidade produzida do item ${item}`;
    chart = new ApexCharts(document.querySelector("#chartProducao"), optionsProducao);
    chart.render();
  }

  async function buscaOrdemProducao(codigo, item) {
    if ($.fn.DataTable.isDataTable('#tabelaOrdemProducao')) {
      $('#tabelaOrdemProducao').DataTable().destroy();
      $('#tabelaOrdemProducao').empty();
    }

    if (codigo == undefined) {
      return;
    }

    try {
      $.LoadingOverlay('show');
      try {
        listaOrdenacaoProduzido = [];
        const url = '/sisplan/impressao/v1/relcurvaproduto?';
        const params = await retornaFiltros(codigo);

        const response = await requisicao('GET', url, params, null, 150000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          return;
        }

        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        }

        const dataSetCols = [];
        const propriedades = ["COR", "DESC_COR", "QTDE_PROD"];
        const keys = Object.keys(jsonStr[0]);
        for (var k in keys) {
          if (propriedades.includes(keys[k]))
            dataSetCols.push({
              'title': keys[k],
              'data': keys[k]
            });
        };


        $('#tabelaOrdemProducao').DataTable({
          search: false,
          filter: false,
          order: [],
          sort: true,
          destroy: true,
          autoWidth: true,
          "colReorder": true,
          "data": jsonStr,
          "columns": dataSetCols,
          columnDefs: [
            {
              "targets": [2],
              "className": 'pr-4 text-right'
            }
          ]
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $($('#tabelaOrdemProducao').find('th')[2]).prop('title', 'Quantidade Produção');

        criaGraficoProducao(jsonStr, item);

        // const cabecalhoQtdeProd = $('#tabelaOrdemProducao thead tr th:eq(1)');
        // cabecalhoQtdeProd.prop('title', 'Quantidade Produção');

        // adiciona o botão na tabela e adiciona a função de abrir o modal
        $('#tabelaOrdemProducao_length').prepend('<button class="buttonColVis" id="buttonColVisProducao"><i class="fas fa-cogs"></i></button>');
        $('#tabelaOrdemProducao_length').prepend('<button class="buttonExcel" id="buttonExcelProducao"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVisProducao').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcelProducao').prop('title', 'Exportar')

        $('#buttonColVisProducao').on('click', async function () {
          grid = 2;
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcelProducao').on('click', async function () {
          const url = '/sisplan/impressao/v1/relcurvaproduto?';
          const params = await retornaFiltros(codigo);

          await exportaCSV(url, params, false, null, 'Relatório de Curva de Produto, tabela de quantidade produzida', '#tabelaOrdemProducao');
        })

        $('#tabelaOrdemProducao').DataTable().columns().every(function () {
          if ((colunasInvisiveis.curvaProdutoProducao).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });

        $('#tabelaOrdemProducao th').on('click', function () {
          listaOrdenacaoProduzido = adicionaOrdenacao(
            retornaDataSrcColuna($('#tabelaOrdemProducao'), $(this)),
            listaOrdenacaoProduzido
          );
        });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (grid == 1) {
      $('#tabelaRelCurvaProduto').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.curvaProduto ?? ['EMPRESA'])
    } else {
      $('#tabelaOrdemProducao').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.curvaProdutoProducao ?? ['EMPRESA'])
    }

  })

  $('#tutorial').on('click', function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os filtros padrões da tela.',
        position: 'right'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para Imprimir um relatório.',
        position: 'right'
      }
    },
    {
      element: '#tabelaRelCurvaProduto',
      popover: {
        title: 'Tabela',
        description: 'Aqui estão os dados dos produtos Filtrados.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});