$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma ordem de compra.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimirIndividual',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir as ordens de compras filtradas.',
          position: 'right'
        }
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  /////COLUNAS INVISIVEIS
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.tabelaOrcamento == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaOrcamento: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.tabelaItens == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaItens: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.tabelaAcerto == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaAcerto: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      if (localStorage.getItem('tabelaOrcamento') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaOrcamento: novasColunas }))
        $('#tabelaOrcamento').DataTable().columns().visible(true);
        $('#tabelaOrcamento').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('tabelaItens') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaItens: novasColunas }))
        $('#tabelaItens').DataTable().columns().visible(true);
        $('#tabelaItens').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('tabelaAcerto') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, tabelaAcerto: novasColunas }))
        $('#tabelaAcerto').DataTable().columns().visible(true);
        $('#tabelaAcerto').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }

      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (localStorage.getItem('tabelaOrcamento') == 'true') {
      $('#tabelaOrcamento').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.tabelaOrcamento ?? [], [])
    } else if (localStorage.getItem('tabelaItens') == 'true') {
      $('#tabelaItens').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.tabelaItens ?? [], [])
    } else if (localStorage.getItem('tabelaAcerto') == 'true') {
      $('#tabelaAcerto').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.tabelaAcerto ?? [], [])
    }
  })

  $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
    localStorage.removeItem('tabelaOrcamento')
    localStorage.removeItem('tabelaItens')
    localStorage.removeItem('tabelaAcerto')
  })

  await setarDataAtual('dtFim')

  const columnsOrcamento = [
    { "data": "ID", "title": "Número" },
    { "data": "CLIENTE", "title": "Cliente" },
    { "data": "VENDEDOR", "title": "Vendedor" },
    { "data": "STATUS", "title": "Status" },
    { "data": "DT_ENTREGA", "title": "Data de Entrega" },
    { "data": "VALOR_TOTAL", "title": "Valor Total" },
  ]

  const columnsEditarOrcamento = [
    { "data": "ID", "title": "Nº" },
    { "data": "CORTINA", "title": "Cortina" },
    { "data": "QUANTIDADE", "title": "Quantidade" },
    { "data": "LARGURA", "title": "Largura" },
    { "data": "ALTURA", "title": "Altura" },
    // { "data": "AMBIENTE", "title": "Valor Total" },
    // { "data": "INSTALACAO", "title": "Valor Total" },
    // { "data": "COMANDO", "title": "Valor Total" },
    { "data": "UN", "title": "Unidade" },
  ]

  const columnsItens = [
    { "data": "ID", "title": "Item" },
    { "data": "CORTINA", "title": "Cortina" },
    { "data": "COR", "title": "Cor" },
    { "data": "QUANTIDADE", "title": "Qtde." },
    { "data": "LARGURA", "title": "Largura" },
    { "data": "ALTURA", "title": "Altura" },
    { "data": "VAL_TOTAL", "title": "Valor Total" },
  ]

  const columnsSubItens = [
    { "data": "ID", "title": "Nº" },
    { "data": "CODIGO", "title": "Código" },
    { "data": "DESCRICAO", "title": "Descrição" },
    { "data": "TIPO_LT", "title": "Tipo LT" },
    { "data": "TM", "title": "TM" },
    { "data": "DIMENSAO", "title": "Dimensão" },
    { "data": "PARTES", "title": "Partes" },
    { "data": "QUANTIDADE", "title": "Qtde" },
    { "data": "UN", "title": "UN" },
    { "data": "VALOR", "title": "Valor" },
    { "data": "VAL_TOTAL", "title": "Total" },
  ]

  criaDataTablePadrao('#tabelaOrcamento', false, false, false, false, true, false, false, false, [], columnsOrcamento);
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, false, false, [], columnsItens);
  criaDataTablePadrao('#tabelaSubItens', false, false, false, false, true, false, false, false, [], columnsSubItens);

  const permissaoUsuarioLogado = await permissaoAcessos("ORCAMENTO_CORTINA");

  addFuncoesBotoes();

  $('#btnConsultar').on('click', async function () {
    buscaDados()
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "orcamento_cortina/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  // $('#tabelaOrcamento').on('click', '#btnEditar', async function () {
  //   if (permissaoUsuarioLogado.ALTERA == 'S') {
  //     const data = $('#tabelaOrcamento').DataTable().row($(this).parents('tr')).data();
  //     window.location.href = `orcamento_cortina/${data.ID}`;
  //     // else {
  //     //   msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");
  //     // }
  //   } else {
  //     msgAlertaSemConfirmacao("Sem permissão para alterar!");
  //   }
  // });

  $('#tabelaItens').on('click', '#btnEditar', async function () {
    $('#modalEditarOrcamento').modal('show')
    const data = $('#tabelaOrcamento').DataTable().row('.selected').data();
    const dataItem = $('#tabelaItens').DataTable().row($(this).parents('tr')).data();

    const response = await requisicao('GET', '/sisplan/orcamento_cortina/v1/busca_edicao_acesso?', `ID=${data.ID}&ID_ITEM=${dataItem.ID}&`);

    if (!response) {
      return;
    }

    if (response.status != 200) {
      const jsonStr = await response.json();
      msgAlerta(jsonStr.mensagem);
      return;
    }
    const jsonStr = await response.json();

    $("#tabelaEditarOrcamento").DataTable({
      searching: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      scrollX: true,
      info: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      columns: columnsEditarOrcamento,
      data: jsonStr, rowCallback: async function (row, data) {
        $(`td:eq(2)`, row).css('display', 'flex');
        $(`td:eq(2)`, row).empty().append(
          $('<input>', {
            type: 'number',
            min: 0,
            class: 'input-default focus form-control text-right txtQtdeItens',
            value: data.QUANTIDADE,
            // change: function () {
            //   if (data.QTDE_CONFERIDA > data.QTDE) {
            //     msgAlerta('Quantidade excedida, verifique!')
            //   }
            //   data.QTDE_CONFERIDA = $(this).val();
            //   rowData.QTDE_CONFERIDA = $(this).val()
            // },
            // blur: function () {
            //   try {
            //     const $row = $(this).closest('tr');
            //     const indexColumn = encontraIndexColuna('tabelaItens', 'Qtde_Conferida');
            //     const tabela = $('#tabelaItens').DataTable();
            //     const index = $row.index();
            //     const dados = tabela.data().toArray()[index];
            //     let qtdeConferida = parseFloat($(this).val()) || 0;

            //     if (qtdeConferida < 0) {
            //       qtdeConferida = 0;
            //     }

            //     const $input = $('.txtQtdeItens').eq(index);

            //     if (qtdeConferida > dados.QTDE_PENDENTE) {
            //       qtdeConferida = 0;
            //       $input.val(0).attr('value', 0);
            //       dados.QTDE_CONFERIDA = 0;
            //       $row.css('background-color', qtdeConferida === 0 ? 'transparent' : 'green')
            //         .removeClass('selected');
            //       throw new Error('Quantidade excedida, verifique!');
            //     }

            //     $input.val(qtdeConferida).attr('value', qtdeConferida);
            //     dados.QTDE_CONFERIDA = qtdeConferida;

            //     setTimeout(() => {
            //       $row.find('td').eq(indexColumn).find('input')
            //         .val(dados.QTDE_CONFERIDA)
            //         .trigger('change')
            //         .css('color', 'var(--font-color)');

            //       $row.css('background-color', qtdeConferida === 0 ? 'transparent' : 'green')
            //         .removeClass('selected');
            //     }, 0);

            //   } catch (error) {
            //     console.error(error);
            //     msgAlerta(error.message || 'Não foi possível atualizar a quantidade conferida!');
            //   } finally {
            //     VerificaQuantidadeBipada();
            //     VerificaQuantidadePendente();
            //   }
            // }
          }).css({
            width: '90%',
            'box-sizing': 'border-box'
          }),
        );
        $(`td:eq(3)`, row).empty().append(
          $('<input>', {
            type: 'number',
            min: 0,
            class: 'input-default focus form-control text-right txtQtdeItens',
            value: data.LARGURA,
          }).css({
            width: '90%',
            'box-sizing': 'border-box'
          }),
        );
        $(`td:eq(4)`, row).empty().append(
          $('<input>', {
            type: 'number',
            min: 0,
            class: 'input-default focus form-control text-right txtQtdeItens',
            value: data.ALTURA,
          }).css({
            width: '90%',
            'box-sizing': 'border-box'
          }),
        );
      },
    });

    setTimeout(() => {
      $("#tabelaEditarOrcamento").DataTable().columns.adjust().draw(false);
    }, 150)
  });

  $('#btnConfirmar').on('click', async function () {
    try {
      const response = await requisicao('GET', '/sisplan/orcamento_cortina/v1/orcamento_acesso?');

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }


    } catch (error) {
      msgAlerta(error.message || 'Não foi possível gravar as alterações do orcamento. Por favor, verifique!')
    } finally {

    }
  })

  await preencheOrdenacaoTela('RelConsignadoIndividual');
  retornaHintRelatorio('btnImprimirIndividual', 'RelConsignadoIndividual')

  $('#tabelaOrcamento').on('click', '#btnImprimirIndividual', async function () {
    try {
      const data = $('#tabelaOrcamento').DataTable().row($(this).closest('tr')).data();
      imprimirIndividual({ id: data.ID })

    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao validar os dados.')
    }
  });

  const imprimirIndividual = async ({ id }) => {
    $.LoadingOverlay('show');
    try {
      const url = `/sisplan/impressao/v1/imprimir_cortina_individual?`;
      const ordem = `&TELA_ORDENACAO=RelOrcamentoIndividual&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrcamentoIndividual');
      let arquivo = await GeraRelatorio(`${url}${ordem}&ID=${id}`, 'GET', 1000000, false, 'RelOrcamentoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
      msgErro('Ocorreu um erro ao realizar a impressão.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnImprimir').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/impressao/v1/imprimir_cortina?`;
      const filtros = await retornaFiltros()
      const ordem = `&TELA_ORDENACAO=RelOrcamentoCortina&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrcamentoCortina');
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelOrcamentoCortina');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
      msgErro('Ocorreu um erro ao realizar a impressão.')
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  retornaHintRelatorio('btnImprimirIndividual', 'RelOrcamentoCortinaIndividual')

  $('#tabelaOrcamento').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaOrcamento').DataTable().row($(this)).data();
      window.location.href = `orcamento_cortina/${data.ID}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  function retornaBotaoOpcoes(data, row) {
    var retorno = '<div style="text-align:start;" class="mx-1"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" style="max-height: 250px; overflow: scroll;scrollbar-gutter: stable; overflow-inline: auto;"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Criar Pedido" id="btnGerarPedido">Criar Pedido</button>     ' +
      '    <div class="dropdown-divider"></div>' +
      '    <button class="dropdown-item" type="button" title="Imprimir" id="btnImprimirIndividual">Imprimir</button>     ' +
      '</div>';
    return retorno;
  };

  function retornaBotaoOpcoesItens(data, row) {
    var retorno = '<div style="text-align:start;" class="mx-1"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" style="max-height: 250px; overflow: scroll;scrollbar-gutter: stable; overflow-inline: auto;"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      // '    <button class="dropdown-item" type="button" title="Criar Pedido" id="btnGerarPedido">Criar Pedido</button>     ' +
      // '    <div class="dropdown-divider"></div>' +
      // '    <button class="dropdown-item" type="button" title="Imprimir" id="btnImprimirIndividual">Imprimir</button>     ' +
      '</div>';
    return retorno;
  };

  function retornaFiltros() {
    const dtEntradaDe = $('#dtEntradaDe').val()
    const dtEntradaAte = $('#dtEntradaAte').val()
    const cliente = pegaChave('#txtCliente') != '' ? pegaChave('#txtCliente') : ''
    const vendedor = pegaChave('#txtVendedor') != '' ? pegaChave('#txtVendedor') : ''

    const retorno = `&ENTRADA_DE=${dtEntradaDe}` +
      `&ENTRADA_ATE=${dtEntradaAte}` +
      `&CLIENTE=${cliente}` +
      `&VENDEDOR=${vendedor}`;

    return retorno
  }

  buscaDados()

  async function buscaDados() {
    try {
      $.LoadingOverlay("show");
      if ($.fn.DataTable.isDataTable('#tabelaOrcamento')) {
        $('#tabelaOrcamento').DataTable().destroy();
        $('#tabelaOrcamento').empty();
      }
      if ($.fn.DataTable.isDataTable('#tabelaItens')) {
        $('#tabelaItens').DataTable().destroy();
        $('#tabelaItens').empty();
      }
      if ($.fn.DataTable.isDataTable('#tabelaSubItens')) {
        $('#tabelaSubItens').DataTable().destroy();
        $('#tabelaSubItens').empty();
      }

      const filtros = retornaFiltros()
      const response = await requisicao('GET', '/sisplan/orcamento_cortina/v1/orcamento_acesso?', filtros);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      const jsonStr = await response.json();

      $("#tabelaOrcamento").DataTable({
        searching: false,
        paging: true,
        destroy: true,
        lengthChange: false,
        scrollX: true,
        scrollY: '300px',
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columns: columnsOrcamento,
        data: jsonStr,
        columnDefs: [
          {
            render(data, type, row) {
              return retornaBotaoOpcoes(data, row);
            },
            targets: 0,
          }
        ],
      });

      $("#tabelaOrcamento tbody").on("click", "tr", async function (e) {
        if ($(e.target).hasClass('btnVerificaOpcoes')) {
          return;
        }

        $("#tabelaOrcamento tbody tr.selected").removeClass("selected");
        $(this).addClass("selected");

        setTimeout(async () => { await buscaItens() }, 50);
      });

      $('#tabelaOrcamento').DataTable().columns.adjust().draw();

      setTimeout(async () => { $("#tabelaOrcamento tbody tr td")[0].click() }, 50)

    } catch (error) {
      console.error(error.message || 'Não foi possível consultar os orçamentos');
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaOrcamento tbody").on("click", "tr", async function (e) {
    if ($(e.target).hasClass('btnVerificaOpcoes')) {
      return;
    }

    $("#tabelaOrcamento tbody tr.selected").removeClass("selected");
    $(this).addClass("selected");

    setTimeout(async () => { await buscaItens() }, 50);
  });


  $("#tabelaItens tbody").on("click", "tr", async function () {
    $("#tabelaItens tbody tr td")[0].click();
    $("#tabelaItens tbody tr.selected").removeClass("selected");
    $(this).addClass("selected");

    setTimeout(async () => { await buscaSubItens() }, 50)
  });

  async function buscaItens() {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy();
      $('#tabelaItens').empty();
    }
    try {
      const id = $('#tabelaOrcamento').DataTable().row('.selected').data().ID
      const response = await requisicao('GET', '/sisplan/orcamento_cortina/v1/orcamento_acesso_itens?', `ID=${id}&`);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }
      const jsonStr = await response.json();

      $("#tabelaItens").DataTable({
        destroy: true,
        paging: false,
        searching: false,
        info: false,
        lengthChange: false,
        pageLength: 6,
        scrollY: '200px',
        scrollX: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: columnsItens,
        data: jsonStr,

        // columnDefs: [
        //   {
        //     render(data, type, row) {
        //       return retornaBotaoOpcoesItens(data, row);
        //     },
        //     targets: 0,
        //   }
        // ],
      });

      $("#tabelaItens tbody").on("click", "tr", async function () {
        $("#tabelaItens tbody tr td")[0].click();
        $("#tabelaItens tbody tr.selected").removeClass("selected");
        $(this).addClass("selected");

        setTimeout(async () => { await buscaSubItens() }, 100)
      });

      $('#tabelaItens').DataTable().columns.adjust().draw();

      setTimeout(async () => { $("#tabelaItens tbody tr td")[0].click() }, 50)
    } catch (error) {
      console.error(error);
    }
  };

  async function buscaSubItens() {
    if ($.fn.DataTable.isDataTable('#tabelaSubItens')) {
      $('#tabelaSubItens').DataTable().destroy();
      $('#tabelaSubItens').empty();
    }
    try {

      const idItem = $('#tabelaItens').DataTable().row('.selected').data().ID
      const id = $('#tabelaOrcamento').DataTable().row('.selected').data().ID

      if (!id) return
      const response = await requisicao('GET', '/sisplan/orcamento_cortina/v1/orcamento_acesso_subitens?', `ID=${id}&ID_ITEM=${idItem}&`);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }
      const jsonStr = await response.json();

      $("#tabelaSubItens").DataTable({
        destroy: true,
        paging: false,
        searching: false,
        info: false,
        lengthChange: false,
        pageLength: 6,
        scrollY: '200px',
        scrollX: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: columnsSubItens,
        data: jsonStr,
        columnDefs: [],
      });
      $('#tabelaSubItens').DataTable().columns.adjust().draw();
    } catch (error) {
      console.error(error);
    }
  };

  function addFuncoesBotoes() {
    componenteFiltro('cliente', false, false)
    componenteFiltro('vendedor', false)
    // componenteFiltro('status', false, false, '', [`ORCAMENTO = 'S'`])
    // componenteFiltro('tabPreco')
    // componenteFiltro('consignado', true, true)

    // componenteFiltro('cliente', false, false, 'ClienteNFE')
    // componenteFiltro('operacao', false, false, 'OperacaoNFE')

    // componenteFiltro('status', false, false, 'StatusAltera', ["ORCAMENTO = 'S'"])

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtCliente').val('');
      $('#txtVendedor').val('');
      $('#txtStatus').val('');
      $("#txtTabPreco").val('');
      $("#dtAcertoIni").val("1200-01-01");
      $("#dtAcertoFim").val("2500-12-01");

      $('#txtConsignado').empty().trigger('change');
      $('#txtConsignado').val('');
      $('#txtConsignado').attr('data-chave', '');
      $('#txtConsignado').attr('data-desc', '');

      const date = new Date();
      const firstDay = new Date(date.getFullYear(), 0, 1);//ta setando a data de inicio sempre pro primeiro dia do ano, melhor pra consultar em larga escala e não quebrar o datatable
      $('#dtIni').val(formataData(firstDay));
      await setarDataAtual('dtFim')
    });
  };

  $("#tabelaOrcamento").on("click", "#btnGerarPedido", async function () {
    $.LoadingOverlay("show");
    try {
      const permissaoUsuarioLogadoPedido = await permissaoAcessos("PEDIDO");
      if (permissaoUsuarioLogadoPedido.INCLUI == "S") {
        // msgAlerta('Deseja criar um Pedido a partir da Proposta Comercial?', async () => {
        const data = $("#tabelaOrcamento").DataTable().row($(this).parents("tr")).data();
        // if (parseInt(data.EMP_ID) != parseInt(getCookie('emp_id'))) {
        //   msgAlertaSemConfirmacao('Este orçamento não pertence a esta empresa. Impossível gerar pedido!')
        //   return
        // }
        await gerarPedido(data);
        // });
      } else {
        msgAlertaSemConfirmacao("Sem permissão para incluir pedidos!");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  async function gerarPedido(data) {
    $.LoadingOverlay('show')
    try {
      // if (await Existe('PEDIDO', ['ORCAMENTO'], [data.NUMERO])) {
      //   throw new Error('Orçamento já virou pedido, impossível continuar.');
      // }

      const parametrosComercial = await BuscaParametrosPedido();
      const bNaoGeraCondPagto = parametrosComercial[15].VALOR == '1';

      const sNumero = await RetornaProximo('NUMERO', 'PEDIDO', 'NUMERO', 5)

      const pesquisaParam = {
        tabela: "ORCADECOR",
        camposSelect: [
          "ENTIDADE.CODCLI", "REPRESEN.CODREP", "ORCADECOR.DT_ENTREGA",
          "MOEDA.CODMOE MOEDA"
        ],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.ID = ORCADECOR.ID_ENT' },
          { tabela: 'REPRESEN', condicao: 'REPRESEN.ID = ORCADECOR.ID_REP' },
          { tabela: 'MOEDA', condicao: 'MOEDA.ID = ORCADECOR.ID_MOEDA' },
        ],
        where: [`ORCADECOR.ID = '${data.ID}'`]
      };

      const jsonStrPed = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

      let tabPre = ''

      if (!tabPre) {
        tabPre = '999'
      }

      const recSimula = await retornaRecSimula(sNumero, data.ID)
      const pgto = recSimula.pgto

      const condPgto = bNaoGeraCondPagto ? [] : recSimula.condicoes;

      const { arrItens, arrServico } = await retornaItens(data.ID)
      const depositoPadrao = (await buscaValor('DEPOSITO', 'CODIGO', 'PRIORIDADE', '1')).CODIGO;

      const despesa = arrServico.reduce(
        (acc, item) => acc + item.DESPESAS,
        0,
      );

      const dadosOs = jsonStrPed[0]
      const pedido = {
        NUMERO: sNumero,
        PED_CLI: '',
        CODCLI: dadosOs.CODCLI,
        CODREP: dadosOs.CODREP,
        CIF: '',
        COM1: 0,
        COM2: 0,
        DTDIGITA: retornaDataAtual(),
        DT_EMISSAO: retornaDataAtual(),
        TAB_TRANS: '',
        FATURA: 100,
        EMP_FAT: getCookie('g_empresa_logada').substring(1),
        DESPESA: despesa,
        // DT_SAIDA: dadosOs.DT_SAIDA,
        // DT_FATURA: dadosOs.DT_SAIDA,
        ENTREGA: dadosOs.DT_ENTREGA,
        IND_QTDE: 100,
        TAB_PRE2: '00',
        // BLOQUEIO: dadosOs.BLOQ_COM,
        // FINANCEIRO: parametrosComercial[2].VALOR,
        PERIODO: '0',
        MOEDA: dadosOs.MOEDA,
        // SIT_DUP: dadosOs.SIT_DUP,
        // CLASSE_GER: dadosOs.CLASSE_GER,
        // HISTORICO: dadosOs.HISTORICO,
        // STATUS: dadosOs.STATUS,
        // STATUS_PED: dadosOs.STATUS,
        ID_TIPO: 0,
        // FRETE: dadosOs.FRETE,
        // NATUREZA: dadosOs.NATUREZA,
        // PESO_BRUTO: dadosOs.PESO_BRUTO,
        // PESO_LIQ: dadosOs.PESO_LIQ,
        // VOLUMES: dadosOs.VOLUMES,
        PGTO: pgto,
        // PER_DESC: dadosOs.PER_DESC,
        ORCAMENTO: data.ID,
        BONIFICACAO: 'N',
        // PRZ_MEDIO: dadosOs.PRZ_MEDIO,
        // OBS: dadosOs.OBS,
        // REC_SIMULA: arrRecSimula,
        EMP_ID: getCookie('emp_id'),
        DEPOSITO: depositoPadrao,
        TAB_PRE: tabPre,
        COND_PAGTOS: condPgto,
        ITENS: arrItens
      };

      const response = await requisicao('POST', '/sisplan/pedido/v1/pedido?', `&BARRAS_LOG=${encodeURIComponent(JSON.stringify({ BARRAS: [] }))}`, encodeURIComponent(JSON.stringify(pedido)), 90000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');

      // if (valEntrada && valEntrada > 0) {
      //   msgAlerta('Deseja gerar uma antecipação com o valor de entrada?',
      //     async () => { await abreModalAntecipacao(data.NUMERO, sNumero, valEntrada) },
      //     () => { callBackImprimir(data.NUMERO, sNumero) },
      //     () => { },
      //     () => { callBackImprimir(data.NUMERO, sNumero) },
      //   )
      // } else {
      //   callBackImprimir(data.NUMERO, sNumero)
      // }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function retornaItens(numOs) {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: "ORCADECOR",
        camposSelect: [
          "MATERIAL.CODIGO", "CADCOR.COR", "ORCADECOR_SUBIT.QUANTIDADE", "ORCADECOR_SUBIT.VALOR",
          "ORCADECOR_SUBIT.ID", "ORCADECOR_SUBIT.TM"
        ],
        leftJoin: [
          { tabela: 'ORCADECOR_ITENS', condicao: 'ORCADECOR.ID = ORCADECOR_ITENS.ID_ORCADECOR' },
          { tabela: 'ORCADECOR_SUBIT', condicao: 'ORCADECOR_ITENS.ID = ORCADECOR_SUBIT.ID_ORCADECOR_ITENS' },
          { tabela: 'MATERIAL', condicao: 'MATERIAL.ID = ORCADECOR_SUBIT.ID_MAT' },
          { tabela: 'CADCOR', condicao: 'CADCOR.ID = ORCADECOR_ITENS.ID_COR' },
        ],
        where: [`ORCADECOR.ID = '${numOs}'`]
      };

      const jsonStrItens = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

      let arrItens = [];
      let arrServico = [];
      for (let i = 0; i < jsonStrItens.length; i++) {
        const item = jsonStrItens[i]
        let codigo = item.CODIGO

        // if ((item.TIPO_PROD == 'N' || item.TIPO_PROD == 'P') || (!await Existe('PRODUTO', ['CODIGO'], [item.CODIGO]))) {
        //   codigo = prototipo.CODIGO
        // }
        if (item.TM == 'MP') {
          arrItens.push({
            CODIGO: item.CODIGO,//BUSCAR O CÓDIGO DO MATERIAL(ID_MAT),
            COR: item.COR, //BUSCAR A COR DO PRODUTO
            QTDE: item.QUANTIDADE, // BUSCAR A QUANTIDADE DO ITEM
            QTDE_ORIG: item.QUANTIDADE, // BUSCAR A QUANTIDADE DO ITEM
            PRECO: item.VALOR, //BUSCAR O PRECO
            PRECO_ORIG: item.VALOR, //BUSCAR O PRECO
            DESC_ITEM: 0, //BUSCAR O PRECO
            TIPO: 'M',
            QUALIDADE: '1',
            ORDEM: item.ID, //ID DA TABELA

            // OBSERVACAO: item.OBS2 // QUALQUER COISA
          })
        } else if (item.TM == 'SE') {
          arrServico.push({
            DESPESAS: item.VALOR * item.QUANTIDADE
          })
        }
      }

      return { arrItens, arrServico };

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function retornaRecSimula(numeroPed, numOs) {
    $.LoadingOverlay('show')
    try {
      let sCondicoes = '';
      let valEntrada;
      const pesquisaParam = {
        tabela: "COND_PAGTO",
        camposSelect: [
          "NUMERO", "CODCOND", "DT_VENCTO", "ORDEM", "TIPO", "MANTER_VENCTO",
          "VALOR", "DIAS", "MOEDA", "FLUXO", "ID", "PERC_ENTRADA"
        ],
        where: [`NUMERO = '${numOs}'`]
      };

      const jsonStrRec = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

      let arrCondicoes = [];
      let i = 1;
      jsonStrRec.map((item, index) => {
        const vencto = new Date(item.DT_VENCTO);

        let diffStr = item.DIAS

        arrCondicoes.push({
          DIAS: item.DIAS,
          DT_VENCTO: vencto,
          MOEDA: item.CODCOND,
          VALOR: item.VALOR,
          TIPO: 'P',
          NUMERO: numeroPed,
          ORDEM: i++
        })

        sCondicoes += diffStr + ' ';
      });

      return { condicoes: arrCondicoes, pgto: sCondicoes.trim() };

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  $('#btnConsultar').trigger('click')

});