$(document).ready(async function () {
  $('.campoFloat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  })

  $('#modalHistoricoNegociacao').on('shown.bs.modal', () => {
    setTimeout(
      () => $('#tabelaHistoricoNegociacao')?.DataTable()?.columns?.adjust()?.draw(false),
      300,
    )
  })
})

window.ModalHistoricoNegociacaoCotacao = window.ModalHistoricoNegociacaoCotacao || {}

ModalHistoricoNegociacaoCotacao.carregar = (dados) => {
  ModalHistoricoNegociacaoCotacao.criarTabelaHistorico(dados.registros)
  $('#tituloModalHistoricoNegociacao').html(`Histórico de Negociação - [${dados.codigo} - ${dados.descricao}]`)
  $('#modalHistoricoNegociacao').modal('show')
}

ModalHistoricoNegociacaoCotacao.criarTabelaHistorico = (data = []) => {
  if ($.fn.DataTable.isDataTable('#tabelaHistoricoNegociacao')) {
    $('#tabelaHistoricoNegociacao').DataTable().destroy()
    $('#tabelaHistoricoNegociacao').empty()
  }

  const columns = [
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return retornarFloatFormatadoEmMonetario({ valor: 0, quantidadeCasasDecimais: 4 })
        }
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 4 })
      },
    },
    {
      data: 'respondidoEm',
      title: 'Respondido Em',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, separador: '/', reverso: true })
      }
    },
  ]

  $('#tabelaHistoricoNegociacao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '200px',
  })
}

ModalHistoricoNegociacaoCotacao.buscarDados = async (id) => {
  const response = await requisicao("GET", `/sisplan/centralcompras/cotacao/v1/historiconegociacao?`, `ID=${id}`, '', 3600000)

  const json = await response.json()

  if (json) {
    const { resultado, mensagem } = json
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }

    return resultado
  }
}